/*
 * Decompiled with CFR 0.152.
 */
package sampl;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import sampl.DiagnosticException;
import sampl.SAMPLException;
import sampl.Source;
import sampl.lang.Translator;

public final class App {
    public static void main(String[] args) throws Exception {
        CommandLine cl;
        Options options = new Options();
        options.addOption("h", "help", false, "print this message");
        options.addOption("v", "version", false, "print version");
        options.addOption("c", "compile", false, "compile AMPL files to Java bytecode; the name of the first input file with extension replaced with .class is taken as name of the class file with the main method");
        options.addOption(null, "dump-bytecode", false, "dump generated Java bytecode");
        options.addOption(null, "no-sema", false, "don't do semantic analysis and subsequent translation");
        options.addOption(null, "no-codegen", false, "don't generate the code");
        options.addOption(null, "no-exec", false, "don't execute the code");
        options.addOption(null, "pause", false, "pause before parse until enter is pressed");
        options.addOption(null, "time", false, "show translation time");
        options.addOption("i", "interactive", false, "run in interactive mode");
        try {
            cl = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return;
        }
        if (cl.hasOption("help")) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp("sampl [options] [file [file] ...]", options);
            return;
        }
        if (cl.hasOption("version")) {
            Properties props = new Properties();
            props.load(App.class.getResourceAsStream("/META-INF/application.properties"));
            String version = props.getProperty("version");
            System.out.println("SAMPL version " + version);
            return;
        }
        args = cl.getArgs();
        Source[] sources = new Source[args.length];
        int i = 0;
        while (i < args.length) {
            try {
                sources[i] = Source.newFileSource(args[i]);
            }
            catch (FileNotFoundException e) {
                System.out.println("Can't open file " + e.getMessage());
                return;
            }
            ++i;
        }
        Translator.Options translatorOptions = new Translator.Options();
        translatorOptions.compile = cl.hasOption("compile");
        translatorOptions.dumpBytecode = cl.hasOption("dump-bytecode");
        translatorOptions.noSema = cl.hasOption("no-sema");
        translatorOptions.noCodegen = cl.hasOption("no-codegen");
        translatorOptions.noExec = cl.hasOption("no-exec");
        translatorOptions.time = cl.hasOption("time");
        translatorOptions.pause = cl.hasOption("pause");
        translatorOptions.interactive = cl.hasOption("interactive");
        Translator translator = null;
        try {
            try {
                translator = new Translator(translatorOptions);
                translator.run(sources);
            }
            catch (DiagnosticException e) {
                PrintStream out = System.out;
                out.print(e.getSourceName());
                out.print(": ");
                out.print(e.getLineNumber());
                out.print(": ");
                out.println(e.getMessage());
                if (translator != null) {
                    translator.close();
                }
            }
            catch (SAMPLException e) {
                System.out.println(e.getMessage());
                if (translator != null) {
                    translator.close();
                }
            }
        }
        finally {
            if (translator != null) {
                translator.close();
            }
        }
    }
}

