/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.wizards;

import com.ampl.ide.wizards.NewFolderPageOne;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class NewFolderWizard
extends Wizard {
    protected NewFolderPageOne one;
    private Path saveDir;

    public NewFolderWizard(Path directory) {
        this.setWindowTitle("New Folder Wizard");
        this.saveDir = directory;
    }

    public void addPages() {
        this.one = new NewFolderPageOne(this.saveDir);
        this.addPage((IWizardPage)this.one);
    }

    public boolean performFinish() {
        Path newFolder;
        block5: {
            String newFilename = this.one.getFoldername();
            newFolder = Paths.get(this.one.getSaveDir().toString(), newFilename);
            if (!Files.notExists(newFolder.getParent(), new LinkOption[0])) break block5;
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Parent directory does not exist.");
            return false;
        }
        try {
            Files.createDirectory(newFolder, new FileAttribute[0]);
        }
        catch (InvalidPathException invalidPathException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Invalid path to folder!");
            return false;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Folder already exists!");
            return false;
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Error in creating folder!");
            return false;
        }
        return true;
    }
}

