/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.wizards;

import com.ampl.ide.AMPLService;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewFolderPageOne
extends WizardPage
implements Listener {
    private Text saveDirText;
    private Text newFolderText;
    private Path defaultSaveDir;

    public NewFolderPageOne(Path saveDir) {
        super("New Folder Wizard");
        this.setTitle("New Folder");
        this.setDescription("Create a new folder");
        this.setPageComplete(false);
        if (saveDir == null) {
            AMPLService s = (AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class);
            saveDir = Paths.get(s.console().workingDir(), new String[0]);
        }
        this.defaultSaveDir = saveDir;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.verticalSpacing = 15;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDirectoryArea(container);
        this.createNewFolderNameArea(container);
        this.setControl((Control)container);
    }

    private void createDirectoryArea(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("Directory: ");
        this.saveDirText = new Text(composite, 2052);
        this.saveDirText.setText(this.defaultSaveDir.toString());
        this.saveDirText.addListener(2, (Listener)this);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.saveDirText.setLayoutData((Object)gd);
        Button browse = new Button(composite, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(NewFolderPageOne.this.getShell());
                dlg.setText("Create New Folder");
                dlg.setMessage("Select a directory:");
                String dir = dlg.open();
                if (dir != null) {
                    NewFolderPageOne.this.saveDirText.setText(dir);
                }
                NewFolderPageOne.this.setPageComplete(NewFolderPageOne.this.validatePage());
            }
        });
    }

    private void createNewFolderNameArea(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("New Folder Name: ");
        this.newFolderText = new Text(composite, 2052);
        this.newFolderText.setText("");
        this.newFolderText.addListener(2, (Listener)this);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 4;
        this.newFolderText.setLayoutData((Object)gd);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean validatePage() {
        boolean validation = true;
        String errorMsg = null;
        try {
            Paths.get(this.newFolderText.getText(), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage("New folder name is not valid.");
            return false;
        }
        try {
            Path newFolderPath = Paths.get(this.getSaveDir().toString(), this.newFolderText.getText());
            if (Files.exists(newFolderPath, new LinkOption[0])) {
                errorMsg = "Folder already exists.";
            }
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage("Invalid Path.");
            return false;
        }
        if (this.newFolderText.getText().isEmpty() || this.newFolderText.getText() == null) {
            errorMsg = "Folder name cannot be empty.";
        }
        if (this.saveDirText.getText().isEmpty() || this.saveDirText.getText() == null) {
            errorMsg = "Save Directory cannot be empty.";
        }
        try {
            Path saveDir = Paths.get(this.saveDirText.getText(), new String[0]);
            if (!Files.isWritable(saveDir)) {
                errorMsg = "No permission to write in Save Directory";
            }
        }
        catch (InvalidPathException invalidPathException) {
            errorMsg = "Save Directory location is not valid.";
        }
        if (errorMsg != null) {
            validation = false;
        }
        this.setErrorMessage(errorMsg);
        return validation;
    }

    public Path getSaveDir() {
        return Paths.get(this.saveDirText.getText(), new String[0]);
    }

    public String getFoldername() {
        return this.newFolderText.getText();
    }

    public void setVisible(boolean visible) {
        this.newFolderText.setFocus();
        super.setVisible(visible);
    }
}

