/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.wizards;

import com.ampl.ide.views.internal.CDEModel.IDEUtil;
import com.ampl.ide.wizards.NewFilePageOne;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewFileWizard
extends Wizard {
    protected NewFilePageOne one;
    private java.nio.file.Path saveDir;

    public NewFileWizard(java.nio.file.Path directory) {
        this.setWindowTitle("New File Wizard");
        this.saveDir = directory;
    }

    public void addPages() {
        this.one = new NewFilePageOne(this.saveDir);
        this.addPage((IWizardPage)this.one);
    }

    public boolean performFinish() {
        java.nio.file.Path newFile;
        block5: {
            String newFilename = String.valueOf(this.one.getFilename()) + this.one.getExtension();
            newFile = Paths.get(this.one.getSaveDir().toString(), newFilename);
            if (!Files.notExists(newFile.getParent(), new LinkOption[0])) break block5;
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Parent directory does not exist.");
            return false;
        }
        try {
            Files.createFile(newFile, new FileAttribute[0]);
            this.openFileInEditor(newFile.toString());
        }
        catch (InvalidPathException invalidPathException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Invalid path to file!");
            return false;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"File already exists!");
            return false;
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"Error in creating file!");
            return false;
        }
        return true;
    }

    private void openFileInEditor(String path) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDEUtil.checkDefaultEditor(fileStore);
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)("Cannot open newly created file - " + path));
            }
        }
    }
}

