/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.wizards;

import com.ampl.ide.AMPLService;
import com.ampl.ide.commands.internal.FileExtension;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewFilePageOne
extends WizardPage
implements Listener {
    private Text saveDirText;
    private Text filenameText;
    private Path defaultSaveDir;
    private Combo fileTypeCombo;
    private FileExtension defaultExt;

    public NewFilePageOne(Path saveDir) {
        super("New File Wizard");
        this.setTitle("New File");
        this.setDescription("Create a new file");
        this.setPageComplete(false);
        if (saveDir == null) {
            AMPLService s = (AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class);
            saveDir = Paths.get(s.console().workingDir(), new String[0]);
        }
        this.defaultSaveDir = saveDir;
        this.defaultExt = FileExtension.MODEL;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.verticalSpacing = 15;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDirectoryArea(container);
        this.createFilenameArea(container);
        this.createFileExtensionArea(container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        this.filenameText.setFocus();
        super.setVisible(visible);
    }

    private void createFileExtensionArea(Composite composite) {
        FileExtension[] extList;
        Label label = new Label(composite, 0);
        label.setText("File Extension: ");
        this.fileTypeCombo = new Combo(composite, 4);
        FileExtension[] fileExtensionArray = extList = FileExtension.values();
        int n = extList.length;
        int n2 = 0;
        while (n2 < n) {
            FileExtension ext = fileExtensionArray[n2];
            this.fileTypeCombo.add(ext.extension());
            ++n2;
        }
        this.fileTypeCombo.select(this.fileTypeCombo.indexOf(this.defaultExt.extension()));
        this.fileTypeCombo.addListener(13, (Listener)this);
        this.fileTypeCombo.addListener(2, (Listener)this);
    }

    private void createFilenameArea(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("File Name: ");
        this.filenameText = new Text(composite, 2052);
        this.filenameText.setText("");
        this.filenameText.addListener(2, (Listener)this);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 4;
        this.filenameText.setLayoutData((Object)gd);
    }

    private void createDirectoryArea(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("Directory: ");
        this.saveDirText = new Text(composite, 2052);
        this.saveDirText.setText(this.defaultSaveDir.toString());
        this.saveDirText.addListener(2, (Listener)this);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.saveDirText.setLayoutData((Object)gd);
        Button browse = new Button(composite, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(NewFilePageOne.this.getShell());
                dlg.setText("Create New File");
                dlg.setMessage("Select a directory:");
                dlg.setFilterPath(NewFilePageOne.this.defaultSaveDir.toString());
                String dir = dlg.open();
                if (dir != null) {
                    NewFilePageOne.this.saveDirText.setText(dir);
                }
                NewFilePageOne.this.setPageComplete(NewFilePageOne.this.validatePage());
            }
        });
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean validatePage() {
        boolean validation = true;
        String errorMsg = null;
        try {
            Paths.get(this.getExtension(), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage("File type is not valid.");
            return false;
        }
        String file = String.valueOf(this.getFilename()) + this.getExtension();
        try {
            Paths.get(file, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage("File name is not valid.");
            return false;
        }
        try {
            Path newFilePath = Paths.get(this.getSaveDir().toString(), file);
            if (Files.exists(newFilePath, new LinkOption[0])) {
                errorMsg = "File already exists.";
            }
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage("Invalid Path.");
            return false;
        }
        if (this.filenameText.getText().isEmpty() || this.filenameText.getText() == null) {
            errorMsg = "File name cannot be empty.";
        }
        if (this.saveDirText.getText().isEmpty() || this.saveDirText.getText() == null) {
            errorMsg = "Save Directory cannot be empty.";
        }
        try {
            Path saveDir = Paths.get(this.saveDirText.getText(), new String[0]);
            if (!Files.isWritable(saveDir)) {
                errorMsg = "No permission to write in Save Directory";
            }
        }
        catch (InvalidPathException invalidPathException) {
            errorMsg = "Save Directory location is not valid.";
        }
        if (errorMsg != null) {
            validation = false;
        }
        this.setErrorMessage(errorMsg);
        return validation;
    }

    public Path getSaveDir() {
        return Paths.get(this.saveDirText.getText(), new String[0]);
    }

    public String getFilename() {
        return this.filenameText.getText();
    }

    public String getExtension() {
        String ext = this.fileTypeCombo.getText();
        if (!ext.isEmpty() && ext != null && ext.charAt(0) != '.') {
            ext = "." + ext;
        }
        return ext;
    }
}

