/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.views.internal;

import com.ampl.ide.AMPLService;
import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.views.CDEView;
import com.ampl.ide.views.internal.FileSystemRoots;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class RootChangeAction
extends Action
implements IMenuCreator {
    private Menu menu;
    private FileSystemRoots rootDirs;

    public RootChangeAction(CDEView view) {
        super("Change Root", 4);
        this.setImageDescriptor(view.getImageDescriptor("tree_mode.gif"));
        this.rootDirs = new FileSystemRoots();
        this.setMenuCreator(this);
    }

    public void dispose() {
        this.disposeMenu();
    }

    void disposeMenu() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        this.menu = new Menu(parent);
        List<Path> roots = this.rootDirs.listRoots();
        for (Path root : roots) {
            RootAction rootAct = new RootAction(root);
            this.addActionToMenu(this.menu, rootAct);
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private class RootAction
    extends Action {
        private Path rootCurrDir;

        public RootAction(Path root) {
            super(root.toString());
            this.rootCurrDir = root;
        }

        public void run() {
            AMPLConsole console = ((AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class)).console();
            try {
                Path prevCurrDir = Paths.get(console.workingDir(), new String[0]);
                if (!Files.isSameFile(this.rootCurrDir, prevCurrDir.getRoot())) {
                    RootChangeAction.this.rootDirs.updateRootCurrDir(prevCurrDir);
                }
                console.setWorkingDir(RootChangeAction.this.rootDirs.getRootCurrDir(this.rootCurrDir.getRoot()).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

