/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.views.internal;

import com.ampl.ide.AMPLService;
import com.ampl.ide.IWorkingDirListener;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class FileSystemRoots {
    private Map<Path, Path> rootsMap = new HashMap<Path, Path>();
    private String rootCurrDirPath = "RootCurrentDir";

    public FileSystemRoots() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ampl.ide");
        Preferences rootCurrDirNode = preferences.node(this.rootCurrDirPath);
        Iterable<Path> dirs = FileSystems.getDefault().getRootDirectories();
        for (Path root : dirs) {
            if (!Files.isReadable(root)) continue;
            Path rootCurrDir = Paths.get(rootCurrDirNode.get(root.toString(), root.toString()), new String[0]);
            this.rootsMap.put(root, rootCurrDir);
        }
        AMPLService s = (AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class);
        s.console().addWorkingDirListener(new IWorkingDirListener(){

            @Override
            public void workingDirChanged(String dir) {
                if (dir == null) {
                    return;
                }
                FileSystemRoots.this.updateRootCurrDir(Paths.get(dir, new String[0]));
            }
        });
        this.cleanPrefs();
    }

    public List<Path> listRoots() {
        ArrayList<Path> rootsList = new ArrayList<Path>();
        Iterable<Path> dirs = FileSystems.getDefault().getRootDirectories();
        for (Path root : dirs) {
            if (!Files.isReadable(root)) continue;
            rootsList.add(root);
        }
        return rootsList;
    }

    public void updateRootCurrDir(Path currDir) {
        this.rootsMap.put(currDir.getRoot(), currDir);
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ampl.ide");
        Preferences rootCurrDirNode = preferences.node(this.rootCurrDirPath);
        rootCurrDirNode.put(currDir.getRoot().toString(), currDir.toString());
    }

    public Path getRootCurrDir(Path root) {
        return this.rootsMap.get(root);
    }

    private void cleanPrefs() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ampl.ide");
        Preferences rootCurrDirNode = preferences.node(this.rootCurrDirPath);
        Iterable<Path> dirs = FileSystems.getDefault().getRootDirectories();
        try {
            String[] prefKeys = rootCurrDirNode.keys();
            int prefKeysSize = prefKeys.length;
            if (prefKeysSize != 0) {
                int i = 0;
                while (i < prefKeysSize) {
                    boolean exists = false;
                    for (Path root : dirs) {
                        if (prefKeys[i] != root.toString()) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        rootCurrDirNode.remove(prefKeys[i]);
                    }
                    ++i;
                }
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

