/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.views.internal.CDEModel;

import com.ampl.ide.views.internal.CDEModel.CDEObject;
import com.ampl.ide.views.internal.WindowsShortcut;
import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDEResource
extends CDEObject {
    private Path defaultRoot = Paths.get(System.getProperty("user.home"), new String[0]);
    private List<CDEResource> children;

    public CDEResource(String path) {
        if (path != null) {
            Path newRoot = Paths.get(path, new String[0]);
            if (Files.exists(newRoot, new LinkOption[0])) {
                this.path = newRoot;
                return;
            }
            throw new InvalidPathException(path, "Path does not exist.");
        }
        this.path = this.defaultRoot;
    }

    public CDEResource(Path aFile, CDEObject parent) {
        try {
            if (Platform.isWindows() && CDEResource.isPotentialValidLink(aFile)) {
                WindowsShortcut linkFile = new WindowsShortcut(aFile);
                aFile = Paths.get(linkFile.getRealFilename(), new String[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.path = aFile;
        this.parent = parent;
    }

    public CDEResource[] getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        } else {
            this.updateChildren();
        }
        return this.children.toArray(new CDEResource[this.children.size()]);
    }

    private void updateChildren() {
        List<CDEResource> newChildren = this.createChildren();
        ListIterator<CDEResource> oldIter = this.children.listIterator();
        while (oldIter.hasNext()) {
            CDEResource oldChild = oldIter.next();
            boolean deleteFlag = true;
            Path oldPath = oldChild.getFile();
            ListIterator<CDEResource> newIter = newChildren.listIterator();
            while (newIter.hasNext()) {
                CDEResource newChild = newIter.next();
                Path newPath = newChild.getFile();
                try {
                    if (!Files.isSameFile(oldPath, newPath)) continue;
                    deleteFlag = false;
                    newIter.remove();
                }
                catch (IOException iOException) {}
            }
            if (!deleteFlag) continue;
            oldIter.remove();
        }
        if (!newChildren.isEmpty()) {
            for (CDEResource addChild : newChildren) {
                this.children.add(addChild);
            }
        }
        Collections.sort(this.children, new AlphabeticalComparator());
    }

    private List<CDEResource> createChildren() {
        ArrayList<CDEResource> childList = new ArrayList<CDEResource>();
        if (Files.isReadable(this.path)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                    for (Path file : stream) {
                        try {
                            BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            if (attrs.isOther() || this.isHidden(file)) continue;
                            try {
                                childList.add(new CDEResource(file, this));
                            }
                            catch (InvalidPathException invalidPathException) {}
                        }
                        catch (AccessDeniedException accessDeniedException) {}
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | DirectoryIteratorException x) {
                x.printStackTrace();
            }
        }
        return childList;
    }

    private boolean isHidden(Path path) {
        boolean hidden = false;
        try {
            if (Platform.isWindows()) {
                DosFileAttributes attrs = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
                hidden |= attrs.isHidden();
            } else {
                hidden |= Files.isHidden(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hidden;
    }

    public boolean isAMPLFile() {
        String ext = CDEResource.getExtension(this.path);
        Pattern p = Pattern.compile("mod|dat|run|ampl", 2);
        Matcher matcher = p.matcher(ext);
        return matcher.matches();
    }

    public boolean isSAMPLFile() {
        String ext = CDEResource.getExtension(this.path);
        Pattern p = Pattern.compile("sampl", 2);
        Matcher matcher = p.matcher(ext);
        return matcher.matches();
    }

    public static boolean isPotentialValidLink(Path file) {
        boolean extensionTest = CDEResource.getExtension(file).toLowerCase().equals("lnk");
        boolean fileTest = Files.isRegularFile(file, new LinkOption[0]);
        return extensionTest && fileTest;
    }

    public boolean isFile() {
        Path file = this.path;
        boolean isFile = !Files.isDirectory(file, new LinkOption[0]);
        return isFile;
    }

    public String getFileExtension() {
        return CDEResource.getExtension(this.path);
    }

    private class AlphabeticalComparator
    implements Comparator<CDEResource> {
        private AlphabeticalComparator() {
        }

        @Override
        public int compare(CDEResource res1, CDEResource res2) {
            return res1.getName().compareTo(res2.getName());
        }
    }
}

