/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.views.internal.CDEModel;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class CDEObject {
    protected Path path;
    protected CDEObject parent;

    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public String getPath() {
        return this.path.toString();
    }

    public Path getFile() {
        return this.path;
    }

    public String getName() {
        Path pathURI = Paths.get(this.path.toUri());
        Path name = pathURI.getFileName();
        String nameStr = "";
        nameStr = name != null ? name.toString() : pathURI.toString();
        return nameStr;
    }

    public Path getParentDir() {
        return this.path.getParent();
    }

    public boolean hasParentDir() {
        return this.path.getParent() != null;
    }

    public String rootParentDir() {
        String parent = this.path.getParent().toString();
        if (parent != null) {
            return parent;
        }
        return this.getPath();
    }

    public CDEObject getParent() {
        return this.parent;
    }

    protected static String getExtension(Path aPath) {
        String ext = "";
        String filename = aPath.getFileName().toString();
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

