/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.views;

import com.ampl.ide.AMPLService;
import com.ampl.ide.IWorkingDirListener;
import com.ampl.ide.commands.internal.CommandsWithRefresh;
import com.ampl.ide.commands.internal.IRefreshViewsListener;
import com.ampl.ide.views.internal.CDEContentProvider;
import com.ampl.ide.views.internal.CDELabelProvider;
import com.ampl.ide.views.internal.CDEModel.CDEResource;
import com.ampl.ide.views.internal.CDEModel.FolderFileSorter;
import com.ampl.ide.views.internal.CDEModel.IDEUtil;
import com.ampl.ide.views.internal.RootChangeAction;
import com.sun.jna.Platform;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.FrameworkUtil;

public class CDEView {
    public static final String ID = "com.ampl.ide.CurrDirExplorer";
    protected TreeViewer treeViewer;
    protected Text text;
    protected CDEResource root;
    private Action changeRoot;
    protected ViewerComparator folderFileSorter;
    @Inject
    private IWorkbenchPartSite site;
    @Inject
    private IViewPart viewPart;
    @Inject
    private AMPLService service;

    public CDEView() {
        CommandsWithRefresh.addRefreshViewListener(new IRefreshViewsListener(){

            @Override
            public void requireRefresh() {
                CDEView.this.refresh();
            }
        });
    }

    @Inject
    public void createPartControl(Composite parent) {
        this.service.openAMPLConsole();
        this.service.console().addWorkingDirListener(new IWorkingDirListener(){

            @Override
            public void workingDirChanged(final String dir) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CDEView.this.setRoot(dir);
                    }
                });
            }
        });
        Composite cdeview = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        cdeview.setLayout((Layout)layout);
        this.text = new Text(cdeview, 2052);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(cdeview);
        this.treeViewer.setContentProvider((IContentProvider)new CDEContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CDELabelProvider());
        this.treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.site.setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.addListeners();
        this.initSorters();
        this.createActions();
        this.createContextMenu();
        this.createToolbar();
        this.createHandlers();
        this.setRoot(this.service.console().workingDir());
    }

    private void setRoot(String dir) {
        try {
            this.root = new CDEResource(dir);
            this.treeViewer.setInput((Object)this.root);
            this.text.setText(this.root.getPath());
        }
        catch (InvalidPathException invalidPathException) {
            MessageDialog.openError((Shell)this.site.getShell(), (String)"Error!", (String)("Invalid Directory: '" + dir + "'"));
        }
    }

    private void createActions() {
        this.changeRoot = new RootChangeAction(this);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.viewPart.getViewSite().getActionBars().getToolBarManager();
        if (Platform.isWindows()) {
            mgr.add((IAction)this.changeRoot);
        }
    }

    private void createHandlers() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler refreshHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CDEView.this.refresh();
                return null;
            }
        };
        handlerService.activateHandler("com.ampl.ide.cde.refresh", (IHandler)refreshHandler);
        AbstractHandler upDirHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CDEView.this.goUpOneDirectory();
                return null;
            }
        };
        handlerService.activateHandler("com.ampl.ide.cde.updir", (IHandler)upDirHandler);
    }

    private void initSorters() {
        this.folderFileSorter = new FolderFileSorter();
        this.treeViewer.setComparator(this.folderFileSorter);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    protected void goUpOneDirectory() {
        if (this.root.hasParentDir()) {
            this.service.console().setWorkingDir(this.root.rootParentDir());
        }
    }

    private void addListeners() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                Object selectedObject;
                if (event.getSelection() instanceof IStructuredSelection && (selectedObject = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof CDEResource) {
                    CDEView.this.openElement((CDEResource)selectedObject);
                }
            }
        });
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 8) {
                    CDEView.this.goUpOneDirectory();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CDEView.this.text.setText(CDEView.this.root.getPath());
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    String dir = CDEView.this.text.getText();
                    if (!CDEView.this.service.console().setWorkingDir(dir)) {
                        CDEView.this.text.setText(CDEView.this.root.getPath());
                        CDEView.this.text.selectAll();
                    }
                }
            }
        });
    }

    protected void openElement(CDEResource element) {
        if (element.isDirectory()) {
            this.service.console().setWorkingDir(element.getPath());
            return;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.getPath()));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDEUtil.checkDefaultEditor(fileStore);
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
    }

    public ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        try {
            URL installURL = FrameworkUtil.getBundle(CDEView.class).getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected void refresh() {
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        TreePath[] treePaths = this.treeViewer.getExpandedTreePaths();
        this.treeViewer.refresh();
        this.treeViewer.setExpandedElements(expandedElements);
        this.treeViewer.setExpandedTreePaths(treePaths);
        this.treeViewer.getControl().setRedraw(true);
    }

    @Focus
    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public java.nio.file.Path getSelectedDir() {
        java.nio.file.Path path = null;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object selectedObject = selection.getFirstElement();
        if (selectedObject instanceof CDEResource) {
            CDEResource element = (CDEResource)selectedObject;
            if (element.isDirectory()) {
                path = element.getFile();
            } else {
                path = element.getParentDir();
                if (path == null) {
                    this.root.getFile();
                }
            }
        }
        return path;
    }
}

