/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.preferences;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class EnvPathPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List list;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.ampl.ide"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list = new List(composite, 2564);
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initList();
        this.createFileButtons(composite);
        Label label = new Label(composite, 0);
        label.setText("Warning! AMPL IDE must be restarted in order for any changes to take effect.");
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        return composite;
    }

    private void initList() {
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("com.ampl.ide");
        String defaultValue = DefaultScope.INSTANCE.getNode("com.ampl.ide").get("EnvironmentPath", "");
        String values = preferences.get("EnvironmentPath", defaultValue);
        String[] individualValues = values.split(System.getProperty("path.separator"));
        int i = 0;
        while (i < individualValues.length) {
            this.list.add(individualValues[i]);
            ++i;
        }
    }

    private void createFileButtons(Composite parent) {
        Composite fileButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        fileButtons.setLayout((Layout)layout);
        fileButtons.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        Button addButton = new Button(fileButtons, 8);
        addButton.setText("Add");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(EnvPathPreferencePage.this.getShell());
                dlg.setText("Add Folder to Path");
                dlg.setMessage("Select a directory:");
                String dir = dlg.open();
                if (dir != null) {
                    EnvPathPreferencePage.this.list.add(dir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = new Button(fileButtons, 8);
        removeButton.setText("Remove");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = EnvPathPreferencePage.this.list.getSelectionIndex();
                if (index >= 0) {
                    EnvPathPreferencePage.this.list.remove(index);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void performDefaults() {
        this.list.removeAll();
        String defaultValue = DefaultScope.INSTANCE.getNode("com.ampl.ide").get("EnvironmentPath", "");
        String[] individualValues = defaultValue.split(System.getProperty("path.separator"));
        if (individualValues.length != 0) {
            int i = 0;
            while (i < individualValues.length) {
                this.list.add(individualValues[i]);
                ++i;
            }
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("com.ampl.ide");
        String[] values = this.list.getItems();
        String mergedValue = "";
        int i = 0;
        while (i < values.length) {
            mergedValue = String.valueOf(mergedValue) + values[i] + System.getProperty("path.separator");
            ++i;
        }
        preferences.put("EnvironmentPath", mergedValue);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }
}

