/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.AMPLService;
import com.ampl.ide.Log;
import com.ampl.ide.launching.AMPLProcess;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import sampl.Util;

class WindowsAMPLProcess
extends AMPLProcess {
    private Signaller signaller;

    private static Process start(ProcessBuilder pb, Signaller s) throws IOException {
        int port = s.port();
        pb.environment().put("AMPLSIG_PORT", Integer.toString(port));
        Process p = pb.start();
        return p;
    }

    private WindowsAMPLProcess(ILaunch launch, ProcessBuilder pb, String name, Signaller s) throws IOException {
        super(launch, WindowsAMPLProcess.start(pb, s), name, pb.directory().getPath());
        this.signaller = s;
        s.start();
        File libdir = new File(launch.getAttribute("com.ampl.ide.PluginDir"), "lib");
        File amplsig = new File(libdir, "amplsig.dll");
        this.getStreamsProxy().write("load " + Util.quote((String)amplsig.toString()) + ";");
    }

    WindowsAMPLProcess(ILaunch launch, ProcessBuilder pb, String name) throws IOException {
        this(launch, pb, name, new Signaller());
    }

    public boolean canTerminate() {
        return this.signaller.canInterrupt();
    }

    public void terminate() {
        this.signaller.interrupt();
    }

    @Override
    public void stop(AMPLService service) throws DebugException {
        try {
            super.stop(service);
        }
        finally {
            this.signaller.stop();
        }
    }

    private static class Signaller
    implements Runnable {
        private ServerSocket serverSocket;
        private Socket socket;
        private volatile Writer writer;

        Signaller() throws IOException {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            this.serverSocket = new ServerSocket(0, 1, InetAddress.getByAddress(byArray));
        }

        int port() {
            return this.serverSocket.getLocalPort();
        }

        void start() {
            new Thread(this).start();
        }

        void stop() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
        }

        boolean canInterrupt() {
            return this.writer != null;
        }

        boolean interrupt() {
            if (this.writer == null) {
                return false;
            }
            try {
                this.writer.write("SIGINT\n");
                this.writer.flush();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }

        @Override
        public void run() {
            try {
                this.socket = this.serverSocket.accept();
                this.writer = new OutputStreamWriter(this.socket.getOutputStream());
            }
            catch (IOException e) {
                Log.log(e);
            }
        }
    }
}

