/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.launching.AMPLProcess;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.IOException;
import java.util.Scanner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

class UnixAMPLProcess
extends AMPLProcess {
    private static final int SIGINT = 2;
    private volatile boolean canInterrupt;

    private static int getAMPLVersion(String amplPath) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(amplPath, "-v");
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        try (Scanner scanner = new Scanner(p.getInputStream());){
            String s = scanner.findInLine(".*\\d{8}");
            int n = s != null ? Integer.parseInt(s.substring(s.length() - 8)) : 0;
            return n;
        }
    }

    private long getPID() {
        Process p = this.getSystemProcess();
        if (p == null) {
            return -1L;
        }
        return p.pid();
    }

    private static boolean addOptions(ProcessBuilder pb) throws IOException {
        int amplVersion = UnixAMPLProcess.getAMPLVersion(pb.command().get(0));
        if (amplVersion >= 20110906) {
            pb.command().add(1, "-g");
            return true;
        }
        return false;
    }

    private UnixAMPLProcess(ILaunch launch, ProcessBuilder pb, String name, boolean canInterrupt) throws IOException {
        super(launch, pb.start(), name, pb.directory().getPath());
        if (!canInterrupt) {
            return;
        }
        this.getStreamsProxy().getOutputStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                if (text.equals("ampl: ")) {
                    UnixAMPLProcess.this.canInterrupt = true;
                    monitor.removeListener((IStreamListener)this);
                }
            }
        });
    }

    UnixAMPLProcess(ILaunch launch, ProcessBuilder pb, String name) throws IOException {
        this(launch, pb, name, UnixAMPLProcess.addOptions(pb));
    }

    public boolean canTerminate() {
        return this.canInterrupt;
    }

    public void terminate() {
        if (!this.canInterrupt) {
            return;
        }
        long pgid = CLibrary.INSTANCE.getpgid(this.getPID());
        if (pgid != -1L) {
            CLibrary.INSTANCE.killpg(pgid, 2);
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public long getpgid(long var1);

        public int killpg(long var1, int var3);
    }
}

