/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.IWorkingDirListener;
import com.ampl.ide.Log;
import com.ampl.ide.console.AMPLConsole;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class PatternMatchListener
implements IPatternMatchListener {
    protected TextConsole console;
    protected String workingDir;

    public PatternMatchListener(AMPLConsole console) {
        this.workingDir = console.workingDir();
        console.addWorkingDirListener(new IWorkingDirListener(){

            @Override
            public void workingDirChanged(String dir) {
                PatternMatchListener.this.setWorkingDir(dir);
            }
        });
    }

    protected void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }

    public static abstract class AbstractHyperlink
    implements IHyperlink {
        private TextConsole console;
        private String workingDir;

        protected final void openInEditor(String filename, int lineNumber) {
            File errorFile = new File(filename);
            Path path = null;
            path = errorFile.isAbsolute() ? new Path(errorFile.toString()) : new Path(new File(this.workingDir, filename).toString());
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)path);
            if (!store.fetchInfo().exists()) {
                return;
            }
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                IEditorPart part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
                if (lineNumber == 0 || !(part instanceof ITextEditor)) {
                    return;
                }
                ITextEditor editor = (ITextEditor)part;
                IDocumentProvider provider = editor.getDocumentProvider();
                IEditorInput input = editor.getEditorInput();
                IRegion line = provider.getDocument((Object)input).getLineInformation(lineNumber - 1);
                editor.selectAndReveal(line.getOffset(), line.getLength());
            }
            catch (Exception e) {
                Log.log(e);
            }
        }

        protected abstract void matchedLine(String var1);

        public AbstractHyperlink(TextConsole console, String projectPath) {
            this.console = console;
            this.workingDir = projectPath;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IRegion region = this.console.getRegion((IHyperlink)this);
            int offset = region.getOffset();
            try {
                IDocument document = this.console.getDocument();
                int lineNumber = document.getLineOfOffset(offset);
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int lineOffset = lineInfo.getOffset();
                this.matchedLine(document.get(lineOffset, lineInfo.getLength()));
            }
            catch (BadLocationException e) {
                Log.log(e);
            }
        }
    }
}

