/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.AMPLService;
import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.launching.AMPLProcess;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import sampl.Util;

public class LaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String AMPL_ID = "com.ampl.ide.launching.ampl";

    private static File getWorkingDir(List<?> projectNames) {
        if (projectNames.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject((String)projectNames.get(0));
        return new File(root.getRawLocation().toString(), project.getFullPath().toString());
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 2);
            if (monitor.isCanceled()) {
                return;
            }
            List projectNames = configuration.getAttribute("ampl.projectNames", Collections.emptyList());
            File workingDir = LaunchDelegate.getWorkingDir(projectNames);
            if (workingDir == null) {
                return;
            }
            try {
                AMPLService service = (AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class);
                File includeDir = new File(service.pluginDir(), "include");
                StringBuilder command = new StringBuilder();
                command.append("print;\n");
                command.append("reset;\n");
                command.append("option ampl_include " + Util.quote((String)(".\n" + includeDir.getPath())) + ";\n");
                String prelaunchFilename = "prelaunch.ampl";
                if (new File(includeDir, prelaunchFilename).exists()) {
                    command.append("model " + Util.quote((String)prelaunchFilename) + ";\n");
                }
                monitor.worked(1);
                AMPLProcess process = service.amplProcess();
                File solutionFile = null;
                List paths = configuration.getAttribute("ampl.relativePaths", Collections.emptyList());
                String redirection = null;
                if (new File("/dev/null").exists()) {
                    redirection = "> /dev/null";
                } else if (new File("NUL").exists()) {
                    redirection = "> NUL";
                }
                command.append("cd " + Util.quote((String)workingDir.toString()) + " " + redirection + ";");
                for (Object obj : paths) {
                    String path = obj.toString();
                    if (path.toLowerCase().endsWith(".dat")) {
                        command.append("data");
                    } else {
                        command.append("model");
                    }
                    command.append(" ").append(Util.quote((String)path));
                    command.append(";\n");
                }
                if (configuration.getAttribute("ampl.autoSolve", false)) {
                    String ext = ".sol";
                    solutionFile = File.createTempFile("ampl", ext);
                    String solutionPath = solutionFile.getAbsolutePath();
                    command.append("solve;\n");
                    command.append("param __sol_filename symbolic = '");
                    command.append(solutionPath);
                    command.append("';");
                    command.append("model writesol.ampl;");
                }
                command.append("option prompt1 'ampl: ';\n");
                AMPLConsole console = process.getConsole();
                if (console instanceof TextConsole) {
                    TextConsole textConsole = (TextConsole)console;
                    textConsole.addPatternMatchListener((IPatternMatchListener)new PromptListener());
                }
                process.getStreamsProxy().write(command.toString());
                monitor.worked(1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static class PromptListener
    implements IPatternMatchListener {
        private TextConsole console;

        private PromptListener() {
        }

        public void connect(TextConsole console) {
            this.console = console;
        }

        public void disconnect() {
            this.console = null;
        }

        public void matchFound(PatternMatchEvent event) {
            if (this.console == null) {
                return;
            }
            this.console.removePatternMatchListener((IPatternMatchListener)this);
        }

        public String getPattern() {
            return "ampl: ";
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }
    }
}

