/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.AMPLService;
import com.ampl.ide.Log;
import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.launching.IAMPLProcessTerminateListener;
import com.ampl.ide.launching.ProcessTerminatedListenerList;
import com.ampl.ide.launching.UnixAMPLProcess;
import com.ampl.ide.launching.WindowsAMPLProcess;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class AMPLProcess
extends RuntimeProcess
implements ProcessTerminatedListenerList {
    static final String PLUGIN_DIR_ATTR = "com.ampl.ide.PluginDir";
    static final String PROMPT = "ampl: ";
    private static AMPLConsole console;
    private ListenerList<IAMPLProcessTerminateListener> processTerminatedList = new ListenerList();

    AMPLProcess(ILaunch launch, Process process, String name, String workingDir) {
        super(launch, process, name, null);
        console = new AMPLConsole(this, "AMPL", null, workingDir);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
    }

    public static AMPLProcess start(AMPLService service, IStreamListener sl, Map<String, String> env, IEclipsePreferences prefs) throws IOException, CoreException {
        String amplPath = service.amplPath();
        Log.log(String.format("Starting ampl: %s", amplPath));
        ProcessBuilder pb = new ProcessBuilder(amplPath, "-b4");
        Log.log(String.format("Environment: %s", env));
        String workingDir = prefs.get("WorkingDirectory", null);
        if (workingDir == null || !Files.exists(Paths.get(workingDir, new String[0]), new LinkOption[0])) {
            workingDir = System.getProperty("user.home");
        }
        pb.directory(new File(workingDir));
        pb.redirectErrorStream(true);
        pb.environment().putAll(env);
        ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchMgr.getLaunchConfigurationType("com.ampl.ide.launching.ampl");
        ILaunchConfigurationWorkingCopy config = configType.newInstance(null, "main");
        ILaunch launch = config.launch("run", null);
        launch.setAttribute(PLUGIN_DIR_ATTR, service.pluginDir());
        String name = "";
        AMPLProcess p = Platform.isWindows() ? new WindowsAMPLProcess(launch, pb, name) : new UnixAMPLProcess(launch, pb, name);
        DebugUIPlugin.getDefault().getProcessConsoleManager().launchRemoved(launch);
        IStreamsProxy proxy = p.getStreamsProxy();
        if (sl != null) {
            proxy.getOutputStreamMonitor().addListener(sl);
        }
        proxy.write("option prompt1 'ampl: ';\n");
        return p;
    }

    public void stop(AMPLService service) throws DebugException {
        if (this.canTerminate()) {
            this.processTerminatedList.clear();
            this.terminate();
            this.terminate();
        } else {
            super.terminate();
        }
    }

    public AMPLConsole getConsole() {
        return console;
    }

    public boolean sendAMPLCommand(String command) {
        if (console != null) {
            console.typeAndSendUICommand(command);
            return true;
        }
        return false;
    }

    @Override
    public void addListener(IAMPLProcessTerminateListener listener) {
        this.processTerminatedList.add((Object)listener);
    }

    @Override
    public void removeListener(IAMPLProcessTerminateListener listener) {
        this.processTerminatedList.remove((Object)listener);
    }

    @Override
    public Object[] getListeners() {
        return this.processTerminatedList.getListeners();
    }

    private void notifyTerminateListeners() {
        Object[] objectArray = this.processTerminatedList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IAMPLProcessTerminateListener)listener).amplProcessTerminated();
            ++n2;
        }
    }

    protected void fireTerminateEvent() {
        super.fireTerminateEvent();
        this.notifyTerminateListeners();
    }
}

