/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.launching;

import com.ampl.ide.Log;
import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.launching.PatternMatchListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class AMPLErrorListener
extends PatternMatchListener {
    private static String re1 = "(.*), line ([0-9]+) \\(offset [0-9]+\\):";
    private static String re2 = "\\(file (.*), line ([0-9]+), offset [0-9]+\\):";

    public AMPLErrorListener(AMPLConsole console) {
        super(console);
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            this.console.addHyperlink((IHyperlink)new Hyperlink(this.console, this.workingDir), event.getOffset(), event.getLength() - 1);
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    public String getPattern() {
        return "(" + re1 + ")|(" + re2 + ")";
    }

    private static class Hyperlink
    extends PatternMatchListener.AbstractHyperlink {
        private static Pattern pattern1 = Pattern.compile(re1);
        private static Pattern pattern2 = Pattern.compile(re2);

        public Hyperlink(TextConsole console, String projectPath) {
            super(console, projectPath);
        }

        @Override
        protected void matchedLine(String line) {
            Matcher m = pattern1.matcher(line);
            if (m.matches()) {
                this.openInEditor(m.group(1), Integer.parseInt(m.group(2)));
                return;
            }
            m = pattern2.matcher(line);
            if (m.matches()) {
                this.openInEditor(m.group(1), Integer.parseInt(m.group(2)));
            }
        }
    }
}

