/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.Log;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.FastPartitioner;
import sampl.Diagnostic;
import sampl.DiagnosticHandler;
import sampl.SAMPLException;
import sampl.Source;
import sampl.ast.Condition;
import sampl.ast.EmptyStmt;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.Option;
import sampl.ast.Stmt;
import sampl.parser.Action;
import sampl.parser.DeclAction;
import sampl.parser.DeclKind;
import sampl.parser.EmptyAction;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.parser.Token;
import sampl.parser.TokenKind;

public class Partitioner
extends FastPartitioner {
    private final String positionCategory;
    private boolean isInitialized;
    private Position[] cachedPositions;
    private final IdentifierTable identifiers;
    private Action action = new Action();
    private int partitionStart;
    private int partitionEnd;
    private int regionOffset;
    private int partitionIndex;
    public static final String DATA_CONTENT_TYPE = "__data";

    private void addPartition(int offset, int length, String contentType) throws SAMPLException {
        try {
            TypedPosition p;
            if (this.cachedPositions != null) {
                this.fEndOffset = offset + length;
                while (this.partitionIndex < this.cachedPositions.length) {
                    p = this.cachedPositions[this.partitionIndex];
                    if (this.fEndOffset <= p.offset + p.length) break;
                    this.fDocument.removePosition(this.positionCategory, (Position)p);
                    ++this.partitionIndex;
                }
                if (this.partitionIndex < this.cachedPositions.length) {
                    p = (TypedPosition)this.cachedPositions[this.partitionIndex];
                    if (offset == p.offset && length == p.length && contentType == p.getType()) {
                        ++this.partitionIndex;
                        throw new CancelParse();
                    }
                }
            }
            p = new TypedPosition(offset, length, contentType);
            this.fDocument.addPosition(this.positionCategory, (Position)p);
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
        catch (BadPositionCategoryException e) {
            Log.log(e);
        }
    }

    private void parse(int start, boolean isData) {
        this.regionOffset = this.fEndOffset = start;
        this.partitionEnd = 0;
        this.partitionStart = 0;
        try {
            Parser parser = new Parser((sampl.parser.Action)this.action, this.identifiers, (DiagnosticHandler)this.action);
            parser.setSkipLists();
            parser.parse(Source.newStringSource((String)"<doc>", (String)this.fDocument.get(start, this.fDocument.getLength() - start)), isData);
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
        catch (CancelParse cancelParse) {
        }
        catch (SAMPLException e) {
            Log.log(e);
        }
    }

    public Partitioner(IdentifierTable it) {
        super(null, new String[]{DATA_CONTENT_TYPE});
        this.identifiers = it;
        this.positionCategory = this.getManagingPositionCategories()[0];
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.clearPositionCache();
        this.cachedPositions = null;
        this.parse(0, false);
    }

    public IRegion documentChanged2(DocumentEvent e) {
        int reparseStart;
        block18: {
            if (!this.isInitialized) {
                return null;
            }
            reparseStart = -1;
            try {
                Assert.isTrue((e.getDocument() == this.fDocument ? 1 : 0) != 0);
                this.cachedPositions = this.getPositions();
                Position[] positions = this.cachedPositions;
                reparseStart = e.getOffset();
                this.partitionIndex = this.fDocument.computeIndexInCategory(this.positionCategory, reparseStart);
                boolean isData = false;
                if (this.partitionIndex > 0) {
                    TypedPosition partition = (TypedPosition)positions[this.partitionIndex - 1];
                    int end = partition.getOffset() + partition.getLength();
                    if (reparseStart <= end) {
                        reparseStart = partition.getOffset();
                        --this.partitionIndex;
                    } else {
                        reparseStart = end;
                    }
                    isData = partition.getType() == DATA_CONTENT_TYPE;
                } else {
                    reparseStart = positions.length != 0 && reparseStart > positions[0].getOffset() ? positions[0].getOffset() : 0;
                }
                int changeEnd = e.getOffset() + e.getLength();
                while (this.partitionIndex < positions.length) {
                    Position p = positions[this.partitionIndex];
                    if (p.offset >= changeEnd) break;
                    this.fDocument.removePosition(this.positionCategory, p);
                    ++this.partitionIndex;
                }
                String newText = e.getText();
                int newLength = newText != null ? newText.length() : 0;
                int shift = newLength - e.getLength();
                if (shift != 0) {
                    int i = this.partitionIndex;
                    while (i < positions.length) {
                        positions[i].offset += shift;
                        ++i;
                    }
                }
                this.parse(reparseStart, isData);
                while (this.partitionIndex < positions.length) {
                    Position p = positions[this.partitionIndex];
                    if (p.offset < this.fEndOffset) {
                        this.fDocument.removePosition(this.positionCategory, p);
                        ++this.partitionIndex;
                        continue;
                    }
                    break;
                }
            }
            catch (BadPositionCategoryException x) {
                Log.log(x);
                this.clearPositionCache();
                this.cachedPositions = null;
                break block18;
            }
            catch (BadLocationException x) {
                try {
                    Log.log(x);
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.clearPositionCache();
                    this.cachedPositions = null;
                }
            }
            this.clearPositionCache();
            this.cachedPositions = null;
        }
        return new Region(reparseStart, this.fEndOffset - reparseStart);
    }

    private class Action
    extends EmptyAction
    implements DiagnosticHandler {
        private boolean parsingStmt;
        private final Stmt DATA_STMT = new EmptyStmt(-1);

        private Action() {
        }

        private void handleStmt(int start, int end) {
            if (end == -1) {
                end = start;
            }
            int startOffset = start;
            int endOffset = ++end;
            if (!this.parsingStmt) {
                this.parsingStmt = true;
                Partitioner.this.partitionStart = startOffset;
                Partitioner.this.partitionEnd = endOffset;
                return;
            }
            if (startOffset < Partitioner.this.partitionStart) {
                Partitioner.this.partitionStart = startOffset;
            }
            if (endOffset > Partitioner.this.partitionEnd) {
                Partitioner.this.partitionEnd = endOffset;
            }
        }

        public void onSourceEnd() {
            Partitioner.this.fEndOffset = Partitioner.this.fDocument.getLength();
        }

        public DeclAction onDecl(DeclKind kind, Token start, Token name, Token alias) {
            this.parsingStmt = false;
            Partitioner.this.partitionStart = start.getStartPosition();
            return this;
        }

        public void onDeclEnd(int semiPos) throws SAMPLException {
            if (semiPos == -1) {
                return;
            }
            Partitioner.this.partitionEnd = semiPos + 1;
            Partitioner.this.addPartition(Partitioner.this.regionOffset + Partitioner.this.partitionStart, Partitioner.this.partitionEnd - Partitioner.this.partitionStart, "__dftl_partition_content_type");
        }

        public void onTopLevelStmt(Stmt stmt) throws SAMPLException {
            Partitioner.this.addPartition(Partitioner.this.regionOffset + Partitioner.this.partitionStart, Partitioner.this.partitionEnd - Partitioner.this.partitionStart, stmt == this.DATA_STMT ? Partitioner.DATA_CONTENT_TYPE : "__dftl_partition_content_type");
            this.parsingStmt = false;
        }

        public Stmt onEmptyStmt(Token semi) {
            int pos = semi.getStartPosition();
            this.handleStmt(pos, pos);
            return Stmt.INVALID;
        }

        public Stmt onJumpStmt(Token keyword, Token loopName, int semiPos) {
            this.handleStmt(keyword.getStartPosition(), semiPos);
            return Stmt.INVALID;
        }

        public Stmt onBasicStmt(Token keyword, Expr expr, Expr filename, int semiPos) {
            this.handleStmt(keyword.getStartPosition(), semiPos);
            return keyword.is(TokenKind.KW_data) ? this.DATA_STMT : Stmt.INVALID;
        }

        public Stmt onIncludeStmt(Token keyword, Expr expr, Token end) {
            int endPos = end.getStartPosition();
            if (end.is(TokenKind.STRING)) {
                endPos += ((String)end.getData()).length() - 1;
            }
            this.handleStmt(keyword.getStartPosition(), endPos);
            return Stmt.INVALID;
        }

        public Stmt onOptionStmt(int optionPos, List<Option> options, int semiPos) {
            this.handleStmt(optionPos, semiPos);
            return Stmt.INVALID;
        }

        public Stmt onCheckStmt(int checkPos, int semiPos) {
            this.handleStmt(checkPos, semiPos);
            return Stmt.INVALID;
        }

        public Stmt onLetStmt(int letPos, Indexing indexing, Expr lhs, Expr rhs, int semiPos) {
            this.handleStmt(letPos, semiPos);
            return Stmt.INVALID;
        }

        public Stmt onIfStmt(int ifPos, Expr condition, Stmt thenStmt, Stmt elseStmt) {
            this.handleStmt(ifPos, ifPos);
            return Stmt.INVALID;
        }

        public Stmt onForStmt(int pos, Indexing indexing, Stmt body) {
            this.handleStmt(pos, pos);
            return Stmt.INVALID;
        }

        public Stmt onRepeatStmt(int repeatPos, Condition pre, Stmt body, Condition post, int semiPos) {
            this.handleStmt(repeatPos, semiPos);
            return Stmt.INVALID;
        }

        public Stmt onCompoundStmt(int lbracePos, List<Stmt> stmts, int rbracePos) {
            this.handleStmt(lbracePos, rbracePos);
            return Stmt.INVALID;
        }

        public Stmt onIOStmt(Token keyword, Indexing indexing, List<Expr> exprs, Action.Redirection r, int semiPos) {
            this.handleStmt(keyword.getStartPosition(), semiPos);
            return Stmt.INVALID;
        }

        public Stmt onProblemStmt(int problemPos, Expr ref, int semiPos) {
            this.handleStmt(problemPos, semiPos);
            return Stmt.INVALID;
        }

        public Stmt onTableIOStmt(Token keyword, int tablePos, Expr ref, int semiPos) {
            this.handleStmt(keyword.getStartPosition(), semiPos);
            return Stmt.INVALID;
        }

        public void onSetDataStart(int setPos, Token name, Action.Subscript sub) {
            this.parsingStmt = false;
            Partitioner.this.partitionStart = setPos;
        }

        public void onDataStart(Token keyword, Token name, Token defaultValue) {
            this.parsingStmt = false;
            Partitioner.this.partitionStart = keyword.getStartPosition();
        }

        public void onDataStart(Token keyword, Token defaultValue, Token setName, List<Token> paramNames) {
            this.parsingStmt = false;
            Partitioner.this.partitionStart = keyword.getStartPosition();
        }

        public void onDataEnd(int semiPos) throws SAMPLException {
            if (semiPos == -1) {
                return;
            }
            Partitioner.this.partitionEnd = semiPos + 1;
            Partitioner.this.addPartition(Partitioner.this.regionOffset + Partitioner.this.partitionStart, Partitioner.this.partitionEnd - Partitioner.this.partitionStart, Partitioner.DATA_CONTENT_TYPE);
        }

        public void diagnostic(Diagnostic d) {
        }
    }

    private static class CancelParse
    extends SAMPLException {
        private static final long serialVersionUID = 1L;

        public CancelParse() {
            super("");
        }
    }
}

