/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.editors.Images;
import com.ampl.ide.editors.Section;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.ObjectiveDecl;
import sampl.ast.ParameterDecl;
import sampl.ast.SetDecl;
import sampl.ast.VariableDecl;

class OutlineNode
implements IWorkbenchAdapter,
IAdaptable {
    private String label;
    private ImageDescriptor image;
    private static final OutlineNode[] NO_NODES = new OutlineNode[0];
    private OutlineNode[] children;
    private OutlineNode parent;
    private int offset;
    private int length;

    OutlineNode(Section section, List<OutlineNode> children) {
        this.label = section.toString();
        this.image = section.image;
        this.children = new OutlineNode[children.size()];
        children.toArray(this.children);
        for (OutlineNode child : children) {
            child.parent = this;
        }
    }

    OutlineNode(Decl d) {
        this.label = d.getName();
        this.children = NO_NODES;
        if (d instanceof ParameterDecl) {
            this.image = Images.PARAMETER;
        } else if (d instanceof SetDecl) {
            this.image = Images.SET;
        } else if (d instanceof VariableDecl) {
            this.image = Images.VARIABLE;
        } else if (d instanceof ConstraintDecl) {
            this.image = Images.POLYGON;
        } else if (d instanceof ObjectiveDecl) {
            this.image = Images.FUNCTION;
        }
        this.offset = d.getStart();
        this.length = d.getEnd() - d.getStart();
        if (this.length < 0) {
            this.length = d.getStart() - d.getEnd();
        }
    }

    public Object getAdapter(Class adapter) {
        return adapter == IWorkbenchAdapter.class ? this : null;
    }

    public Object[] getChildren(Object o) {
        return this.children;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.image;
    }

    public String getLabel(Object o) {
        return this.label;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }
}

