/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.Log;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.osgi.service.prefs.Preferences;
import sampl.Diagnostic;
import sampl.DiagnosticHandler;
import sampl.Source;
import sampl.ast.Decl;
import sampl.ast.Node;
import sampl.ast.ParameterDecl;
import sampl.ast.SetDecl;
import sampl.ast.Stmt;
import sampl.parser.Action;
import sampl.parser.Identifier;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.sema.ASTConsumer;
import sampl.sema.Sema;

public class EditorHover
implements ITextHover,
ITextHoverExtension {
    IdentifierTable identifierTable;
    Identifiers identifiers;
    private Preferences preferences = ConfigurationScope.INSTANCE.getNode("com.ampl.ide");

    public EditorHover() {
        this.identifiers = new Identifiers();
    }

    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        boolean isToolTip = this.preferences.getBoolean("EditorTooltip", false);
        String tooltipText = "";
        if (!isToolTip) {
            return tooltipText;
        }
        try {
            int offSet = hoverRegion.getOffset();
            IDocument document = textViewer.getDocument();
            int targetLine = document.getLineOfOffset(offSet);
            IRegion iRegion = document.getLineInformation(targetLine);
            this.parse(this.getSource(document, offSet));
            this.identifiers.populateIdentifierMap(this.identifierTable, false);
            String word = "";
            try {
                word = this.getHoverWord(document, iRegion, offSet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String target = word;
            tooltipText = this.identifiers.getLineForTooltip(document, word);
            if (!target.matches("^[a-zA-Z0-9_ ]*$")) {
                return tooltipText;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return tooltipText;
    }

    public String getHoverWord(IDocument document, IRegion iRegion, int offSet) throws BadLocationException {
        String str;
        StringBuilder sb = new StringBuilder();
        if (!document.get(offSet, 1).matches("^[a-zA-Z0-9_]*$")) {
            return "";
        }
        int j = offSet;
        while (j > iRegion.getOffset()) {
            str = document.get(j, 1);
            if (str.matches("[^a-zA-Z0-9_]")) break;
            sb.append(str);
            --j;
        }
        sb = sb.reverse();
        int i = offSet + 1;
        while (i < iRegion.getOffset() + iRegion.getLength()) {
            str = document.get(i, 1);
            if (str.matches("[^a-zA-Z0-9_]")) break;
            sb.append(str);
            ++i;
        }
        String word = sb.toString();
        return word;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    Source getSource(IDocument doc, int until) {
        try {
            return Source.newStringSource((String)"<doc>", (String)doc.get(0, until));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parse(Source source) {
        ASTConsumer consumer = new ASTConsumer(){

            public void onData(Object value) {
            }

            public void onDataStart(ParameterDecl[] decls) {
            }

            public void onDataStart(SetDecl decl, Object key) {
            }

            public void onDecl(Decl d) {
            }

            public void onDefaultData(Object value) {
            }

            public void onKey(Object key) {
            }

            public void onSourcesEnd() {
            }

            public void onSourceSwitch(Source s) {
            }

            public void onTopLevelStmt(Stmt s) {
            }

            public void onData(Object arg0, Object arg1, int arg2) {
            }
        };
        DiagnosticHandler diagHandler = new DiagnosticHandler(){

            public void diagnostic(Diagnostic d) {
            }
        };
        this.identifierTable = new IdentifierTable(false);
        Sema sema = new Sema(diagHandler, consumer, this.identifierTable, null);
        Parser parser = new Parser((Action)sema, this.identifierTable, diagHandler);
        try {
            parser.parse(source, false);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    class Identifiers {
        Map<String, Identifier> map = new HashMap<String, Identifier>();

        Identifiers() {
        }

        public String getLineForTooltip(IDocument document, String target) {
            String tootiptext = "";
            for (Map.Entry<String, Identifier> e : this.map.entrySet()) {
                if (!e.getKey().equals(target)) continue;
                tootiptext = this.getDisplayString(e.getValue(), document);
                break;
            }
            return tootiptext;
        }

        private String getDisplayString(Identifier identifier, IDocument document) {
            String description = null;
            String line = null;
            if (identifier.getDecl() != null) {
                StringBuilder sb = new StringBuilder();
                Node node = (Node)identifier.getDecl();
                try {
                    int startlineNumber = document.getLineOfOffset(node.getStart());
                    int endLineNumber = node.getEnd() > 0 ? document.getLineOfOffset(node.getEnd()) : startlineNumber;
                    int i = startlineNumber;
                    while (i <= endLineNumber) {
                        IRegion iRegion = document.getLineInformation(i);
                        line = String.valueOf(line != null ? line : "") + document.get(iRegion.getOffset(), iRegion.getLength());
                        if (i < endLineNumber) {
                            line = String.valueOf(line) + "\n";
                        }
                        ++i;
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                if (identifier.getDecl().getIndexing() != null) {
                    identifier.getDecl().getIndexing().format(sb);
                }
                description = String.format("%s", line);
            } else {
                if (identifier.toString().equals("var")) {
                    description = "";
                }
                if (identifier.toString().equals("param")) {
                    description = "";
                }
                if (identifier.toString().equals("set")) {
                    description = "";
                }
                if (identifier.toString().equals("maximize")) {
                    description = "";
                }
                if (identifier.toString().equals("minimize")) {
                    description = "";
                }
                if (identifier.toString().equals("sum")) {
                    description = "";
                }
            }
            if (description != null) {
                return String.format("%s", description);
            }
            return "";
        }

        public void populateIdentifierMap(IdentifierTable table, boolean includeCurrentWord) {
            this.map.clear();
            for (Identifier identifier : table.getMap().values()) {
                this.map.put(identifier.toString(), identifier);
            }
        }
    }
}

