/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.Log;
import com.ampl.ide.editors.TextAttributes;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import sampl.Diagnostic;
import sampl.DiagnosticHandler;
import sampl.SAMPLException;
import sampl.Source;
import sampl.ast.Expr;
import sampl.ast.Stmt;
import sampl.parser.Action;
import sampl.parser.DeclAction;
import sampl.parser.DeclKind;
import sampl.parser.EmptyAction;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.parser.Token;
import sampl.parser.TokenHandler;
import sampl.parser.TokenKind;

public class DamagerRepairer
extends EmptyAction
implements IPresentationDamager,
IPresentationRepairer {
    private IDocument document;
    private final IdentifierTable identifiers;
    private TextAttributes attributes;
    DiagnosticHandler handler = new DiagnosticHandler(){

        public void diagnostic(Diagnostic d) {
        }
    };
    private TextPresentation presentation;
    private int regionOffset;

    public DamagerRepairer(IdentifierTable it, TextAttributes attributes) {
        this.attributes = attributes;
        this.identifiers = it;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(final TextPresentation presentation, ITypedRegion region) {
        try {
            final int regionOffset = region.getOffset();
            this.presentation = presentation;
            this.regionOffset = regionOffset;
            Parser parser = new Parser((Action)this, this.identifiers, this.handler);
            parser.setTokenHandler(new TokenHandler(){

                public void token(TokenKind kind, int pos, int length) {
                    TextAttribute attr = DamagerRepairer.this.attributes.DEFAULT;
                    switch (kind) {
                        case EOF: {
                            return;
                        }
                        case STRING: {
                            attr = DamagerRepairer.this.attributes.STRING;
                            break;
                        }
                        case COMMENT: {
                            attr = DamagerRepairer.this.attributes.COMMENT;
                            break;
                        }
                        case IDENTIFIER: {
                            break;
                        }
                        case S_DOT_T_DOT: {
                            attr = DamagerRepairer.this.attributes.KEYWORD;
                            break;
                        }
                        default: {
                            if (!kind.isKeywordOrIdentifier()) break;
                            attr = DamagerRepairer.this.attributes.KEYWORD;
                        }
                    }
                    int offset = regionOffset + pos;
                    presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
                }
            });
            parser.parse(Source.newStringSource((String)"<doc>", (String)this.document.get(region.getOffset(), region.getLength())), region.getType() == "__data");
        }
        catch (SAMPLException e) {
            Log.log(e);
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    private void replaceStyleRange(int start, int length, TextAttribute attr) {
        int offset = this.regionOffset + start;
        this.presentation.replaceStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
    }

    private void replaceStyleRange(Token name, TextAttribute attr) {
        String id = name.getIdentifier().toString();
        this.replaceStyleRange(name.getStartPosition(), id.length(), attr);
    }

    public DeclAction onDecl(DeclKind kind, Token start, Token name, Token alias) {
        this.replaceStyleRange(name, this.attributes.DEFAULT);
        return this;
    }

    public Expr onReference(Token name, Action.ReferenceKind kind) {
        this.replaceStyleRange(name, this.attributes.DEFAULT);
        return Expr.INVALID;
    }

    public Expr onCallExpr(Token name, List<Expr> args, int rparenPos) {
        this.replaceStyleRange(name, this.attributes.FUNCTION);
        return Expr.INVALID;
    }

    public Stmt onTableIOStmt(Token keyword, int tablePos, Expr ref, int semiPos) {
        this.replaceStyleRange(tablePos, 5, this.attributes.KEYWORD);
        return Stmt.INVALID;
    }
}

