/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.Log;
import com.ampl.ide.editors.OutlineNode;
import com.ampl.ide.editors.Section;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import sampl.Diagnostic;
import sampl.DiagnosticHandler;
import sampl.Source;
import sampl.ast.BasicStmt;
import sampl.ast.Decl;
import sampl.ast.EmptyStmt;
import sampl.ast.ParameterDecl;
import sampl.ast.SetDecl;
import sampl.ast.Stmt;
import sampl.ast.TableDecl;
import sampl.parser.Action;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.sema.ASTConsumer;
import sampl.sema.Sema;

class AMPLOutlinePage
extends ContentOutlinePage {
    private IPath input;
    private TextEditor editor;

    private IAdaptable getContentOutline(IPath input) {
        final ArrayList sections = new ArrayList();
        ASTConsumer consumer = new ASTConsumer(){
            private Section section = Section.Model;
            private ArrayList<OutlineNode> nodes = new ArrayList();

            private void endSection() {
                if (!this.nodes.isEmpty() || this.section != Section.Model) {
                    sections.add(new OutlineNode(this.section, this.nodes));
                }
            }

            private void enterSection(Section s) {
                if (s == this.section) {
                    return;
                }
                this.endSection();
                this.nodes = new ArrayList();
                this.section = s;
            }

            public void onData(Object value) {
            }

            public void onData(Object key, Object value, int index) {
            }

            public void onDataStart(ParameterDecl[] decls) {
                this.enterSection(Section.Data);
                ParameterDecl[] parameterDeclArray = decls;
                int n = decls.length;
                int n2 = 0;
                while (n2 < n) {
                    ParameterDecl d = parameterDeclArray[n2];
                    this.nodes.add(new OutlineNode((Decl)d));
                    ++n2;
                }
            }

            public void onDataStart(SetDecl decl, Object key) {
                this.enterSection(Section.Data);
                this.nodes.add(new OutlineNode((Decl)decl));
            }

            public void onDecl(Decl d) {
                Section section = d instanceof TableDecl ? Section.Script : Section.Model;
                this.enterSection(section);
                this.nodes.add(new OutlineNode(d));
            }

            public void onDefaultData(Object value) {
            }

            public void onKey(Object key) {
            }

            public void onSourcesEnd() {
                this.endSection();
            }

            public void onSourceSwitch(Source s) {
            }

            public void onTopLevelStmt(Stmt s) {
                if (s instanceof EmptyStmt) {
                    return;
                }
                if (s instanceof BasicStmt) {
                    BasicStmt.Kind kind = ((BasicStmt)s).getKind();
                    if (kind == BasicStmt.Kind.DATA) {
                        this.enterSection(Section.Data);
                        return;
                    }
                    if (kind == BasicStmt.Kind.MODEL) {
                        this.enterSection(Section.Model);
                        return;
                    }
                }
                this.enterSection(Section.Script);
            }
        };
        DiagnosticHandler diagHandler = new DiagnosticHandler(){

            public void diagnostic(Diagnostic d) {
            }
        };
        IdentifierTable identifiers = new IdentifierTable(true);
        Sema sema = new Sema(diagHandler, consumer, identifiers, null);
        Parser parser = new Parser((Action)sema, identifiers, diagHandler);
        String path = input.toString();
        try {
            parser.parse(path, path.toLowerCase().endsWith(".dat"));
        }
        catch (Exception e) {
            Log.log(e);
        }
        return new AdaptableList(sections);
    }

    AMPLOutlinePage(IPath input, TextEditor editor) {
        this.input = input;
        this.editor = editor;
    }

    void update() {
        this.getTreeViewer().setInput((Object)this.getContentOutline(this.input));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            OutlineNode node = (OutlineNode)((IStructuredSelection)selection).getFirstElement();
            int start = node.getOffset();
            int length = node.getLength();
            try {
                this.editor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.editor.resetHighlightRange();
            }
        }
    }
}

