/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.editors;

import com.ampl.ide.editors.AMPLOutlinePage;
import com.ampl.ide.editors.ColorManager;
import com.ampl.ide.editors.DamagerRepairer;
import com.ampl.ide.editors.EditorHover;
import com.ampl.ide.editors.TextAttributes;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import sampl.parser.IdentifierTable;

public class AMPLEditor
extends TextEditor
implements IPropertyChangeListener {
    private IdentifierTable identifiers = new IdentifierTable(true);
    private ColorManager colorManager = new ColorManager();
    private AMPLOutlinePage outlinePage;

    public AMPLEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new Configuration());
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public Object getAdapter(Class required) {
        IEditorInput input;
        if (IContentOutlinePage.class.equals((Object)required) && (input = this.getEditorInput()) instanceof FileStoreEditorInput) {
            IPath path = null;
            URI uri = ((IURIEditorInput)input).getURI();
            if (uri != null) {
                path = URIUtil.toPath((URI)uri);
            }
            this.outlinePage = new AMPLOutlinePage(path, this);
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        event.getProperty();
        this.updateColor();
    }

    private void updateColor() {
        ColorRegistry colorReg = JFaceResources.getColorRegistry();
        Color selColor = colorReg.get("com.ampl.ide.preferences.colorsFonts.editorColor");
        this.getSourceViewer().getTextWidget().setBackground(selColor);
    }

    private void updateFont() {
        this.getSourceViewer().getTextWidget().setFont(JFaceResources.getFont((String)"com.ampl.ide.preferences.colorsFonts.editorFont"));
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IContributionItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            IMenuManager submenu;
            IContributionItem testShowIn;
            if (items[i] instanceof IMenuManager && (testShowIn = (submenu = (IMenuManager)items[i]).find(ContributionItemFactory.VIEWS_SHOW_IN.getId())) != null) {
                menu.remove((IContributionItem)submenu);
            }
            ++i;
        }
        this.addAction(menu, "group.find", ITextEditorActionConstants.FIND);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors()).install();
        viewer.doOperation(19);
        viewer.getProjectionAnnotationModel();
        this.updateColor();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    private class Configuration
    extends TextSourceViewerConfiguration {
        private TextAttributes attributes;
        private ITextHover iTextHover;

        private Configuration() {
            this.attributes = new TextAttributes(AMPLEditor.this.colorManager);
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            if (this.iTextHover == null) {
                this.iTextHover = new EditorHover();
                return this.iTextHover;
            }
            return super.getTextHover(sourceViewer, contentType);
        }

        public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
            return new String[]{"__dftl_partition_content_type", "__data"};
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            DamagerRepairer dr = new DamagerRepairer(AMPLEditor.this.identifiers, this.attributes);
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)dr, "__data");
            reconciler.setRepairer((IPresentationRepairer)dr, "__data");
            return reconciler;
        }
    }
}

