/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.console;

import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.console.ConsoleHistory;
import com.ampl.ide.launching.IAMPLProcessTerminateListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class AMPLConsoleViewer
extends TextConsoleViewer {
    private IDocumentListener documentListener;
    private IAMPLProcessTerminateListener processTerminateListener;
    private ConsoleHistory history;
    private AMPLConsole console;
    private boolean isCarriageReturn = false;
    private boolean postCarriageReturn = false;

    public AMPLConsoleViewer(Composite parent, AMPLConsole console) {
        super(parent, (TextConsole)console);
        final StyledText styledText = this.getTextWidget();
        this.history = console.getHistory();
        this.console = console;
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                styledText.setCaretOffset(AMPLConsoleViewer.this.getDocument().getLength());
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.addVerifyKeyListener((VerifyKeyListener)new AMPLKeyChecker());
        this.processTerminateListener = new IAMPLProcessTerminateListener(){

            @Override
            public void amplProcessTerminated() {
                ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AMPLConsoleViewer.this.setReadOnly();
                    }
                });
            }
        };
        console.processTerminatedListeners().addListener(this.processTerminateListener);
    }

    protected void handleDispose() {
        this.console.processTerminatedListeners().removeListener(this.processTerminateListener);
        super.handleDispose();
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        block14: {
            IDocument doc = this.getDocument();
            String[] legalLineDelimiters = doc.getLegalLineDelimiters();
            String eventString = e.text;
            try {
                int length;
                this.isCarriageReturn = false;
                if (e.start >= this.console.getCaret()) {
                    int i = 0;
                    while (i < legalLineDelimiters.length) {
                        if (e.text.equals(legalLineDelimiters[i])) {
                            this.isCarriageReturn = true;
                            try {
                                this.history.add(doc.get(this.console.getCaret(), this.getLenNewCommand()));
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                            break;
                        }
                        ++i;
                    }
                    if (!this.isCarriageReturn) {
                        super.handleVerifyEvent(e);
                        return;
                    }
                }
                if (e.start == (length = doc.getLength())) {
                    super.handleVerifyEvent(e);
                    break block14;
                }
                try {
                    doc.replace(length, 0, eventString);
                }
                catch (BadLocationException badLocationException) {}
                e.doit = false;
            }
            finally {
                StyledText text = (StyledText)e.widget;
                if (this.isCarriageReturn) {
                    text.setCaretOffset(text.getCharCount());
                }
            }
        }
    }

    public void setReadOnly() {
        this.getTextWidget().setEditable(false);
    }

    public void setDocument(IDocument document) {
        IDocument oldDocument = this.getDocument();
        super.setDocument(document);
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.getDocumentListener());
        }
        if (document != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.documentListener != null) {
            return this.documentListener;
        }
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                AMPLConsoleViewer.this.revealEndOfDocument();
                if (AMPLConsoleViewer.this.isCarriageReturn) {
                    AMPLConsoleViewer.this.getTextWidget().setCaretOffset(AMPLConsoleViewer.this.getTextWidget().getCharCount());
                }
                if (AMPLConsoleViewer.this.postCarriageReturn) {
                    AMPLConsoleViewer.this.postCarriageReturn = false;
                }
                if (AMPLConsoleViewer.this.isCarriageReturn) {
                    AMPLConsoleViewer.this.postCarriageReturn = true;
                }
            }
        };
        return this.documentListener;
    }

    protected boolean isCaretInEditableRange() {
        return this.getTextWidget().getCaretOffset() >= this.console.getCaret();
    }

    protected int getLenNewCommand() {
        return this.getTextWidget().getCharCount() - this.console.getCaret();
    }

    public class AMPLKeyChecker
    implements VerifyKeyListener {
        public void verifyKey(VerifyEvent event) {
            if (AMPLConsoleViewer.this.isCaretInEditableRange() && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                event.doit = false;
                IDocument doc = AMPLConsoleViewer.this.getDocument();
                try {
                    if (AMPLConsoleViewer.this.history.canPrevious() && event.keyCode == 0x1000001) {
                        doc.replace(AMPLConsoleViewer.this.console.getCaret(), AMPLConsoleViewer.this.getLenNewCommand(), AMPLConsoleViewer.this.history.getPrevious());
                    }
                    if (AMPLConsoleViewer.this.history.canNext() && event.keyCode == 0x1000002) {
                        doc.replace(AMPLConsoleViewer.this.console.getCaret(), AMPLConsoleViewer.this.getLenNewCommand(), AMPLConsoleViewer.this.history.getNext());
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            if (AMPLConsoleViewer.this.isCaretInEditableRange() && event.keyCode == 0x1000007) {
                event.doit = false;
                AMPLConsoleViewer.this.getTextWidget().setCaretOffset(AMPLConsoleViewer.this.console.getCaret());
            }
        }
    }
}

