/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.console;

import com.ampl.ide.AMPLService;
import com.ampl.ide.ErrorHandler;
import com.ampl.ide.IWorkingDirListener;
import com.ampl.ide.Log;
import com.ampl.ide.console.AMPLConsolePage;
import com.ampl.ide.console.ConsoleHistory;
import com.ampl.ide.launching.AMPLProcess;
import com.ampl.ide.launching.IAMPLProcessTerminateListener;
import com.ampl.ide.launching.ProcessTerminatedListenerList;
import com.ampl.ide.views.CDEView;
import com.ampl.ide.views.internal.FileSystemRoots;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.IPageBookViewPage;
import sampl.Util;

public class AMPLConsole
extends IOConsole
implements IPropertyChangeListener {
    private IOConsoleInputStream fInput;
    private IOConsoleOutputStream fOutput;
    private IStreamsProxy fStreamsProxy;
    private InputReadJob readJob;
    private AMPLProcess process;
    private IAMPLProcessTerminateListener processTerminateListener;
    private static final char BACK_SPACE = '\b';
    private AMPLConsolePage page;
    private ConsoleHistory history;
    private int caretAtPrompt;
    private int existCmdLen;
    private InputType inputType = InputType.USER;
    private ErrorHandler errorHandler = (ErrorHandler)PlatformUI.getWorkbench().getService(ErrorHandler.class);
    private String workingDir;
    private List<IWorkingDirListener> workingDirListeners = new ArrayList<IWorkingDirListener>();

    public AMPLConsole(AMPLProcess process, String name, ImageDescriptor imageDescriptor, String workingDir) {
        super(name, imageDescriptor);
        this.fInput = this.getInputStream();
        this.fStreamsProxy = process.getStreamsProxy();
        this.fOutput = this.newOutputStream();
        new StreamListener(this.fStreamsProxy.getOutputStreamMonitor(), this.fOutput);
        this.readJob = new InputReadJob(this.fStreamsProxy);
        this.readJob.setSystem(true);
        this.readJob.schedule();
        this.existCmdLen = 0;
        this.history = new ConsoleHistory();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AMPLConsole.this.updateFont();
            }
        });
        this.processTerminateListener = new IAMPLProcessTerminateListener(){

            @Override
            public void amplProcessTerminated() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SimpleDateFormat date = new SimpleDateFormat("dd MMM yy HH:mm:ss");
                        Date dateNow = new Date();
                        AMPLConsole.this.setName("<terminated> " + AMPLConsole.this.getName() + " (" + date.format(dateNow) + ")");
                        MessageDialog dialog = new MessageDialog(null, "AMPL Process Terminated", null, "The AMPL Process has terminated. Would you like to restart it?", 3, new String[]{"Yes", "No", "Exit IDE"}, 0);
                        int YES = 0;
                        int EXIT = 2;
                        int result = dialog.open();
                        if (result == YES) {
                            AMPLConsole.this.updateAMPLProcess((AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class));
                        } else if (result == EXIT) {
                            PlatformUI.getWorkbench().close();
                        } else if ((this).AMPLConsole.this.page != null) {
                            (this).AMPLConsole.this.page.setEditable(false);
                        }
                    }
                });
            }
        };
        process.addListener(this.processTerminateListener);
        this.process = process;
        this.workingDir = workingDir;
        this.updateColor();
    }

    protected void dispose() {
        this.process.removeListener(this.processTerminateListener);
        super.dispose();
    }

    public void updateAMPLProcess(AMPLService service) {
        List<IWorkingDirListener> existingListners = this.getWorkingDirListeners();
        AMPLProcess updatedProcess = service.restartAMPL();
        for (IWorkingDirListener iWorkingDirListener : existingListners) {
            String name = iWorkingDirListener.getClass().getEnclosingClass().getName();
            if (name != CDEView.class.getName() && name != FileSystemRoots.class.getName()) continue;
            updatedProcess.getConsole().addWorkingDirListener(iWorkingDirListener);
        }
    }

    public String workingDir() {
        return this.workingDir;
    }

    public synchronized boolean setWorkingDir(String dir) {
        try {
            this.fStreamsProxy.write("cd " + Util.quote((String)dir) + ";");
            this.inputType = InputType.CD;
        }
        catch (IOException iOException) {
            this.handleCDError(dir);
            return false;
        }
        return true;
    }

    public void addWorkingDirListener(IWorkingDirListener listener) {
        this.workingDirListeners.add(listener);
    }

    public void removeWorkingDirListener(IWorkingDirListener listener) {
        this.workingDirListeners.remove(listener);
    }

    public List<IWorkingDirListener> getWorkingDirListeners() {
        return this.workingDirListeners;
    }

    ProcessTerminatedListenerList processTerminatedListeners() {
        return this.process;
    }

    public void clearConsole() {
        super.clearConsole();
        this.caretAtPrompt = 0;
        try {
            this.fStreamsProxy.write("\n\r");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        this.page = new AMPLConsolePage(this, view);
        return this.page;
    }

    public int getCaret() {
        return this.caretAtPrompt;
    }

    public ConsoleHistory getHistory() {
        return this.history;
    }

    public synchronized void sendSystemCommand(String command) throws IOException {
        this.fStreamsProxy.write(command);
        this.inputType = InputType.SYSTEM;
    }

    private void handleCDError(String dir) {
        String message = "Cannot change directory";
        if (dir != null) {
            message = String.valueOf(message) + " to " + dir;
        }
        this.errorHandler.handle("Error", message);
    }

    protected synchronized void checkCurrentDir() {
        try {
            this.fStreamsProxy.write("cd;");
            this.inputType = InputType.CD;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void typeAndSendUICommand(String command) {
        String output = String.valueOf(command) + "\n";
        String text = this.page.getViewer().getTextWidget().getText();
        String existCmd = text.substring(this.caretAtPrompt);
        IDocument doc = this.getDocument();
        int len = existCmd.length();
        this.existCmdLen += len;
        output = this.existCmdLen > 0 ? String.valueOf(existCmd) + command + "\n" : String.valueOf(command) + "\n";
        int offset = doc.getLength();
        try {
            doc.replace(offset, 0, output);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.history.add(command);
    }

    private String processText(String text) {
        return text.replace('\b', ' ');
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ampl.ide.preferences.colorsFonts.consoleColor")) {
            this.updateColor();
        }
        if (event.getProperty().equals("com.ampl.ide.preferences.colorsFonts.consoleFont")) {
            this.updateFont();
        }
    }

    private void updateColor() {
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color color = colorRegistry.get("com.ampl.ide.preferences.colorsFonts.consoleColor");
        this.setBackground(color);
    }

    private void updateFont() {
        this.setFont(JFaceResources.getFont((String)"com.ampl.ide.preferences.colorsFonts.consoleFont"));
    }

    public Field getPrivateVarValue(String fName) {
        Field field = null;
        try {
            field = this.fStreamsProxy.getClass().getDeclaredField(fName);
            field.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return field;
    }

    private class InputReadJob
    extends Job {
        private IStreamsProxy streamsProxy;

        InputReadJob(IStreamsProxy streamsProxy) {
            super("AMPL Console Input Job");
            this.streamsProxy = streamsProxy;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                while (AMPLConsole.this.fInput != null && read >= 0) {
                    read = AMPLConsole.this.fInput.read(b);
                    if (read <= 0) continue;
                    String s = new String(b, 0, read);
                    if (AMPLConsole.this.existCmdLen > 0) {
                        s = s.substring(AMPLConsole.this.existCmdLen);
                        AMPLConsole.this.existCmdLen = 0;
                    }
                    this.streamsProxy.write(s);
                    AMPLConsole.this.caretAtPrompt += s.length();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    private static enum InputType {
        USER,
        SYSTEM,
        CD;

    }

    private class StreamListener
    implements IStreamListener {
        private IStreamMonitor fStreamMonitor;
        private IOConsoleOutputStream fStream;
        private boolean fFlushed = false;

        public StreamListener(IStreamMonitor monitor, IOConsoleOutputStream stream) {
            this.fStreamMonitor = monitor;
            this.fStream = stream;
            this.fStreamMonitor.addListener((IStreamListener)this);
            this.streamAppended(null, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void streamAppended(String text, IStreamMonitor monitor) {
            if (AMPLConsole.this.inputType == InputType.CD) {
                Matcher m;
                Pattern p;
                if (text.contains("Error executing \"cd\" command")) {
                    p = Pattern.compile("Can't cd (['\"].*['\"])");
                    m = p.matcher(text);
                    final String dir = m.find() ? Util.unquote((String)m.group(1)) : null;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AMPLConsole.this.handleCDError(dir);
                        }
                    });
                }
                if (!(m = (p = Pattern.compile("^cd (['\"].*['\"])", 8)).matcher(text)).find()) {
                    Log.log("Invalid output of the cd command:\n" + text);
                    return;
                }
                AMPLConsole.this.workingDir = Util.unquote((String)m.group(1));
                for (IWorkingDirListener listener : AMPLConsole.this.workingDirListeners) {
                    listener.workingDirChanged(AMPLConsole.this.workingDir);
                }
                AMPLConsole.this.inputType = InputType.USER;
                return;
            }
            if (this.fFlushed) {
                try {
                    text = AMPLConsole.this.processText(text);
                    this.fStream.write(text);
                    AMPLConsole.this.caretAtPrompt += text.length();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String contents = null;
                IStreamMonitor m = this.fStreamMonitor;
                synchronized (m) {
                    this.fFlushed = true;
                    contents = this.fStreamMonitor.getContents();
                    if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                        IFlushableStreamMonitor m2 = (IFlushableStreamMonitor)this.fStreamMonitor;
                        m2.flushContents();
                        m2.setBuffered(false);
                    }
                }
                if (contents != null && contents.length() > 0) {
                    try {
                        this.fStream.write(contents);
                        AMPLConsole.this.caretAtPrompt += contents.length();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

