/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.commands;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends TrayDialog {
    private Path file;
    private Text filenameText;

    protected RenameDialog(Shell parentShell, Path file) {
        super(parentShell);
        this.file = file;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 15;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText("New name: ");
        this.filenameText = new Text(composite, 2052);
        this.filenameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.filenameText.setText(this.file.getFileName().toString());
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Rename File");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        Path newFile = this.file.resolveSibling(this.filenameText.getText());
        try {
            if (Files.exists(newFile, new LinkOption[0])) {
                boolean replace = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Replace", (String)"This file or directory already exists.\nWould you like to replace it?");
                if (!replace) return;
                Files.move(this.file, this.file.resolveSibling(this.filenameText.getText()), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(this.file, this.file.resolveSibling(this.filenameText.getText()), new CopyOption[0]);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error!", (String)"File/directory cannot be renamed.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        super.okPressed();
    }
}

