/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.commands;

import com.ampl.ide.ErrorHandler;
import com.ampl.ide.commands.internal.CommandsWithRefresh;
import com.ampl.ide.views.CDEView;
import com.ampl.ide.views.ViewWrapper;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class PasteCDEHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IViewPart view = window.getActivePage().findView("com.ampl.ide.CurrDirExplorer");
        Path directory = null;
        if (view instanceof ViewWrapper) {
            CDEView cdeView = (CDEView)((ViewWrapper)view).getComponent();
            directory = cdeView.getSelectedDir();
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Clipboard clipboard = new Clipboard(display);
        String[] fileData = (String[])clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            int i = 0;
            while (i < fileData.length) {
                try {
                    Path fileToCopy = Paths.get(fileData[i], new String[0]);
                    Files.copy(fileToCopy, directory.resolve(fileToCopy.getFileName()), LinkOption.NOFOLLOW_LINKS);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    MessageDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Copy", (String)"A file with the same name already exists in the target directory.");
                }
                catch (IOException e) {
                    ErrorHandler.report(e, "Error copying file");
                }
                ++i;
            }
            CommandsWithRefresh.globalRefresh();
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Paste", (String)"Cannot paste the clipboard contents into the selected element");
        }
        return null;
    }
}

