/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.commands;

import com.ampl.ide.ErrorHandler;
import com.ampl.ide.views.internal.CDEModel.CDEResource;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class OpenFileAnotherEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof CDEResource)) {
            return null;
        }
        CDEResource resource = (CDEResource)element;
        if (resource.isDirectory()) {
            return null;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(resource.getPath()));
        if (fileStore.fetchInfo().isDirectory() || !fileStore.fetchInfo().exists()) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            String command = event.getParameter("com.ampl.ide.EditorType");
            String editorId = command.equals("external") ? "org.eclipse.ui.systemExternalEditor" : "org.eclipse.ui.DefaultTextEditor";
            IDE.openEditor((IWorkbenchPage)page, (URI)fileStore.toURI(), (String)editorId, (boolean)true);
        }
        catch (PartInitException e) {
            ErrorHandler.report((Exception)((Object)e), "Error opening an editor");
        }
        return null;
    }
}

