/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.commands;

import com.ampl.ide.ErrorHandler;
import com.ampl.ide.commands.internal.CommandsWithRefresh;
import com.ampl.ide.views.internal.CDEModel.CDEResource;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof CDEResource)) {
            return null;
        }
        CDEResource resource = (CDEResource)element;
        Path file = resource.getFile();
        String name = resource.getName();
        String question = "Are you sure you want to delete '" + name + "'?";
        boolean result = MessageDialog.openConfirm((Shell)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (String)"Delete", (String)question);
        if (!result) {
            return null;
        }
        try {
            if (!Files.isDirectory(file, new LinkOption[0])) {
                Files.deleteIfExists(file);
            } else {
                Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc != null) {
                            throw exc;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            ErrorHandler.report(e, "Error deleting resource");
        }
        CommandsWithRefresh.globalRefresh();
        return null;
    }
}

