/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide.commands;

import com.ampl.ide.AMPLService;
import com.ampl.ide.ErrorHandler;
import com.ampl.ide.views.internal.CDEModel.CDEResource;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class AMPLCommandEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String command = event.getParameter("com.ampl.ide.commandType");
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        URI uri = ((FileStoreEditorInput)editor.getEditorInput()).getURI();
        try {
            Path path = Paths.get(uri);
            CDEResource mockObject = new CDEResource(path.toString());
            if (mockObject.isFile()) {
                Path file = mockObject.getFile();
                command = this.getCommandFromExtension(mockObject);
                AMPLService s = (AMPLService)PlatformUI.getWorkbench().getService(AMPLService.class);
                s.sendAMPLCommand(String.valueOf(command) + " '" + file.toString() + "';");
            }
        }
        catch (InvalidPathException e) {
            ErrorHandler.report(e, "Unable to execute this file in AMPL.");
        }
        return null;
    }

    public String getCommandFromExtension(CDEResource cdeResource) {
        String ext = cdeResource.getFileExtension();
        String command = "";
        switch (ext) {
            case "mod": {
                command = "model";
                break;
            }
            case "dat": {
                command = "data";
                break;
            }
            default: {
                command = "include";
            }
        }
        return command;
    }
}

