/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class ErrorHandler {
    public void handle(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new ErrorDialog(title, message).open();
            }
        });
    }

    public void handleInfo(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new InfoDialog(title, message).open();
            }
        });
    }

    public static void report(Exception e, String message) {
        Status status = new Status(4, "com.ampl.ide", message, (Throwable)e);
        StatusManager.getManager().handle((IStatus)status, 3);
    }

    private static class ErrorDialog
    extends MessageDialog {
        private Text messageText;

        public ErrorDialog(String title, String message) {
            super(null, title, null, message, 1, new String[]{IDialogConstants.CLOSE_LABEL}, 0);
        }

        protected Control createMessageArea(Composite composite) {
            String savedMessage = this.message;
            try {
                this.message = null;
                super.createMessageArea(composite);
            }
            finally {
                this.message = savedMessage;
            }
            if (this.message != null) {
                this.messageText = new Text(composite, 2632);
                this.messageText.setText(this.message);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageText);
            }
            return composite;
        }
    }

    private static class InfoDialog
    extends MessageDialog {
        private Text messageText;

        public InfoDialog(String title, String message) {
            super(null, title, null, message, 2, new String[]{IDialogConstants.CLOSE_LABEL}, 0);
        }

        protected Control createMessageArea(Composite composite) {
            String savedMessage = this.message;
            try {
                this.message = null;
                super.createMessageArea(composite);
            }
            finally {
                this.message = savedMessage;
            }
            if (this.message != null) {
                this.messageText = new Text(composite, 2632);
                this.messageText.setText(this.message);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageText);
            }
            return composite;
        }
    }
}

