/*
 * Decompiled with CFR 0.152.
 */
package com.ampl.ide;

import com.ampl.ide.ErrorHandler;
import com.ampl.ide.IWorkingDirListener;
import com.ampl.ide.LicenseException;
import com.ampl.ide.Messages;
import com.ampl.ide.console.AMPLConsole;
import com.ampl.ide.launching.AMPLErrorListener;
import com.ampl.ide.launching.AMPLProcess;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.TextConsole;
import org.osgi.framework.Bundle;

public class AMPLService {
    private String pluginDir;
    private String amplPath;
    private AMPLProcess amplProcess;
    private IEclipsePreferences prefs;
    public boolean resetRequested = false;
    public static final String WORKING_DIR_KEY = "WorkingDirectory";
    public static final String ENVIRONMENT_PATH_KEY = "EnvironmentPath";

    private String checkAMPLOutput(String output, int releaseDate) {
        String lineSeparator = System.getProperty("line.separator");
        Pattern pattern = Pattern.compile(".*License .* for ampl is busy.*", 32);
        if (pattern.matcher(output).matches()) {
            return "";
        }
        pattern = Pattern.compile(".*(Temporary license expires|Demo license with maintenance expiring|The license for this AMPL processor has expired." + lineSeparator + "AMPL Version|" + "Maintenance expires with version) (\\d+).*", 32);
        Matcher matcher = pattern.matcher(output);
        if (matcher.matches()) {
            if (Integer.parseInt(matcher.group(2)) < releaseDate) {
                return String.format("This version of IDE requires maintenance expiration date of %d or later.\n%s\n", releaseDate, Messages.Plugin_Assistance);
            }
            return null;
        }
        pattern = Pattern.compile(".*(AMPL Student Version|License [0-9a-fA-F]+-[0-9] for ).*", 32);
        if (pattern.matcher(output).matches()) {
            return null;
        }
        return String.valueOf(Messages.Plugin_Assistance) + "\n";
    }

    protected int getReleaseDate(Bundle bundle) {
        String qualifier = bundle.getVersion().getQualifier();
        if ("qualifier".equals(qualifier)) {
            qualifier = new SimpleDateFormat("yyyyMMdd0000").format(new Date());
        }
        return (int)(Long.parseLong(qualifier) / 10000L);
    }

    protected String run(ProcessBuilder pb) throws IOException {
        Process p = pb.start();
        p.getOutputStream().close();
        p.getErrorStream().close();
        StringBuffer inputStream = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(p.getInputStream());){
            scanner.useDelimiter(lineSeparator);
            while (scanner.hasNext()) {
                if (this.isFloatingLicense(inputStream)) {
                    int i = 0;
                    while (i < 3) {
                        inputStream.append(scanner.next());
                        ++i;
                    }
                    break;
                }
                inputStream.append(scanner.next());
            }
            return inputStream.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public AMPLService(String pluginDir) {
        this.pluginDir = pluginDir;
    }

    public AMPLService() throws IOException {
        Bundle bundle = Platform.getBundle((String)"com.ampl.ide");
        URL locationURL = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
        String dir = FileLocator.toFileURL((URL)locationURL).getFile();
        this.pluginDir = new Path(dir).toString();
    }

    public final String pluginDir() {
        return this.pluginDir;
    }

    public final String amplPath() {
        return this.amplPath;
    }

    public List<String> searchPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        File appDir = new File(this.pluginDir).getParentFile().getParentFile();
        System.out.println("pluginDir--" + this.pluginDir + "    appDir--" + appDir);
        if (com.sun.jna.Platform.isMac()) {
            appDir = appDir.getParentFile().getParentFile();
        }
        paths.add(appDir.getParentFile().getPath());
        if (com.sun.jna.Platform.isMac()) {
            paths.add(new File(appDir, "Contents/Resources/ampl_macosx64").getPath());
            paths.add(new File(appDir, "Contents/Resources/ampl.macosx64").getPath());
        }
        return paths;
    }

    public AMPLProcess amplProcess() {
        return this.amplProcess;
    }

    public AMPLConsole console() {
        return this.amplProcess.getConsole();
    }

    private Map<String, String> getEnvironment() {
        String separator;
        ArrayList<String> paths;
        String searchDirs;
        String pathEnv;
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String path = (String)env.get(pathEnv = "PATH");
        if (path == null && com.sun.jna.Platform.isWindows()) {
            pathEnv = "Path";
            path = (String)env.get(pathEnv);
        }
        if (path == null) {
            path = "";
        }
        if ((searchDirs = this.prefs.get(ENVIRONMENT_PATH_KEY, null)) == null) {
            searchDirs = DefaultScope.INSTANCE.getNode("com.ampl.ide").get(ENVIRONMENT_PATH_KEY, "");
        }
        if (!(paths = new ArrayList<String>(Arrays.asList(path.split(Pattern.quote(separator = System.getProperty("path.separator")))))).isEmpty()) {
            String[] stringArray = new String[]{"bin/client", "bin", "lib/i386", "lib/amd64"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (((String)paths.get(0)).endsWith("jre/" + suffix)) {
                    paths.remove(0);
                }
                ++n2;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String p : paths) {
            if (p.isEmpty()) continue;
            sb.append(p);
            sb.append(separator);
        }
        path = sb.toString();
        env.put(pathEnv, String.valueOf(path) + searchDirs);
        env.put("prompt1", "");
        return env;
    }

    protected String getSystemPath() {
        return System.getenv("PATH");
    }

    public IEclipsePreferences preferences() {
        return this.prefs;
    }

    protected AMPLProcess startAMPL(ErrorHandler errorHandler) {
        Map<String, String> env = this.getEnvironment();
        try {
            this.amplProcess = AMPLProcess.start(this, null, env, this.prefs);
        }
        catch (Exception e) {
            errorHandler.handle(Messages.Plugin_FailedToStartAMPL, e.toString());
            return this.amplProcess;
        }
        AMPLConsole console = this.amplProcess.getConsole();
        if (console instanceof TextConsole) {
            AMPLConsole tc = console;
            tc.addPatternMatchListener(new AMPLErrorListener(console));
        }
        console.addWorkingDirListener(new IWorkingDirListener(){

            @Override
            public void workingDirChanged(String dir) {
                AMPLService.this.prefs.put(AMPLService.WORKING_DIR_KEY, dir);
            }
        });
        return this.amplProcess;
    }

    @Execute
    public AMPLProcess start(@Preference(nodePath="com.ampl.ide") IEclipsePreferences prefs, ErrorHandler errorHandler) throws IOException {
        if (this.amplProcess != null && !this.amplProcess.isTerminated()) {
            return this.amplProcess;
        }
        this.prefs = prefs;
        List<String> paths = this.searchPaths();
        String pathEnv = this.getSystemPath();
        if (pathEnv != null) {
            paths.addAll(Arrays.asList(pathEnv.split(Pattern.quote(File.pathSeparator))));
        }
        String executableName = com.sun.jna.Platform.isWindows() ? "ampl.exe" : "ampl";
        String output = null;
        for (String path : paths) {
            File file = new File(path, executableName);
            if (!file.isFile()) continue;
            this.amplPath = file.getPath();
            ProcessBuilder pb = new ProcessBuilder(this.amplPath, "-v").redirectErrorStream(true);
            output = this.run(pb);
            break;
        }
        if (this.amplPath == null) {
            StringBuilder sb = new StringBuilder("The IDE cannot find the AMPL executable.\n" + this.appendIfMac() + this.assistMsgIfMac(Messages.Plugin_Assistance) + "\nSearch paths:");
            for (String dir : paths) {
                sb.append('\n');
                sb.append(dir);
            }
            errorHandler.handle(Messages.Plugin_Error, sb.toString());
            throw new LicenseException("AMPL not found");
        }
        Bundle bundle = Platform.getBundle((String)"com.ampl.ide");
        String licenseError = this.checkAMPLOutput(output, this.getReleaseDate(bundle));
        if (licenseError != null) {
            errorHandler.handle(Messages.Plugin_LicenseError, String.valueOf(licenseError) + "AMPL path:\n" + this.amplPath + "\nAMPL output:\n" + output.trim());
            throw new LicenseException("License error");
        }
        return this.startAMPL(errorHandler);
    }

    public void stop() throws DebugException {
        if (this.amplProcess == null) {
            return;
        }
        this.amplProcess.stop(this);
        this.amplProcess = null;
    }

    public AMPLProcess restartAMPL() {
        try {
            this.stop();
        }
        catch (Exception e) {
            ErrorHandler.report(e, Messages.Plugin_FailedToStartAMPL);
        }
        return this.openAMPLConsole();
    }

    public AMPLProcess openAMPLConsole() {
        if (this.amplProcess != null) {
            return this.amplProcess;
        }
        return (AMPLProcess)ContextInjectionFactory.invoke((Object)this, Execute.class, (IEclipseContext)((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)));
    }

    public void restoreDefaults() {
        this.prefs.put(WORKING_DIR_KEY, System.getProperty("user.home"));
    }

    public boolean sendAMPLCommand(String command) {
        if (this.amplProcess != null) {
            return this.amplProcess.sendAMPLCommand(command);
        }
        return false;
    }

    public String appendIfMac() {
        String msg = "Please drag the \"amplide\" application (with black cat's-head icon) into your AMPL folder (\"ampl.macosx64\" or similar); then double-click \"amplide\" to start the AMPL IDE. ";
        return Util.isMac() ? msg : "";
    }

    public String assistMsgIfMac(String message) {
        return Util.isMac() ? Messages.Plugin_Assistance_Mac : message;
    }

    public String checkFloatingLicense(String output) {
        Pattern pattern = Pattern.compile(".*(netlicchk: Trying to start license manager ampl_lic).* (Using license file).*", 32);
        Matcher matcher = pattern.matcher(output);
        if (matcher.matches()) {
            PlatformUI.getWorkbench().restart();
        }
        return null;
    }

    public boolean isFloatingLicense(StringBuffer output) {
        Pattern pattern = Pattern.compile(".*(netlicchk: Trying to start license manager ampl_lic.)(netlicchk: Invoking).*$", 32);
        Matcher matcher = pattern.matcher(output.toString());
        return matcher.matches();
    }
}

