/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import sampl.ast.BasicAttr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.NumericLiteral;
import sampl.ast.SetDecl;
import sampl.ast.UnaryAttr;
import sampl.parser.Token;
import sampl.parser.TokenKind;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.SetType;
import sampl.types.Type;
import sampl.types.Types;

final class SetDeclSema
extends DeclSema {
    private SetDecl decl;
    private int dimen;
    private boolean hasInitializer;

    private boolean setDimen(int newDimen, Token op) {
        if (this.dimen != 0 && this.dimen != newDimen) {
            this.report(op, "Dimension mismatch", new Object[0]);
            return false;
        }
        if (newDimen != 1 && this.decl.isScenarioSet()) {
            this.report(op, "Scenarioset must be 1-dimensional", new Object[0]);
            return false;
        }
        this.dimen = newDimen;
        return true;
    }

    SetDeclSema(Sema sema, int pos, String name, boolean isScenarioset) {
        super(sema);
        this.decl = new SetDecl(pos, name, isScenarioset);
        this.dimen = 0;
        this.hasInitializer = false;
    }

    @Override
    SetDecl getDecl() {
        return this.decl;
    }

    @Override
    Type fixType() {
        Type type = this.decl.getType();
        if (type != null) {
            return type;
        }
        type = SetType.get(this.dimen != 0 ? this.dimen : 1);
        Indexing indexing = this.decl.getIndexing();
        if (indexing != null) {
            type = MapType.get(indexing.getDimension(), type);
        }
        this.decl.setType(type);
        return type;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (this.decl.isScenarioSet()) {
            this.sema.report(indexing, "Scenarioset can't have indexing", new Object[0]);
        } else {
            this.decl.setIndexing(indexing);
        }
    }

    @Override
    public void onBasicAttr(Token keyword) {
        if (!keyword.is(TokenKind.KW_ordered) && !keyword.is(TokenKind.KW_circular)) {
            this.reportInvalidAttr(keyword);
            return;
        }
        if (!this.setDimen(1, keyword)) {
            return;
        }
        if (keyword.is(TokenKind.KW_ordered)) {
            this.decl.setOrdered();
        } else if (keyword.is(TokenKind.KW_circular)) {
            this.decl.setCircular();
        }
        this.decl.addAttr(new BasicAttr(keyword.getStartPosition(), BasicAttr.Kind.ORDERED));
    }

    @Override
    public void onUnaryAttr(Token op, Expr arg) {
        int newDimen;
        UnaryAttr.Kind kind;
        if (op.is(TokenKind.KW_dimen)) {
            kind = UnaryAttr.Kind.DIMEN;
            newDimen = 0;
            if (arg instanceof NumericLiteral) {
                newDimen = (int)((NumericLiteral)arg).getValue();
            }
            if (newDimen <= 0) {
                this.sema.report(arg, "Dimension is not a positive integer", new Object[0]);
                return;
            }
        } else {
            boolean isInitializer = false;
            switch (op.getKind()) {
                case EQUAL: 
                case EQUAL_EQUAL: {
                    kind = UnaryAttr.Kind.EQ;
                    isInitializer = true;
                    break;
                }
                case COLON_EQUAL: {
                    kind = UnaryAttr.Kind.ASSIGN;
                    isInitializer = true;
                    break;
                }
                case KW_default: {
                    kind = UnaryAttr.Kind.DEFAULT;
                    isInitializer = true;
                    break;
                }
                case KW_in: {
                    kind = UnaryAttr.Kind.IN;
                    break;
                }
                case KW_within: {
                    kind = UnaryAttr.Kind.WITHIN;
                    break;
                }
                case KW_by: {
                    kind = UnaryAttr.Kind.WITHIN;
                    break;
                }
                default: {
                    this.reportInvalidAttr(op);
                    return;
                }
            }
            Type type = arg.getType();
            if (!(type instanceof SetType)) {
                if (type != Types.UNKNOWN) {
                    this.sema.report(arg, "Type mismatch", new Object[0]);
                    return;
                }
                newDimen = this.dimen;
            } else {
                newDimen = type.getDimension();
                if (isInitializer) {
                    if (this.hasInitializer) {
                        this.report(op, "Multiple initializers", new Object[0]);
                        return;
                    }
                    this.hasInitializer = true;
                }
            }
        }
        if (newDimen == 0 || this.setDimen(newDimen, op)) {
            this.decl.addAttr(new UnaryAttr(op.getStartPosition(), kind, arg));
        }
    }

    @Override
    public void onEndAttrs() {
        this.fixType();
    }
}

