/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import sampl.DiagnosticException;
import sampl.DiagnosticHandler;
import sampl.SAMPLException;
import sampl.Source;
import sampl.Tuple;
import sampl.ast.BasicStmt;
import sampl.ast.BinaryExpr;
import sampl.ast.CallExpr;
import sampl.ast.CheckDecl;
import sampl.ast.CheckStmt;
import sampl.ast.ColGroup;
import sampl.ast.CompoundStmt;
import sampl.ast.Condition;
import sampl.ast.ConditionalExpr;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.Direction;
import sampl.ast.DoubleInequalityExpr;
import sampl.ast.EmptyStmt;
import sampl.ast.Expr;
import sampl.ast.FixStmt;
import sampl.ast.ForStmt;
import sampl.ast.Function;
import sampl.ast.IfStmt;
import sampl.ast.IndexDef;
import sampl.ast.IndexedExpr;
import sampl.ast.Indexing;
import sampl.ast.IteratedExpr;
import sampl.ast.JumpStmt;
import sampl.ast.LetStmt;
import sampl.ast.LoopContext;
import sampl.ast.NetExpr;
import sampl.ast.Node;
import sampl.ast.NumericLiteral;
import sampl.ast.ObjectiveDecl;
import sampl.ast.Option;
import sampl.ast.OptionStmt;
import sampl.ast.OutputStmt;
import sampl.ast.ParameterDecl;
import sampl.ast.ParenExpr;
import sampl.ast.PiecewiseLinearExpr;
import sampl.ast.ProblemDecl;
import sampl.ast.RangeExpr;
import sampl.ast.ReadStmt;
import sampl.ast.Referable;
import sampl.ast.Reference;
import sampl.ast.RepeatStmt;
import sampl.ast.SetDecl;
import sampl.ast.SetLiteral;
import sampl.ast.Stmt;
import sampl.ast.StringLiteral;
import sampl.ast.SubscriptExpr;
import sampl.ast.Suffix;
import sampl.ast.SuffixExpr;
import sampl.ast.TableDecl;
import sampl.ast.TableIOStmt;
import sampl.ast.UnaryExpr;
import sampl.ast.VariableDecl;
import sampl.parser.Action;
import sampl.parser.DeclAction;
import sampl.parser.DeclKind;
import sampl.parser.Identifier;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.parser.Token;
import sampl.parser.TokenKind;
import sampl.sema.ASTConsumer;
import sampl.sema.ConstraintDeclSema;
import sampl.sema.DeclSema;
import sampl.sema.IncludeDirProvider;
import sampl.sema.ObjectiveDeclSema;
import sampl.sema.ParameterDeclSema;
import sampl.sema.ProblemDeclSema;
import sampl.sema.SetDeclSema;
import sampl.sema.TableDeclSema;
import sampl.sema.TreeDeclSema;
import sampl.sema.VariableDeclSema;
import sampl.types.MapType;
import sampl.types.SetType;
import sampl.types.TupleType;
import sampl.types.Type;
import sampl.types.Types;

public final class Sema
implements Action {
    private DiagnosticHandler diagHandler;
    private ASTConsumer consumer;
    private Source source;
    private IdentifierTable identifiers;
    private IncludeDirProvider includes;
    private DeclSema declSema;
    private boolean isRobustConstraintExpr;
    private HashMap<String, TableDecl> tables;
    private HashMap<String, Suffix> suffixes;
    private List<LoopContext> loops = new ArrayList<LoopContext>();
    private Decl infinity;
    private Decl initialProblem;
    private Decl scenarioset;
    private Decl probability;
    private Decl tree;
    private Stack<List<Identifier>> scopes = new Stack();
    private List<Identifier> scenarioScope;
    private List<Decl> references;
    private boolean validData;
    private ParameterDecl[] paramDecls;
    private BitSet isDataNumeric = new BitSet();
    private Object defaultValue;
    private Object[] template;
    private int numWildcards;
    private int[] wildcards;
    private Object key;
    private boolean handleKeys;
    private boolean transpose;
    private Object[] header;

    static boolean isValid(Node node) {
        return node != Expr.INVALID;
    }

    static boolean isValidOrNull(Node node) {
        return node != Expr.INVALID;
    }

    static boolean isConstArithmetic(Expr e) {
        Type type = e.getType();
        return type == Types.NUMERIC || type == Types.SYMBOLIC;
    }

    static boolean isArithmetic(Expr e) {
        Type type = e.getType();
        return type == Types.NUMERIC || type == Types.SYMBOLIC || type == Types.VARIABLE || type == Types.EXPR;
    }

    private static boolean isString(Expr e) {
        Type t = e.getType();
        return t == Types.STRING || t == Types.SYMBOLIC;
    }

    private static boolean isArithmeticOrString(Expr e) {
        return Sema.isArithmetic(e) || e.getType() == Types.STRING;
    }

    private static boolean isIndexed(List<Expr> exprs) {
        return exprs.size() == 1 && exprs.get(0) instanceof IndexedExpr;
    }

    boolean expectConstArithmeticExpr(Expr e) {
        if (Sema.isConstArithmetic(e)) {
            return true;
        }
        this.report(e, "Expected constant arithmetic expression", new Object[0]);
        return false;
    }

    final boolean expectArithmeticExpr(Expr e) {
        if (Sema.isArithmetic(e)) {
            return true;
        }
        this.report(e, "Expected arithmetic expression", new Object[0]);
        return false;
    }

    private boolean expectArithmeticOrStringExpr(Expr e) {
        if (e.getType() == Types.STRING || Sema.isArithmetic(e)) {
            return true;
        }
        this.report(e, "Expected arithmetic or string expression", new Object[0]);
        return false;
    }

    private boolean expectArithmeticOrLogicalExpr(Expr side) {
        if (Sema.isArithmetic(side) || side.hasLogicalType()) {
            return true;
        }
        this.report(side, "Expected arithmetic or logical expression", new Object[0]);
        return false;
    }

    boolean expectSetExpr(Expr e) {
        if (e.getType() instanceof SetType) {
            return true;
        }
        this.report(e, "Expected set expression", new Object[0]);
        return false;
    }

    boolean isScenariosetUsed() {
        return this.references != null && this.references.contains(this.scenarioset);
    }

    void enterRobustConstraintExpr() {
        this.isRobustConstraintExpr = true;
    }

    private Type convertReferenceType(Type type) {
        if (type == Types.VARIABLE || type == Types.OBJECTIVE || type == Types.CONSTRAINT) {
            return Types.NUMERIC;
        }
        return type;
    }

    private boolean checkCondition(Expr condition) {
        Type t = condition.getType();
        if (t == Types.NUMERIC || t == Types.SYMBOLIC || t == Types.LOGICAL || t == Types.LOGICAL_EXPR) {
            return true;
        }
        this.report(condition, "Expected constant arithmetic or logical expression", new Object[0]);
        return false;
    }

    private boolean checkRandomParameter(Token name, Decl decl) {
        if (!(decl instanceof ParameterDecl)) {
            return true;
        }
        ParameterDecl paramDecl = (ParameterDecl)decl;
        if (!paramDecl.hasDistAttr() || this.isRobustConstraintExpr) {
            return true;
        }
        this.report(name.getStartPosition(), "Random parameter with dist attribute is used outside of robust constraint", new Object[0]);
        return false;
    }

    boolean checkArgs(List<Expr> args, int rparenPos, String descriptor) {
        int expectedNumArgs = descriptor.length();
        int numArgs = args.size();
        if (numArgs != expectedNumArgs) {
            if (numArgs > expectedNumArgs) {
                this.report(args.get(expectedNumArgs), "Too many arguments", new Object[0]);
            } else {
                this.report(rparenPos, "Too few arguments", new Object[0]);
            }
            return false;
        }
        boolean isValid = true;
        int i = 0;
        while (i < numArgs) {
            Expr arg = args.get(i);
            if (!Sema.isConstArithmetic(arg)) {
                this.report(arg, "Type mismatch", new Object[0]);
                isValid = false;
            }
            ++i;
        }
        return isValid;
    }

    private boolean checkPrintArg(Expr arg) {
        Type type = arg.getType();
        if (type instanceof MapType) {
            type = ((MapType)type).getValueType();
        }
        if (type != Types.NUMERIC && type != Types.SYMBOLIC && type != Types.STRING && type != Types.LOGICAL && type != Types.VARIABLE && type != Types.OBJECTIVE && type != Types.CONSTRAINT && !(type instanceof SetType)) {
            this.report(arg, "Invalid print argument", new Object[0]);
            return false;
        }
        return true;
    }

    private Expr handleEqualityExpr(BinaryExpr.Kind kind, Expr lhs, Expr rhs) {
        if (!((Sema.isArithmetic(lhs) || lhs instanceof NetExpr) && (Sema.isArithmetic(rhs) || rhs instanceof NetExpr) || Sema.isString(lhs) && Sema.isString(rhs) || lhs.getType() instanceof SetType && rhs.getType() instanceof SetType)) {
            if (Sema.isValid(rhs)) {
                this.report(lhs, "Type mismatch", new Object[0]);
            }
            return Expr.INVALID;
        }
        return new BinaryExpr(Types.LOGICAL, kind, lhs, rhs);
    }

    private Type checkRelationalSide(Expr side) {
        Type type = side.getType();
        if (type == Types.NUMERIC || type == Types.SYMBOLIC) {
            return Types.LOGICAL;
        }
        if (type == Types.VARIABLE || type == Types.EXPR) {
            return Types.LOGICAL_EXPR;
        }
        if (side instanceof NetExpr) {
            return Types.LOGICAL;
        }
        this.report(side, "Expected arithmetic expression", new Object[0]);
        return null;
    }

    private Expr handleRelationalExpr(BinaryExpr.Kind kind, Expr lhs, Expr rhs) {
        Type lhsType = this.checkRelationalSide(lhs);
        Type rhsType = this.checkRelationalSide(rhs);
        if (lhsType == null || rhsType == null) {
            return Expr.INVALID;
        }
        if (rhsType == Types.LOGICAL_EXPR) {
            lhsType = Types.LOGICAL_EXPR;
        }
        return new BinaryExpr(lhsType, kind, lhs, rhs);
    }

    private Expr handleBinaryArithExpr(BinaryExpr.Kind kind, Expr lhs, Expr rhs) {
        Types type = null;
        Type lhsType = lhs.getType();
        Type rhsType = rhs.getType();
        if (Sema.isConstArithmetic(lhs)) {
            if (Sema.isConstArithmetic(rhs)) {
                type = Types.NUMERIC;
            } else if (rhsType == Types.VARIABLE || rhsType == Types.EXPR) {
                type = Types.EXPR;
            } else if (rhsType == Types.RANDOM) {
                type = Types.EXPR;
            }
        } else if (!(lhsType != Types.VARIABLE && lhsType != Types.EXPR && lhsType != Types.RANDOM || !Sema.isArithmetic(rhs) && rhsType != Types.RANDOM)) {
            type = Types.EXPR;
        }
        if (type == null) {
            if (Sema.isValid(rhs)) {
                this.report(lhs, "Type mismatch", new Object[0]);
            }
            return Expr.INVALID;
        }
        return new BinaryExpr(type, kind, lhs, rhs);
    }

    private Expr handleLogicalExpr(BinaryExpr.Kind kind, Expr lhs, Expr rhs) {
        if (!this.expectArithmeticOrLogicalExpr(lhs) || !this.expectArithmeticOrLogicalExpr(rhs)) {
            return Expr.INVALID;
        }
        return new BinaryExpr(Types.LOGICAL, kind, lhs, rhs);
    }

    private Expr handleSetExpr(BinaryExpr.Kind kind, Expr lhs, Expr rhs) {
        if (!this.expectSetExpr(lhs) || !this.expectSetExpr(rhs)) {
            return Expr.INVALID;
        }
        if (lhs.getDimension() != rhs.getDimension()) {
            if (Sema.isValid(rhs)) {
                this.report(lhs, "Dimension mismatch", new Object[0]);
            }
            return Expr.INVALID;
        }
        return new BinaryExpr(lhs.getType(), kind, lhs, rhs);
    }

    private Expr handleIteratedArithExpr(IteratedExpr.Kind kind, Token op, Indexing indexing, Expr arg) {
        Type type = arg.getType();
        if (Sema.isConstArithmetic(arg)) {
            type = Types.NUMERIC;
        } else if (type == Types.EXPR || type == Types.VARIABLE) {
            type = Types.EXPR;
        } else {
            this.report(arg, "Expected arithmetic expression", new Object[0]);
            return Expr.INVALID;
        }
        return new IteratedExpr(op.getStartPosition(), type, kind, indexing, arg);
    }

    private Expr handleIteratedLogicalExpr(IteratedExpr.Kind kind, Token op, Indexing indexing, Expr arg) {
        if (!this.expectArithmeticOrLogicalExpr(arg)) {
            return Expr.INVALID;
        }
        return new IteratedExpr(op.getStartPosition(), Types.LOGICAL, kind, indexing, arg);
    }

    private boolean handleIndexDef(Expr e, Type indexType) {
        if (!(e instanceof IndexDef)) {
            return false;
        }
        IndexDef index = (IndexDef)e;
        Identifier id = index.getIdentifier();
        index.setType(indexType);
        ((List)this.scopes.lastElement()).add(id);
        id.setDecl(index);
        return true;
    }

    static Expr getIndexSetExpr(Expr expr) {
        if (!(expr instanceof BinaryExpr)) {
            return expr;
        }
        BinaryExpr binary = (BinaryExpr)expr;
        if (binary.getKind() != BinaryExpr.Kind.IN) {
            return expr;
        }
        return binary.getRHS();
    }

    private boolean checkScenarioIndexing(Indexing indexing) {
        if (indexing.getNumParts() != 1) {
            this.report(indexing, "Expected scenario indexing only", new Object[0]);
            return false;
        }
        Expr expr = Sema.getIndexSetExpr(indexing.getPart(0));
        SetDecl decl = (SetDecl)expr.getTarget();
        if (decl == null || !decl.isScenarioSet()) {
            this.report(indexing, "Expected scenario indexing", new Object[0]);
            return false;
        }
        return true;
    }

    private Object getData(Token token) {
        Object data = token.getData();
        if (token.is(TokenKind.NUMBER)) {
            data = Double.parseDouble((String)data);
        }
        return data;
    }

    private void setTemplate(List<Token> items) {
        this.numWildcards = 0;
        int i = 0;
        int n = items.size();
        while (i < n) {
            Token item = items.get(i);
            if (item.is(TokenKind.STAR)) {
                this.wildcards[this.numWildcards++] = i;
            } else {
                this.template[i] = this.getData(item);
            }
            ++i;
        }
        this.key = this.numWildcards == 0 ? (this.template.length != 1 ? new Tuple((Object[])this.template.clone()) : this.template[0]) : null;
    }

    private void initKeys(int keySize) {
        this.numWildcards = keySize;
        this.template = new Object[keySize];
        this.wildcards = new int[keySize];
        int i = 0;
        while (i < this.numWildcards) {
            this.wildcards[i] = i;
            ++i;
        }
    }

    private void checkDataType(int index, Token token) {
        if (!token.is(TokenKind.NUMBER) && this.isDataNumeric.get(index)) {
            this.report(token.getStartPosition(), "Expected number", new Object[0]);
            this.validData = false;
        }
    }

    private void handleData(Object key, Token token, int index) {
        Object value;
        if (!token.getData().equals(".")) {
            this.checkDataType(index, token);
            value = this.getData(token);
        } else if (this.defaultValue != null) {
            value = this.defaultValue;
        } else {
            return;
        }
        if (this.validData) {
            this.consumer.onData(key, value, index);
        }
    }

    private boolean checkTemplate(List<Token> items, int rparenPos) {
        int numItems = items.size();
        if (numItems == this.template.length) {
            return true;
        }
        this.validData = false;
        if (numItems > this.template.length) {
            this.report(items.get(this.template.length).getStartPosition(), "Too many items", new Object[0]);
        } else {
            this.report(rparenPos, "Too few items", new Object[0]);
        }
        return false;
    }

    private ParameterDecl addParameter(String name, Type type) {
        ParameterDecl decl = new ParameterDecl(-1, name, ParameterDecl.Kind.DETERMINISTIC);
        decl.setType(type);
        this.identifiers.get(name).setDecl(decl);
        return decl;
    }

    Suffix findSuffix(String name) {
        return this.suffixes.get(name);
    }

    private void reset() {
        this.identifiers.get("Initial").setDecl(this.initialProblem);
        this.infinity = new ParameterDecl(-1, "Infinity", ParameterDecl.Kind.DETERMINISTIC);
        this.infinity.setType(Types.NUMERIC);
        this.identifiers.get("Infinity").setDecl(this.infinity);
        this.addParameter("solve_result", Types.SYMBOLIC);
        this.addParameter("solve_result_num", Types.NUMERIC);
        this.addParameter("solve_exitcode", Types.NUMERIC);
        this.addParameter("_nvars", Types.NUMERIC);
        this.addParameter("_nobjs", Types.NUMERIC);
        this.addParameter("_ncons", Types.NUMERIC);
        Decl decl = this.addParameter("_varname", MapType.get(1, Types.SYMBOLIC));
        Indexing indexing = new Indexing(-1, -1, SetType.get(1), null, null);
        decl.setIndexing(indexing);
        decl = new VariableDecl(-1, "_var", false);
        decl.setType(MapType.get(1, Types.VARIABLE));
        decl.setIndexing(indexing);
        this.identifiers.get("_var").setDecl(decl);
        decl = this.addParameter("_objname", MapType.get(1, Types.SYMBOLIC));
        decl.setIndexing(indexing);
        decl = new ObjectiveDecl(-1, "_obj", false);
        decl.setType(MapType.get(1, Types.OBJECTIVE));
        decl.setIndexing(indexing);
        this.identifiers.get("_obj").setDecl(decl);
        decl = this.addParameter("_conname", MapType.get(1, Types.SYMBOLIC));
        decl.setIndexing(indexing);
        decl = new ConstraintDecl(-1, "_con", false);
        decl.setType(MapType.get(1, Types.CONSTRAINT));
        decl.setIndexing(indexing);
        this.identifiers.get("_con").setDecl(decl);
        decl = new SetDecl(-1, "_HANDLERS", false);
        SetType type = SetType.get(1);
        decl.setType(type);
        this.identifiers.get("_HANDLERS").setDecl(decl);
        decl = this.addParameter("_handler_desc", MapType.get(1, Types.SYMBOLIC));
        decl.setIndexing(new Indexing(-1, -1, type, null, null));
        decl = this.addParameter("_handler_lib", MapType.get(1, Types.SYMBOLIC));
        decl.setIndexing(new Indexing(-1, -1, type, null, null));
        this.addParameter("_default_handler_path", Types.SYMBOLIC);
        Function[] functionArray = Function.values();
        int n = functionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Function f = functionArray[n2];
            this.identifiers.get(f.toString()).setDecl(f);
            ++n2;
        }
        this.scenarioset = null;
        this.probability = null;
        this.tree = null;
    }

    public Sema(DiagnosticHandler diagHandler, ASTConsumer consumer, IdentifierTable identifiers, IncludeDirProvider includes) {
        this.diagHandler = diagHandler;
        this.consumer = consumer;
        this.identifiers = identifiers;
        this.includes = includes;
        this.tables = new HashMap();
        this.suffixes = new HashMap();
        Suffix[] suffixArray = Suffix.values();
        int n = suffixArray.length;
        int n2 = 0;
        while (n2 < n) {
            Suffix s = suffixArray[n2];
            this.suffixes.put(s.toString(), s);
            ++n2;
        }
        this.initialProblem = new ProblemDecl(-1, "Initial");
        this.initialProblem.setType(Types.PROBLEM);
        this.reset();
    }

    void report(int pos, String message, Object ... args) {
        this.diagHandler.diagnostic(new DiagnosticException(String.format(message, args), this.source, pos));
    }

    void report(Node node, String message, Object ... args) {
        if (!Sema.isValid(node)) {
            return;
        }
        this.diagHandler.diagnostic(new DiagnosticException(String.format(message, args), this.source, node.getStart()));
    }

    private void reportRedeclaration(Decl decl, Referable prevDecl) {
        decl.setInvalid();
        this.report(decl.getStart(), "Redeclaration of '%s'", decl.getName());
    }

    Referable find(String name) {
        return this.identifiers.get(name).getDecl();
    }

    @Override
    public void onSourceStart(Source s) {
        this.source = s;
        this.consumer.onSourceSwitch(s);
    }

    @Override
    public void onSourceEnd() {
    }

    @Override
    public DeclAction onDecl(DeclKind kind, Token start, Token name, Token alias) {
        Identifier idInfo = name.getIdentifier();
        String id = idInfo.toString();
        int pos = start.getStartPosition();
        this.isRobustConstraintExpr = false;
        switch (kind) {
            case SET: {
                this.declSema = new SetDeclSema(this, pos, id, false);
                break;
            }
            case SCENARIOSET: {
                this.declSema = new SetDeclSema(this, pos, id, true);
                if (this.scenarioset != null) {
                    this.report(pos, "Redefinition of scenario set", new Object[0]);
                }
                this.scenarioset = this.declSema.getDecl();
                break;
            }
            case PARAMETER: {
                this.declSema = new ParameterDeclSema(this, pos, id, ParameterDecl.Kind.DETERMINISTIC);
                break;
            }
            case RANDOM: {
                this.declSema = new ParameterDeclSema(this, pos, id, ParameterDecl.Kind.RANDOM);
                break;
            }
            case PROBABILITY: {
                this.declSema = new ParameterDeclSema(this, pos, id, ParameterDecl.Kind.PROBABILITY);
                if (this.probability != null) {
                    this.report(pos, "Redefinition of probability parameter", new Object[0]);
                }
                this.probability = this.declSema.getDecl();
                break;
            }
            case VARIABLE: {
                this.declSema = new VariableDeclSema(this, pos, id, false);
                break;
            }
            case ARC: {
                this.declSema = new VariableDeclSema(this, pos, id, true);
                break;
            }
            case OBJECTIVE: {
                this.declSema = new ObjectiveDeclSema(this, pos, id, start.is(TokenKind.KW_maximize));
                break;
            }
            case CONSTRAINT: {
                this.declSema = new ConstraintDeclSema(this, pos, id, false);
                break;
            }
            case NODE: {
                this.declSema = new ConstraintDeclSema(this, pos, id, true);
                break;
            }
            case PROBLEM: {
                this.declSema = new ProblemDeclSema(this, pos, id);
                break;
            }
            case TABLE: {
                this.declSema = new TableDeclSema(this, pos, id);
                TableDecl decl = (TableDecl)this.declSema.getDecl();
                TableDecl prevDecl = this.tables.put(id, decl);
                if (prevDecl != null) {
                    this.reportRedeclaration(decl, prevDecl);
                }
                return this.declSema;
            }
            case TREE: {
                this.declSema = new TreeDeclSema(this, pos, id);
                if (this.tree != null) {
                    this.report(pos, "Redefinition of scenario tree", new Object[0]);
                }
                this.tree = this.declSema.getDecl();
            }
        }
        Decl decl = this.declSema.getDecl();
        Referable prevDecl = idInfo.getDecl();
        if (prevDecl != null) {
            if (prevDecl instanceof Decl) {
                this.reportRedeclaration(decl, prevDecl);
            } else if (prevDecl instanceof IndexDef) {
                this.report(name.getStartPosition(), "Name being declared can't be used in the declaration indexing.", new Object[0]);
            } else {
                idInfo.setDecl(decl);
            }
        } else {
            idInfo.setDecl(decl);
        }
        return this.declSema;
    }

    @Override
    public void onDeclEnd(int semiPos) {
        Decl decl = this.declSema.getDecl();
        if (this.declSema.hasErrors() || semiPos == Parser.NOPOS) {
            decl.setInvalid();
        }
        decl.setEnd(semiPos);
        if (this.references != null) {
            decl.setReferences(this.references);
            this.references = null;
        }
        this.consumer.onDecl(decl);
        this.declSema = null;
    }

    @Override
    public void onCheckDecl(int checkPos, Indexing indexing, Expr expr, int semiPos) {
        if (!Sema.isValidOrNull(indexing) || !this.checkCondition(expr)) {
            return;
        }
        this.consumer.onDecl(new CheckDecl(checkPos, semiPos, indexing, expr));
    }

    Direction convertDirection(Token inout) {
        switch (inout.getKind()) {
            case KW_IN: {
                return Direction.IN;
            }
            case KW_OUT: {
                return Direction.OUT;
            }
            case KW_INOUT: {
                return Direction.INOUT;
            }
        }
        return null;
    }

    @Override
    public ColGroup onColumn(Indexing indexing, Expr expr, Token colName, Token inout) {
        int end;
        int start = expr.getStart();
        String colNameStr = colName != null ? colName.getData().toString() : null;
        Direction dir = null;
        if (inout != null) {
            dir = this.convertDirection(inout);
            end = inout.getStartPosition() + inout.getIdentifier().length();
        } else {
            end = colNameStr != null ? colName.getStartPosition() + colNameStr.length() : expr.getEnd();
        }
        return new ColGroup(start, end, indexing, expr, colNameStr, dir);
    }

    @Override
    public Expr onKeyColSpec(Token index, Token colName) {
        Expr ref = this.onReference(colName, Action.ReferenceKind.COLUMN_NAME);
        if (index == null) {
            return ref;
        }
        assert (index.isKeywordOrIdentifier());
        IndexDef indexDef = new IndexDef(index.getStartPosition(), index.getIdentifier());
        this.handleIndexDef(indexDef, Types.SYMBOLIC);
        return new BinaryExpr(Types.LOGICAL, BinaryExpr.Kind.TILDE, indexDef, ref);
    }

    @Override
    public Expr onNumericLiteral(Token number) {
        String str = (String)number.getData();
        double value = Double.parseDouble(str.replaceAll("[dD]", "e"));
        int start = number.getStartPosition();
        return new NumericLiteral(start, start + str.length() - 1, value);
    }

    @Override
    public Expr onStringLiteral(Token string) {
        char c;
        String value = (String)string.getData();
        if (value.length() >= 2 && ((c = value.charAt(0)) == '\'' || c == '\"')) {
            value = value.substring(1, value.length() - 1);
        }
        int start = string.getStartPosition();
        return new StringLiteral(start, start + value.length() - 1, value);
    }

    @Override
    public Expr onStringLiteral(List<Token> strings) {
        StringBuilder sb = new StringBuilder();
        int start = strings.get(0).getStartPosition();
        Token last = strings.get(strings.size() - 1);
        int end = last.getStartPosition() + ((String)last.getData()).length() - 1;
        for (Token str : strings) {
            sb.append((String)str.getData());
        }
        return new StringLiteral(start, end, sb.toString());
    }

    @Override
    public Expr onSetLiteral(int lbracePos, List<Expr> members, int rbracePos) {
        int dimension = 0;
        if (!members.isEmpty()) {
            boolean isValid = true;
            Expr first = members.get(0);
            if (Sema.isValid(first)) {
                dimension = first.getType().getDimension();
            }
            for (Expr member : members) {
                if (!Sema.isValid(member)) {
                    isValid = false;
                    continue;
                }
                int d = member.getType().getDimension();
                if (d != 1) {
                    for (Expr item : ((ParenExpr)member).getItems()) {
                        isValid &= this.expectArithmeticOrStringExpr(item);
                    }
                } else {
                    isValid &= this.expectArithmeticOrStringExpr(member);
                }
                if (d == dimension) continue;
                isValid = false;
                this.report(member, d < dimension ? "Too few items" : "Too many items", new Object[0]);
            }
            if (!isValid) {
                return Expr.INVALID;
            }
        }
        return new SetLiteral(lbracePos, rbracePos, SetType.get(dimension), members);
    }

    @Override
    public Expr onReference(Token name, Action.ReferenceKind kind) {
        Referable target;
        assert (name.isKeywordOrIdentifier());
        Identifier id = name.getIdentifier();
        Referable referable = target = kind == Action.ReferenceKind.TABLE_NAME ? (Referable)this.tables.get(id.toString()) : id.getDecl();
        if (target == null) {
            if (kind == Action.ReferenceKind.ALLOW_INDEX) {
                return new IndexDef(name.getStartPosition(), id);
            }
            if (kind == Action.ReferenceKind.COLUMN_NAME) {
                return new Reference(name.getStartPosition(), null, id, null);
            }
            this.report(name.getStartPosition(), "'%s' is not declared", id);
            return Expr.INVALID;
        }
        Type type = target.getType();
        if (target instanceof Decl) {
            Decl decl = (Decl)target;
            if (!decl.isValid()) {
                return Expr.INVALID;
            }
            if (type == null) {
                this.report(name.getStartPosition(), "'%s' is not defined", id);
                return Expr.INVALID;
            }
            if (!this.checkRandomParameter(name, decl)) {
                return Expr.INVALID;
            }
            if (this.declSema != null && decl != this.infinity) {
                if (this.references == null) {
                    this.references = new ArrayList<Decl>();
                }
                this.references.add(decl);
            }
            if (this.declSema == null && decl.getIndexing() == null) {
                type = this.convertReferenceType(type);
            }
        } else if (target instanceof Function) {
            this.report(name.getStartPosition(), "Invalid use of function", new Object[0]);
            return Expr.INVALID;
        }
        return new Reference(name.getStartPosition(), type, id, target);
    }

    @Override
    public Expr onSubscriptExpr(Token name, List<Expr> subscripts, int rbracketPos, boolean isTableName) {
        int expectedNumSubs;
        int numSubs;
        Referable named;
        assert (name.isKeywordOrIdentifier());
        Identifier id = name.getIdentifier();
        Referable referable = named = isTableName ? (Referable)this.tables.get(id.toString()) : id.getDecl();
        if (!(named instanceof Decl)) {
            this.report(name.getStartPosition(), "Invalid use of function", new Object[0]);
            return Expr.INVALID;
        }
        Decl decl = (Decl)named;
        Type type = null;
        if (decl != null && (type = decl.getType()) == null && this.declSema != null) {
            type = this.declSema.fixType();
        }
        if (!(type instanceof MapType)) {
            if (type != null) {
                this.report(name.getStartPosition(), "'%s' can't have subscript", id);
            } else {
                this.report(name.getStartPosition(), "'%s' is not defined", id);
            }
            return Expr.INVALID;
        }
        if (!this.checkRandomParameter(name, decl)) {
            return Expr.INVALID;
        }
        if (this.references != null) {
            this.references.add(decl);
        }
        boolean isValid = true;
        int scenarioSubIndex = -1;
        Type itemType = ((MapType)type).getValueType();
        if (this.declSema != null) {
            Indexing indexing = decl.getIndexing();
            if (indexing != null && (scenarioSubIndex = indexing.getScenarioSubIndex()) != -1) {
                Expr sub = subscripts.get(scenarioSubIndex);
                if (sub.getType() != Types.SCENARIO) {
                    this.report(sub, "Invalid scenario subscript", new Object[0]);
                    isValid = false;
                } else {
                    itemType = Types.EXPR;
                }
            }
        } else {
            itemType = this.convertReferenceType(itemType);
        }
        if ((numSubs = subscripts.size()) != (expectedNumSubs = type.getDimension())) {
            if (numSubs > expectedNumSubs) {
                this.report(subscripts.get(expectedNumSubs), "Too many subscripts", new Object[0]);
            } else {
                this.report(rbracketPos, "Too few subscripts", new Object[0]);
            }
            isValid = false;
        }
        int i = 0;
        while (i < numSubs) {
            Expr sub = subscripts.get(i);
            if (!(Sema.isArithmeticOrString(sub) || sub.getType() == Types.SCENARIO && i == scenarioSubIndex)) {
                this.report(sub, "Expected arithmetic or string expression", new Object[0]);
                isValid = false;
            }
            ++i;
        }
        if (!isValid) {
            return Expr.INVALID;
        }
        return new SubscriptExpr(name.getStartPosition(), rbracketPos, itemType, decl, subscripts);
    }

    @Override
    public Expr onSuffixExpr(Expr reference, Token suffix) {
        assert (suffix.isKeywordOrIdentifier());
        if (!Sema.isValid(reference)) {
            return Expr.INVALID;
        }
        String suffixName = suffix.getIdentifier().toString();
        Suffix decl = this.suffixes.get(suffixName);
        if (decl == null) {
            this.report(suffix.getStartPosition(), "Unknown suffix '%s'", suffixName);
            return Expr.INVALID;
        }
        Referable refDecl = reference.getTarget();
        if (!decl.supports(refDecl)) {
            this.report(suffix.getStartPosition(), "Suffix '%s' can't be used with '%s'", suffixName, refDecl.getName());
            return Expr.INVALID;
        }
        reference.setType(reference.getOriginalType());
        return new SuffixExpr(suffix.getStartPosition(), decl.getType(), reference, decl);
    }

    @Override
    public Expr onCallExpr(Token name, List<Expr> args, int rparenPos) {
        assert (name.isKeywordOrIdentifier());
        Identifier id = name.getIdentifier();
        Referable decl = id.getDecl();
        if (!(decl instanceof Function)) {
            this.report(name.getStartPosition(), decl == null ? "'%s' is not declared" : "'%s' is not a function", id);
            return Expr.INVALID;
        }
        Function funcDecl = (Function)decl;
        boolean isValid = true;
        String argTypes = funcDecl.getArgTypes();
        int numExpectedArgs = argTypes.length();
        int numArgs = args != null ? args.size() : 0;
        int i = 0;
        while (i < numArgs) {
            Expr arg = args.get(i);
            if (i >= numExpectedArgs) {
                this.report(arg, "Too many arguments", new Object[0]);
                isValid = false;
                break;
            }
            char argType = argTypes.charAt(i);
            if (argType == 'D') {
                isValid &= this.expectArithmeticExpr(arg);
            } else {
                assert (argType == 'S');
                isValid &= this.expectSetExpr(arg);
            }
            ++i;
        }
        if (numArgs < numExpectedArgs) {
            this.report(rparenPos, "Too few arguments", new Object[0]);
            isValid = false;
        }
        if (!isValid) {
            return Expr.INVALID;
        }
        return new CallExpr(name.getStartPosition(), rparenPos, Types.NUMERIC, funcDecl, args);
    }

    @Override
    public Expr onParenExpr(int lparenPos, List<Expr> items, int rparenPos) {
        Type type;
        int numItems = items.size();
        if (numItems == 1) {
            Expr item = items.get(0);
            if (!Sema.isValid(item)) {
                return Expr.INVALID;
            }
            type = item.getType();
        } else {
            type = TupleType.get(numItems);
        }
        return new ParenExpr(lparenPos, rparenPos, type, items);
    }

    @Override
    public Expr onUnaryExpr(Token op, Expr arg) {
        if (op.is(TokenKind.MINUS) || op.is(TokenKind.PLUS)) {
            Type type = arg.getType();
            if (type != Types.NUMERIC) {
                if (type == Types.SYMBOLIC) {
                    type = Types.NUMERIC;
                } else if (type == Types.VARIABLE) {
                    type = Types.EXPR;
                } else if (type != Types.EXPR) {
                    this.report(arg, "Expected arithmetic expression", new Object[0]);
                    return Expr.INVALID;
                }
            }
            UnaryExpr.Kind kind = op.is(TokenKind.PLUS) ? UnaryExpr.Kind.PLUS : UnaryExpr.Kind.MINUS;
            return new UnaryExpr(op.getStartPosition(), type, kind, arg);
        }
        assert (op.is(TokenKind.EXCL) || op.is(TokenKind.KW_not));
        if (!this.expectArithmeticOrLogicalExpr(arg)) {
            return Expr.INVALID;
        }
        return new UnaryExpr(op.getStartPosition(), Types.LOGICAL, UnaryExpr.Kind.NOT, arg);
    }

    @Override
    public Expr onBinaryExpr(Expr lhs, Token op, Expr rhs, boolean hasNot) {
        switch (op.getKind()) {
            default: {
                assert (false) : "Invalid binary operator.";
            }
            case PLUS: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.ADD, lhs, rhs);
            }
            case MINUS: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.SUB, lhs, rhs);
            }
            case KW_less: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.LESS, lhs, rhs);
            }
            case STAR: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.MUL, lhs, rhs);
            }
            case SLASH: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.DIV, lhs, rhs);
            }
            case KW_div: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.IDIV, lhs, rhs);
            }
            case KW_mod: {
                return this.handleBinaryArithExpr(BinaryExpr.Kind.MOD, lhs, rhs);
            }
            case LESS: {
                return this.handleRelationalExpr(BinaryExpr.Kind.LT, lhs, rhs);
            }
            case LESS_EQUAL: {
                return this.handleRelationalExpr(BinaryExpr.Kind.LE, lhs, rhs);
            }
            case EQUAL: 
            case EQUAL_EQUAL: {
                return this.handleEqualityExpr(BinaryExpr.Kind.EQ, lhs, rhs);
            }
            case GREATER: {
                return this.handleRelationalExpr(BinaryExpr.Kind.GT, lhs, rhs);
            }
            case GREATER_EQUAL: {
                return this.handleRelationalExpr(BinaryExpr.Kind.GE, lhs, rhs);
            }
            case EXCL_EQUAL: 
            case LESS_GREATER: {
                return this.handleEqualityExpr(BinaryExpr.Kind.NE, lhs, rhs);
            }
            case AMP: {
                if (!this.expectArithmeticOrStringExpr(lhs) || !this.expectArithmeticOrStringExpr(rhs)) {
                    return Expr.INVALID;
                }
                return new BinaryExpr(Types.STRING, BinaryExpr.Kind.CONCAT, lhs, rhs);
            }
            case PIPE_PIPE: 
            case KW_or: {
                return this.handleLogicalExpr(BinaryExpr.Kind.OR, lhs, rhs);
            }
            case AMP_AMP: 
            case KW_and: {
                return this.handleLogicalExpr(BinaryExpr.Kind.AND, lhs, rhs);
            }
            case KW_in: {
                Type rhsType = rhs.getType();
                if (!(rhsType instanceof SetType)) {
                    this.report(rhs, "Expected set expression", new Object[0]);
                    return Expr.INVALID;
                }
                int dimen = rhsType.getDimension();
                if (dimen == 1) {
                    if (!this.expectArithmeticOrStringExpr(lhs)) {
                        return Expr.INVALID;
                    }
                } else if (lhs.getType() instanceof TupleType) {
                    if (lhs.getDimension() != dimen) {
                        this.report(lhs, "Dimension mismatch", new Object[0]);
                        return Expr.INVALID;
                    }
                } else {
                    this.report(lhs, "Expected tuple", new Object[0]);
                    return Expr.INVALID;
                }
                BinaryExpr.Kind kind = hasNot ? BinaryExpr.Kind.NOTIN : BinaryExpr.Kind.IN;
                return new BinaryExpr(Types.LOGICAL, kind, lhs, rhs);
            }
            case KW_union: {
                return this.handleSetExpr(BinaryExpr.Kind.UNION, lhs, rhs);
            }
            case KW_diff: {
                return this.handleSetExpr(BinaryExpr.Kind.DIFF, lhs, rhs);
            }
            case KW_symdiff: {
                return this.handleSetExpr(BinaryExpr.Kind.SYMDIFF, lhs, rhs);
            }
            case KW_cross: {
                if (!this.expectSetExpr(lhs) || !this.expectSetExpr(rhs)) {
                    return Expr.INVALID;
                }
                SetType type = SetType.get(lhs.getDimension() + rhs.getDimension());
                return new BinaryExpr(type, BinaryExpr.Kind.CROSS, lhs, rhs);
            }
            case CARET: 
            case STAR_STAR: 
        }
        return this.handleBinaryArithExpr(BinaryExpr.Kind.EXP, lhs, rhs);
    }

    @Override
    public Expr onRangeExpr(Expr lhs, Expr rhs, Expr by) {
        if (!this.expectConstArithmeticExpr(lhs) || !this.expectConstArithmeticExpr(rhs) || by != null && !this.expectConstArithmeticExpr(by)) {
            return Expr.INVALID;
        }
        return new RangeExpr(SetType.get(1), lhs, rhs, by);
    }

    @Override
    public Expr onIteratedExpr(Token op, Indexing indexing, Expr arg) {
        IteratedExpr.Kind kind;
        Type type;
        if (!Sema.isValid(indexing)) {
            return Expr.INVALID;
        }
        switch (op.getKind()) {
            default: {
                assert (false) : "Invalid binary operator.";
            }
            case KW_sum: {
                return this.handleIteratedArithExpr(IteratedExpr.Kind.SUM, op, indexing, arg);
            }
            case KW_prod: 
            case KW_product: {
                return this.handleIteratedArithExpr(IteratedExpr.Kind.PROD, op, indexing, arg);
            }
            case KW_min: {
                return this.handleIteratedArithExpr(IteratedExpr.Kind.MIN, op, indexing, arg);
            }
            case KW_max: {
                return this.handleIteratedArithExpr(IteratedExpr.Kind.MAX, op, indexing, arg);
            }
            case KW_exists: {
                return this.handleIteratedLogicalExpr(IteratedExpr.Kind.EXISTS, op, indexing, arg);
            }
            case KW_forall: {
                return this.handleIteratedLogicalExpr(IteratedExpr.Kind.FORALL, op, indexing, arg);
            }
            case KW_union: {
                if (!this.expectSetExpr(arg)) {
                    return Expr.INVALID;
                }
                type = arg.getType();
                kind = IteratedExpr.Kind.UNION;
                break;
            }
            case KW_setof: {
                if (!Sema.isArithmeticOrString(arg) && !(arg.getType() instanceof TupleType)) {
                    this.report(arg, "Expected arithmetic or string expression or tuple", new Object[0]);
                    return Expr.INVALID;
                }
                type = SetType.get(arg.getDimension());
                kind = IteratedExpr.Kind.SETOF;
                break;
            }
            case KW_probability: {
                if (!this.checkScenarioIndexing(indexing)) {
                    return Expr.INVALID;
                }
                Expr condition = indexing.getCondition();
                if (condition == null) {
                    this.report(indexing.getEnd(), "Expected ':'", new Object[0]);
                    return Expr.INVALID;
                }
                type = condition.getType() == Types.LOGICAL ? Types.NUMERIC : Types.EXPR;
                kind = IteratedExpr.Kind.PROBABILITY;
                break;
            }
            case KW_expectation: {
                if (!this.checkScenarioIndexing(indexing) || !this.expectArithmeticExpr(arg)) {
                    return Expr.INVALID;
                }
                type = arg.getType();
                kind = IteratedExpr.Kind.EXPECTATION;
            }
        }
        return new IteratedExpr(op.getStartPosition(), type, kind, indexing, arg);
    }

    @Override
    public Expr onIndexedExpr(Indexing indexing, Expr arg) {
        if (!Sema.isValid(indexing) || !Sema.isValid(arg)) {
            return Expr.INVALID;
        }
        MapType type = MapType.get(indexing.getDimension(), arg.getType());
        return new IndexedExpr(type, indexing, arg);
    }

    @Override
    public boolean isIndex(Expr expr) {
        if (expr instanceof BinaryExpr && ((BinaryExpr)expr).getKind() == BinaryExpr.Kind.IN) {
            return true;
        }
        return expr.getType() instanceof SetType;
    }

    @Override
    public Expr onIndex(Expr expr) {
        Type type;
        boolean isScenarioSet;
        Expr setExpr;
        BinaryExpr binExpr = null;
        if (expr.getType() instanceof SetType) {
            setExpr = expr;
        } else if (expr instanceof BinaryExpr) {
            binExpr = (BinaryExpr)expr;
            if (binExpr.getKind() != BinaryExpr.Kind.IN) {
                this.report(expr, "Expected set expression", new Object[0]);
                return Expr.INVALID;
            }
            setExpr = binExpr.getRHS();
        } else {
            this.report(expr, "Expected set expression", new Object[0]);
            return Expr.INVALID;
        }
        Referable decl = setExpr.getTarget();
        boolean isValid = true;
        boolean bl = isScenarioSet = decl != null && ((SetDecl)decl).isScenarioSet();
        if (isScenarioSet) {
            if (this.isRobustConstraintExpr) {
                this.report(expr, "Scenario indexing can't be used in a robust constraint", new Object[0]);
                isValid = false;
            } else if (this.scenarioScope != null) {
                this.report(expr, "Nested scenario indexing", new Object[0]);
                isValid = false;
            } else {
                this.scenarioScope = (List)this.scopes.lastElement();
            }
        }
        if (binExpr == null) {
            return isValid ? expr : Expr.INVALID;
        }
        Types indexType = Types.SYMBOLIC;
        if (isScenarioSet && this.declSema != null && this.declSema.needsScenarioConversion()) {
            indexType = Types.SCENARIO;
        }
        Expr lhs = binExpr.getLHS();
        int rhsDimen = setExpr.getDimension();
        if (rhsDimen == 1) {
            if (!this.handleIndexDef(lhs, indexType)) {
                this.report(lhs, "Expected new index name", new Object[0]);
                return Expr.INVALID;
            }
            type = lhs.getType();
        } else {
            int numDummyIndices = 0;
            for (Expr item : ((ParenExpr)lhs).getItems()) {
                numDummyIndices += this.handleIndexDef(item, indexType) ? 1 : 0;
            }
            type = TupleType.get(numDummyIndices);
        }
        expr.setType(type);
        return isValid ? expr : Expr.INVALID;
    }

    @Override
    public void enterScope() {
        this.scopes.push(new ArrayList());
    }

    @Override
    public void leaveScope() {
        List<Identifier> scope = this.scopes.pop();
        for (Identifier id : scope) {
            id.setDecl(null);
        }
        if (scope == this.scenarioScope) {
            this.scenarioScope = null;
        }
    }

    @Override
    public Indexing onIndexingExpr(int lbracePos, List<Expr> parts, Expr condition, int rbracePos) {
        int dimension = 0;
        for (Expr part : parts) {
            if (!Sema.isValid(part)) {
                return Expr.INVALID;
            }
            dimension += part.getDimension();
        }
        if (condition != null && !this.checkCondition(condition)) {
            return Expr.INVALID;
        }
        return new Indexing(lbracePos, rbracePos, SetType.get(dimension), parts, condition);
    }

    @Override
    public Expr onConditionalExpr(int ifPos, Expr condition, Expr thenExpr, Expr elseExpr) {
        if (!this.checkCondition(condition)) {
            return Expr.INVALID;
        }
        Type thenType = thenExpr.getType();
        Type elseType = elseExpr != null ? elseExpr.getType() : Types.NUMERIC;
        Type type = null;
        if (thenType == elseType) {
            if (thenType == Types.NUMERIC || thenType == Types.SYMBOLIC || thenType == Types.STRING || thenType == Types.VARIABLE || thenType == Types.EXPR) {
                type = thenType;
            }
        } else if (thenType == Types.NUMERIC) {
            if (elseType == Types.STRING) {
                type = Types.SYMBOLIC;
            } else if (elseType == Types.VARIABLE) {
                type = Types.EXPR;
            } else if (elseType == Types.EXPR) {
                type = Types.EXPR;
            }
        } else if (elseType == Types.NUMERIC) {
            if (thenType == Types.STRING) {
                type = Types.SYMBOLIC;
            } else if (thenType == Types.VARIABLE) {
                type = Types.EXPR;
            } else if (thenType == Types.EXPR) {
                type = Types.EXPR;
            }
        } else if (thenType == Types.VARIABLE) {
            if (elseType == Types.EXPR) {
                type = Types.EXPR;
            }
        } else if (thenType instanceof SetType && elseType instanceof SetType) {
            if (((SetType)thenType).getDimension() != ((SetType)elseType).getDimension()) {
                if (Sema.isValid(elseExpr)) {
                    this.report(thenExpr, "Dimension mismatch", new Object[0]);
                }
                return Expr.INVALID;
            }
            type = thenType;
        }
        if (type == null) {
            this.report(ifPos, "Type mismatch", new Object[0]);
            return Expr.INVALID;
        }
        return new ConditionalExpr(ifPos, type, condition, thenExpr, elseExpr);
    }

    @Override
    public Expr onDoubleInequalityExpr(Token op, Expr lhs, Expr mid, Expr rhs) {
        assert (op.is(TokenKind.LESS_EQUAL) || op.is(TokenKind.GREATER_EQUAL));
        boolean lessEqual = op.is(TokenKind.LESS_EQUAL);
        return new DoubleInequalityExpr(null, lessEqual, lhs, mid, rhs);
    }

    @Override
    public Expr onPiecewiseLinearExpr(int lessLessPos, List<Expr> breakpoints, List<Expr> slopes, int greaterGreaterPos, Expr expr) {
        Types type;
        boolean valid = true;
        boolean indexed = false;
        if (!Sema.isIndexed(breakpoints)) {
            for (Expr breakpoint : breakpoints) {
                valid &= this.expectConstArithmeticExpr(breakpoint);
            }
        } else {
            indexed = true;
        }
        if (!Sema.isIndexed(slopes)) {
            for (Expr slope : slopes) {
                valid &= this.expectConstArithmeticExpr(slope);
            }
        } else {
            indexed = true;
        }
        if (!indexed) {
            int expectedNumSlopes = breakpoints.size() + 1;
            int numSlopes = slopes.size();
            if (numSlopes != expectedNumSlopes) {
                if (numSlopes > expectedNumSlopes) {
                    this.report(slopes.get(expectedNumSlopes), "Too many slopes", new Object[0]);
                } else {
                    this.report(greaterGreaterPos, "Too few slopes", new Object[0]);
                }
                valid = false;
            }
        }
        if (expr.getType() == Types.VARIABLE) {
            type = Types.EXPR;
        } else if (Sema.isConstArithmetic(expr)) {
            type = Types.NUMERIC;
        } else {
            this.report(expr, "Expected constant arithmetic expression or variable", new Object[0]);
            return Expr.INVALID;
        }
        if (!valid) {
            return Expr.INVALID;
        }
        return new PiecewiseLinearExpr(lessLessPos, greaterGreaterPos, type, breakpoints, slopes, expr);
    }

    @Override
    public Expr onNetExpr(Token keyword, Token op, Expr expr) {
        NetExpr.Kind kind;
        switch (keyword.getKind()) {
            default: {
                assert (false) : "Invalid net expression.";
            }
            case KW_net_in: {
                kind = NetExpr.Kind.NET_IN;
                break;
            }
            case KW_net_out: {
                kind = NetExpr.Kind.NET_OUT;
                break;
            }
            case KW_to_come: {
                kind = NetExpr.Kind.TO_COME;
            }
        }
        return new NetExpr(keyword.getStartPosition(), kind, expr);
    }

    @Override
    public void onTopLevelStmt(Stmt stmt) throws SAMPLException {
        if (Sema.isValid(stmt)) {
            this.consumer.onTopLevelStmt(stmt);
        }
    }

    @Override
    public Stmt onEmptyStmt(Token semi) {
        return new EmptyStmt(semi.getStartPosition());
    }

    @Override
    public Stmt onJumpStmt(Token keyword, Token loopName, int semiPos) {
        boolean isContinue = keyword.is(TokenKind.KW_continue);
        if (this.loops.isEmpty()) {
            this.report(keyword.getStartPosition(), "'%s' is outside of a loop", keyword.getData());
            return Stmt.INVALID;
        }
        LoopContext loop = null;
        int lastIndex = this.loops.size() - 1;
        if (loopName != null) {
            assert (loopName.isKeywordOrIdentifier());
            Identifier name = loopName.getIdentifier();
            int i = lastIndex;
            while (i >= 0) {
                LoopContext li = this.loops.get(i);
                if (li.getName() == name) {
                    loop = li;
                    break;
                }
                --i;
            }
            if (loop == null) {
                this.report(loopName.getStartPosition(), "'%s' is not a loop name", name);
                return Stmt.INVALID;
            }
        } else {
            loop = this.loops.get(lastIndex);
        }
        return new JumpStmt(keyword.getStartPosition(), semiPos, isContinue, loop);
    }

    @Override
    public Stmt onBasicStmt(Token keyword, Expr expr, Expr filename, int semiPos) {
        BasicStmt.Kind kind;
        switch (keyword.getKind()) {
            case KW_shell: {
                assert (filename == null);
                kind = BasicStmt.Kind.SHELL;
                if (expr == null || this.expectArithmeticOrStringExpr(expr)) break;
                return Stmt.INVALID;
            }
            case KW_solve: {
                if (expr != null && expr.getType() != Types.PROBLEM) {
                    if (expr.getTarget() instanceof ObjectiveDecl) {
                        expr.setType(Types.OBJECTIVE);
                    } else {
                        this.report(expr, "Expected objective or problem", new Object[0]);
                        return Stmt.INVALID;
                    }
                }
                kind = BasicStmt.Kind.SOLVE;
                break;
            }
            case KW_solution: {
                assert (filename == null);
                if (expr == null) {
                    this.report(semiPos, "Expected arithmetic or string expression", new Object[0]);
                    return Stmt.INVALID;
                }
                if (!this.expectArithmeticOrStringExpr(expr)) {
                    return Stmt.INVALID;
                }
                kind = BasicStmt.Kind.SOLUTION;
                break;
            }
            case KW_write: {
                assert (filename == null);
                kind = BasicStmt.Kind.WRITE;
                if (expr == null || this.expectArithmeticOrStringExpr(expr)) break;
                return Stmt.INVALID;
            }
            case KW_reset: {
                assert (filename == null);
                if (expr != null) {
                    this.report(expr, "Expected ';'", new Object[0]);
                    return Stmt.INVALID;
                }
                kind = BasicStmt.Kind.RESET;
                this.identifiers.reset();
                this.reset();
                break;
            }
            case KW_data: {
                assert (filename == null && expr == null);
                kind = BasicStmt.Kind.DATA;
                break;
            }
            default: {
                return Stmt.INVALID;
            }
        }
        return new BasicStmt(keyword.getStartPosition(), semiPos, kind, expr, filename);
    }

    @Override
    public Stmt onIncludeStmt(Token keyword, Expr expr, Token end) throws SAMPLException {
        if (!(expr instanceof StringLiteral)) {
            this.report(expr, "Expected string", new Object[0]);
            return Stmt.INVALID;
        }
        if (this.includes == null) {
            return Stmt.INVALID;
        }
        String filename = ((StringLiteral)expr).getValue();
        Source included = null;
        try {
            String[] stringArray = this.includes.getIncludes().split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                String path = String.valueOf(dir) + File.separatorChar + filename;
                if (new File(path).exists()) {
                    included = Source.newFileSource(path);
                    break;
                }
                ++n2;
            }
        }
        catch (IOException dir) {
            // empty catch block
        }
        if (included == null) {
            this.report(expr, "File not found", new Object[0]);
            return Stmt.INVALID;
        }
        Source savedSource = this.source;
        this.source = included;
        Parser parser = new Parser(this, this.identifiers, this.diagHandler);
        try {
            parser.parse(included, keyword.is(TokenKind.KW_data));
        }
        finally {
            this.source = savedSource;
            this.consumer.onSourceSwitch(this.source);
        }
        return Stmt.INVALID;
    }

    @Override
    public Option onOption(Token name, Token option, Expr value) {
        int endPos;
        Referable decl;
        int startPos;
        assert (option.isKeywordOrIdentifier());
        Identifier optionName = option.getIdentifier();
        if (name != null) {
            startPos = name.getStartPosition();
            Identifier id = name.getIdentifier();
            decl = id.getDecl();
            if (decl == null) {
                this.report(name.getStartPosition(), "'%s' is not declared", id);
                optionName = null;
            } else if (!(decl instanceof ProblemDecl)) {
                this.report(name.getStartPosition(), "'%s' is not a problem name", id);
                optionName = null;
                decl = null;
            }
        } else {
            startPos = option.getStartPosition();
            decl = null;
        }
        if (value != null) {
            endPos = value.getEnd();
            if (!this.expectArithmeticOrStringExpr(value)) {
                optionName = null;
            }
        } else {
            endPos = option.getStartPosition();
        }
        return new Option(startPos, endPos, (Decl)decl, optionName, value);
    }

    @Override
    public Stmt onOptionStmt(int optionPos, List<Option> options, int semiPos) {
        for (Option opt : options) {
            if (opt.getName() != null) continue;
            return Stmt.INVALID;
        }
        return new OptionStmt(optionPos, semiPos, options);
    }

    @Override
    public Stmt onCheckStmt(int checkPos, int semiPos) {
        return new CheckStmt(checkPos, semiPos);
    }

    @Override
    public Stmt onLetStmt(int letPos, Indexing indexing, Expr lhs, Expr rhs, int semiPos) {
        Type rhsType;
        Referable decl = lhs.getTarget();
        if (decl == null) {
            this.report(lhs, "Expected a reference", new Object[0]);
            return Stmt.INVALID;
        }
        if (!lhs.isAssignable()) {
            this.report(lhs, "Expression is not assignable", new Object[0]);
            return Stmt.INVALID;
        }
        Type lhsType = lhs.getType();
        if (!(lhsType.equals(rhsType = rhs.getType()) && Sema.isValid(lhs) || lhsType == Types.NUMERIC && rhsType == Types.SYMBOLIC || lhsType == Types.SYMBOLIC && (rhsType == Types.NUMERIC || rhsType == Types.STRING))) {
            if (lhsType instanceof SetType && rhsType instanceof SetType) {
                if (((SetType)rhsType).getDimension() != 0) {
                    this.report(lhs, "Dimension mismatch", new Object[0]);
                }
            } else {
                if (Sema.isValid(rhs)) {
                    this.report(lhs, "Type mismatch", new Object[0]);
                }
                return Stmt.INVALID;
            }
        }
        if (!Sema.isValid(indexing)) {
            return Stmt.INVALID;
        }
        return new LetStmt(letPos, semiPos, indexing, lhs, rhs);
    }

    @Override
    public Stmt onFixStmt(int letPos, Indexing indexing, Expr lhs, Expr rhs, int semiPos) {
        Type rhsType;
        Referable decl = lhs.getTarget();
        if (decl == null) {
            this.report(lhs, "Expected a reference", new Object[0]);
            return Stmt.INVALID;
        }
        String f = lhs.getClass().getName();
        String g = lhs.getTarget().getClassName();
        if (lhs.getTarget().getClassName() != "VariableMap") {
            this.report(lhs, "Expected a variable", new Object[0]);
            this.report(lhs, String.valueOf(f) + g, new Object[0]);
            return Stmt.INVALID;
        }
        if (rhs != null && (rhsType = rhs.getType()) != Types.NUMERIC) {
            this.report(rhs, "Numeric expression expected", new Object[0]);
        }
        if (!Sema.isValid(indexing)) {
            return Stmt.INVALID;
        }
        return new FixStmt(letPos, semiPos, indexing, lhs, rhs);
    }

    @Override
    public Stmt onIfStmt(int ifPos, Expr condition, Stmt thenStmt, Stmt elseStmt) {
        if (!(this.checkCondition(condition) && Sema.isValid(thenStmt) && Sema.isValidOrNull(elseStmt))) {
            return Stmt.INVALID;
        }
        return new IfStmt(ifPos, condition, thenStmt, elseStmt);
    }

    @Override
    public void onLoopStart(Token name) {
        Identifier id = null;
        if (name != null) {
            assert (name.isKeywordOrIdentifier());
            id = name.getIdentifier();
        }
        this.loops.add(new LoopContext(id));
    }

    @Override
    public void onLoopEnd() {
        this.loops.remove(this.loops.size() - 1);
    }

    @Override
    public Stmt onForStmt(int pos, Indexing indexing, Stmt body) {
        if (!Sema.isValid(indexing) || !Sema.isValid(body)) {
            return Stmt.INVALID;
        }
        return new ForStmt(pos, this.loops.get(this.loops.size() - 1), indexing, body);
    }

    @Override
    public Stmt onRepeatStmt(int repeatPos, Condition pre, Stmt body, Condition post, int semiPos) {
        boolean valid = Sema.isValid(body);
        if (pre != null && !this.checkCondition(pre.expr)) {
            valid = false;
        }
        if (post != null && !this.checkCondition(post.expr)) {
            valid = false;
        }
        if (!valid) {
            return Stmt.INVALID;
        }
        int end = semiPos;
        if (end == -1) {
            end = post != null ? post.expr.getEnd() : body.getEnd();
        }
        return new RepeatStmt(repeatPos, end, this.loops.get(this.loops.size() - 1), pre, post, body);
    }

    @Override
    public Stmt onCompoundStmt(int lbracePos, List<Stmt> stmts, int rbracePos) {
        for (Stmt stmt : stmts) {
            if (Sema.isValid(stmt)) continue;
            return stmt;
        }
        return new CompoundStmt(lbracePos, rbracePos, stmts);
    }

    @Override
    public Stmt onIOStmt(Token keyword, Indexing indexing, List<Expr> args, Action.Redirection r, int semiPos) {
        OutputStmt.Kind kind;
        boolean valid = Sema.isValidOrNull(indexing);
        if (keyword.is(TokenKind.KW_read)) {
            if (args.isEmpty()) {
                this.report(semiPos, "Expected expression", new Object[0]);
                valid = false;
            }
            for (Expr arg : args) {
                if (arg.isAssignable()) continue;
                this.report(arg, "Invalid read argument", new Object[0]);
                valid = false;
            }
            Expr filename = null;
            if (r != null) {
                if (r.op != Action.Redirection.Op.LESS) {
                    this.report(r.opPos, "Expected '<'", new Object[0]);
                    valid = false;
                } else {
                    filename = r.filename;
                }
            }
            return valid ? new ReadStmt(keyword.getStartPosition(), semiPos, indexing, args, filename) : null;
        }
        switch (keyword.getKind()) {
            default: {
                assert (false) : "Invalid IO statement.";
            }
            case KW_display: {
                kind = OutputStmt.Kind.DISPLAY;
                for (Expr arg : args) {
                    valid &= this.checkPrintArg(arg);
                }
                break;
            }
            case KW_expand: {
                kind = OutputStmt.Kind.EXPAND;
                for (Expr arg : args) {
                    if (!Sema.isValid(arg)) {
                        valid = false;
                        continue;
                    }
                    Type type = arg.getOriginalType();
                    arg.setType(type);
                    if (type instanceof MapType) {
                        type = ((MapType)type).getValueType();
                    }
                    if (type == Types.VARIABLE || type == Types.OBJECTIVE || type == Types.CONSTRAINT) continue;
                    this.report(arg, "Expected variable, objective or constraint", new Object[0]);
                    valid = false;
                }
                break;
            }
            case KW_print: {
                kind = OutputStmt.Kind.PRINT;
                for (Expr arg : args) {
                    valid &= this.checkPrintArg(arg);
                }
                break;
            }
            case KW_printf: {
                kind = OutputStmt.Kind.PRINTF;
                if (args.isEmpty()) {
                    this.report(semiPos, "Expected expression", new Object[0]);
                    valid = false;
                    break;
                }
                Expr format = args.get(0);
                if (!Sema.isValid(format)) {
                    valid = false;
                } else if (format.getType() != Types.STRING) {
                    this.report(format, "Expected string expression", new Object[0]);
                    valid = false;
                }
                int i = 1;
                int n = args.size();
                while (i < n) {
                    valid &= this.checkPrintArg(args.get(i));
                    ++i;
                }
                break;
            }
            case KW_xref: {
                kind = OutputStmt.Kind.XREF;
                for (Expr arg : args) {
                    if (!Sema.isValid(arg)) {
                        valid = false;
                        continue;
                    }
                    Referable ref = arg.getTarget();
                    if (ref != null) continue;
                    this.report(arg, "Expected entity reference", new Object[0]);
                    valid = false;
                }
            }
        }
        Expr filename = null;
        boolean append = false;
        if (r != null) {
            boolean bl = append = r.op == Action.Redirection.Op.GREATER_GREATER;
            if (!append && r.op != Action.Redirection.Op.GREATER) {
                this.report(r.opPos, "Expected '>' or '>>'", new Object[0]);
                valid = false;
            } else {
                filename = r.filename;
            }
        }
        return valid ? new OutputStmt(keyword.getStartPosition(), semiPos, kind, indexing, args, filename, append) : Stmt.INVALID;
    }

    @Override
    public Stmt onProblemStmt(int problemPos, Expr ref, int semiPos) {
        Referable decl;
        if (ref != null && !((decl = ref.getTarget()) instanceof ProblemDecl)) {
            this.report(ref, "expected problem name", new Object[0]);
            return Stmt.INVALID;
        }
        return new BasicStmt(problemPos, semiPos, BasicStmt.Kind.PROBLEM, ref, null);
    }

    @Override
    public Stmt onTableIOStmt(Token keyword, int tablePos, Expr ref, int semiPos) {
        if (!Sema.isValid(ref)) {
            return Stmt.INVALID;
        }
        return new TableIOStmt(keyword.getStartPosition(), semiPos, keyword.is(TokenKind.KW_write), ref);
    }

    @Override
    public void onSetDataStart(int setPos, Token name, Action.Subscript sub) throws SAMPLException {
        assert (name.isKeywordOrIdentifier());
        this.validData = false;
        this.handleKeys = true;
        Identifier id = name.getIdentifier();
        Referable decl = id.getDecl();
        if (!(decl instanceof SetDecl)) {
            this.report(name.getStartPosition(), "'%s' is not a set", id);
            return;
        }
        SetDecl setDecl = (SetDecl)decl;
        this.initKeys(setDecl.getDimension());
        Object key = null;
        if (sub != null) {
            int numSubs;
            Indexing indexing = setDecl.getIndexing();
            if (indexing == null) {
                this.report(sub.lbracketPos, "'%s' can't have subscripts", id);
                return;
            }
            int dimension = indexing.getDimension();
            if (dimension != (numSubs = sub.items.size())) {
                if (dimension < numSubs) {
                    this.report(sub.items.get(dimension).getStartPosition(), "Too many subscripts", new Object[0]);
                } else {
                    this.report(sub.rbracketPos, "Too few subscripts", new Object[0]);
                }
                return;
            }
            List<Token> items = sub.items;
            int numItems = items.size();
            if (numItems != 1) {
                Object[] tupleItems = new Object[numItems];
                int i = 0;
                while (i < numItems) {
                    tupleItems[i] = this.getData(items.get(i));
                    ++i;
                }
                key = new Tuple(tupleItems);
            } else {
                key = this.getData(items.get(0));
            }
        } else if (setDecl.getIndexing() != null) {
            this.report(name.getStartPosition(), "'%s' doesn't have subscripts", id);
            return;
        }
        this.consumer.onDataStart(setDecl, key);
        this.validData = true;
    }

    @Override
    public void onDataStart(Token keyword, Token name, Token defaultValue) throws SAMPLException {
        assert (name.isKeywordOrIdentifier());
        this.validData = false;
        this.handleKeys = false;
        Identifier id = name.getIdentifier();
        Referable named = id.getDecl();
        if (!(named instanceof ParameterDecl)) {
            this.report(name.getStartPosition(), "'%s' is not a parameter", id);
            return;
        }
        ParameterDecl decl = (ParameterDecl)named;
        Indexing indexing = decl.getIndexing();
        Type type = decl.getType();
        if (indexing != null) {
            type = ((MapType)type).getValueType();
        }
        this.isDataNumeric.set(0, type == Types.NUMERIC);
        this.defaultValue = null;
        if (defaultValue != null) {
            this.checkDataType(0, defaultValue);
            this.defaultValue = this.getData(defaultValue);
        }
        this.initKeys(indexing != null ? indexing.getDimension() : 0);
        this.paramDecls = new ParameterDecl[]{decl};
        this.consumer.onDataStart(this.paramDecls);
        this.validData = true;
    }

    @Override
    public void onDataStart(Token keyword, Token defaultValue, Token setName, List<Token> paramNames) throws SAMPLException {
        this.validData = true;
        this.handleKeys = false;
        SetDecl setDecl = null;
        int requiredDimension = 0;
        if (setName != null) {
            Identifier id = setName.getIdentifier();
            Referable decl = id.getDecl();
            if (decl instanceof SetDecl) {
                setDecl = (SetDecl)decl;
                this.initKeys(setDecl.getDimension());
                this.consumer.onDataStart(setDecl, null);
                this.handleKeys = true;
                requiredDimension = setDecl.getDimension();
            } else {
                this.report(setName.getStartPosition(), "'%s' is not a set", id);
                this.validData = false;
            }
        }
        int numParams = paramNames.size();
        this.paramDecls = new ParameterDecl[numParams];
        int numericParamIndex = -1;
        int i = 0;
        while (i < numParams) {
            Token name = paramNames.get(i);
            assert (name.isKeywordOrIdentifier());
            Identifier id = name.getIdentifier();
            Referable named = id.getDecl();
            if (!(named instanceof ParameterDecl)) {
                this.report(name.getStartPosition(), "'%s' is not a parameter", id);
                this.validData = false;
            } else {
                ParameterDecl decl = (ParameterDecl)named;
                Indexing indexing = decl.getIndexing();
                if (indexing == null) {
                    this.report(name.getStartPosition(), "'%s' can't have subscripts", id);
                    this.validData = false;
                } else {
                    this.initKeys(indexing.getDimension());
                    Type type = decl.getType();
                    if (indexing != null) {
                        type = ((MapType)type).getValueType();
                    }
                    boolean isNumeric = type == Types.NUMERIC;
                    this.isDataNumeric.set(i, isNumeric);
                    if (isNumeric) {
                        numericParamIndex = i;
                    }
                    this.paramDecls[i] = decl;
                    int dimension = decl.getType().getDimension();
                    if (setDecl != null) {
                        if (dimension != requiredDimension) {
                            this.report(name.getStartPosition(), "'%s' requires %d subscript(s) while '%s' has dimension %d", decl.getName(), dimension, setDecl.getName(), requiredDimension);
                            this.validData = false;
                        }
                    } else if (i != 0) {
                        if (dimension != requiredDimension) {
                            ParameterDecl firstDecl = this.paramDecls[0];
                            this.report(name.getStartPosition(), "'%s' and '%s' require different number of subscripts (%d and %d)", firstDecl.getName(), decl.getName(), requiredDimension, dimension);
                            this.validData = false;
                        }
                    } else {
                        requiredDimension = dimension;
                    }
                }
            }
            ++i;
        }
        this.defaultValue = null;
        if (defaultValue != null) {
            if (numericParamIndex != -1) {
                this.checkDataType(numericParamIndex, defaultValue);
            }
            this.defaultValue = this.getData(defaultValue);
        }
        if (this.validData) {
            this.consumer.onDataStart(this.paramDecls);
        }
    }

    @Override
    public void onObjectList(List<Token> objects) {
        int rowSize;
        int numRowWildcards;
        int startRowWildcard;
        if (!this.validData) {
            return;
        }
        if (this.paramDecls != null && this.paramDecls.length == 1 && this.paramDecls[0].getIndexing() == null) {
            if (objects.size() > 1) {
                this.report(objects.get(1).getStartPosition(), "Too many values for '%s'", this.paramDecls[0].getName());
                this.validData = false;
                return;
            }
            Token token = objects.get(0);
            if (!token.getData().equals(".")) {
                this.checkDataType(0, token);
                if (this.validData) {
                    this.consumer.onData(this.getData(token));
                }
            } else if (this.defaultValue != null && this.validData) {
                this.consumer.onData(this.defaultValue);
            }
            return;
        }
        int dataSize = this.paramDecls != null ? this.paramDecls.length : 0;
        int startColWildcard = this.transpose ? 0 : this.numWildcards - 1;
        int n = startRowWildcard = this.transpose ? 1 : 0;
        if (this.header != null) {
            assert (dataSize <= 1);
            numRowWildcards = Math.max(this.numWildcards - 1, 1);
            rowSize = numRowWildcards + this.header.length;
        } else {
            numRowWildcards = this.numWildcards;
            rowSize = numRowWildcards + dataSize;
        }
        int numObjects = objects.size();
        int numRows = numObjects / rowSize;
        if (numObjects % rowSize != 0) {
            int badRowStart = numRows * rowSize;
            this.report(objects.get(badRowStart).getStartPosition(), "Expected %d more item(s)", numObjects - badRowStart);
            this.validData = false;
            return;
        }
        int keySize = this.template.length;
        int i = 0;
        while (i < numObjects) {
            int j;
            Token token = objects.get(i);
            if (keySize != 1) {
                int j2 = 0;
                while (j2 < numRowWildcards) {
                    this.template[this.wildcards[startRowWildcard + j2]] = this.getData(objects.get(i + j2));
                    ++j2;
                }
            }
            int dataStart = i + numRowWildcards;
            if (this.header == null) {
                if (keySize != 1) {
                    this.key = new Tuple(Arrays.copyOf(this.template, keySize));
                } else if (numRowWildcards != 0) {
                    this.key = this.getData(token);
                }
                if (this.handleKeys) {
                    this.consumer.onKey(this.key);
                }
                j = 0;
                while (j < dataSize) {
                    this.handleData(this.key, objects.get(dataStart + j), j);
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.header.length) {
                    if (keySize != 1) {
                        this.template[this.wildcards[startColWildcard]] = this.header[j];
                        this.key = new Tuple(Arrays.copyOf(this.template, keySize));
                    } else {
                        this.key = this.header[j];
                    }
                    token = objects.get(dataStart + j);
                    if (dataSize != 0) {
                        this.handleData(this.key, token, 0);
                    } else if (token.getData().equals("+")) {
                        if (this.validData) {
                            this.consumer.onKey(this.key);
                        }
                    } else if (!token.getData().equals("-")) {
                        this.validData = false;
                        this.report(token.getStartPosition(), "Expected '+' or '-'", new Object[0]);
                    }
                    ++j;
                }
            }
            i += rowSize;
        }
    }

    @Override
    public void onTableHeader(int trPos, int colonPos, List<Token> objects) {
        this.transpose = trPos != 0;
        int numObjects = objects.size();
        this.header = new Object[numObjects];
        int i = 0;
        while (i < numObjects) {
            this.header[i] = this.getData(objects.get(i));
            ++i;
        }
    }

    @Override
    public void onRowList(int colonEqualPos, List<Token> objects) {
        this.onObjectList(objects);
    }

    @Override
    public void onSetTemplate(int lparenPos, List<Token> items, int rparenPos) {
        if (!this.checkTemplate(items, rparenPos)) {
            return;
        }
        if (items.size() == 1) {
            this.consumer.onKey(this.getData(items.get(0)));
            return;
        }
        this.setTemplate(items);
        if (this.key != null) {
            this.consumer.onKey(this.key);
        }
    }

    @Override
    public void onParamTemplate(int lbracketPos, List<Token> items, int rbracketPos) {
        if (this.paramDecls[0].getIndexing() == null) {
            this.report(lbracketPos, "'%s' can't have subscripts", this.paramDecls[0].getName());
            this.validData = false;
            return;
        }
        if (this.checkTemplate(items, rbracketPos)) {
            this.setTemplate(items);
        }
    }

    @Override
    public void onDataEnd(int semiPos) {
        if (this.validData && this.defaultValue != null && this.paramDecls != null) {
            this.consumer.onDefaultData(this.defaultValue);
        }
        this.paramDecls = null;
        this.defaultValue = null;
        this.template = null;
        this.header = null;
        this.key = null;
    }
}

