/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import java.util.ArrayList;
import java.util.List;
import sampl.ast.Decl;
import sampl.ast.Indexing;
import sampl.ast.ProblemDecl;
import sampl.ast.Referable;
import sampl.parser.Identifier;
import sampl.parser.Token;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Type;
import sampl.types.Types;

final class ProblemDeclSema
extends DeclSema {
    private ProblemDecl decl;

    ProblemDeclSema(Sema sema, int pos, String name) {
        super(sema);
        this.decl = new ProblemDecl(pos, name);
    }

    @Override
    ProblemDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        this.decl.setIndexing(indexing);
        this.decl.setType(MapType.get(indexing.getDimension(), Types.PROBLEM));
    }

    @Override
    public void onProblemItems(int colonPos, List<Token> names) {
        ArrayList<Decl> items = new ArrayList<Decl>(names.size());
        for (Token name : names) {
            Identifier id = name.getIdentifier();
            Referable named = id.getDecl();
            if (named == null) {
                this.report(name, "'%s' is not declared", id);
                return;
            }
            if (!(named instanceof Decl)) {
                this.report(name, "Expected variable, objective or constraint", new Object[0]);
                return;
            }
            Decl decl = (Decl)named;
            Type type = decl.getType();
            if (type instanceof MapType) {
                type = ((MapType)type).getValueType();
            }
            if (type != Types.VARIABLE && type != Types.OBJECTIVE && type != Types.CONSTRAINT) {
                this.report(name, "Expected variable, objective or constraint", new Object[0]);
                return;
            }
            items.add(decl);
        }
        this.decl.setItems(items);
    }
}

