/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import java.util.List;
import sampl.ast.ColGroup;
import sampl.ast.Decl;
import sampl.ast.Direction;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.Referable;
import sampl.ast.SetDecl;
import sampl.ast.Suffix;
import sampl.ast.SuffixAttr;
import sampl.parser.DeclAction;
import sampl.parser.Identifier;
import sampl.parser.Token;
import sampl.parser.TokenKind;
import sampl.sema.Sema;
import sampl.types.SetType;
import sampl.types.Type;
import sampl.types.Types;

abstract class DeclSema
implements DeclAction {
    Sema sema;
    boolean hasErrors;

    final void report(Token token, String message, Object ... args) {
        this.hasErrors = true;
        this.sema.report(token.getStartPosition(), message, args);
    }

    final void reportInvalidAttr(int pos, TokenKind kind) {
        this.hasErrors = true;
        this.sema.report(pos, "The attribute '%s' is invalid in this declaration", new Object[]{kind});
    }

    final void reportInvalidAttr(Token op) {
        this.reportInvalidAttr(op.getStartPosition(), op.getKind());
    }

    final boolean expectSingleDimenSet(Expr e) {
        Type type = e.getType();
        if (!(type instanceof SetType)) {
            this.sema.report(e, "Type mismatch", new Object[0]);
            return false;
        }
        if (type.getDimension() != 1) {
            this.sema.report(e, "Dimension mismatch", new Object[0]);
            return false;
        }
        return true;
    }

    final void checkScenarioIndex(Indexing indexing, boolean probability) {
        int scenarioPartIndex = -1;
        List<Expr> parts = indexing.getParts();
        int i = 0;
        while (i < parts.size()) {
            Expr part = parts.get(i);
            Referable decl = Sema.getIndexSetExpr(part).getTarget();
            if (decl != null && ((SetDecl)decl).isScenarioSet()) {
                scenarioPartIndex = i;
            } else if (probability) {
                this.sema.report(part, "Probability parameter can only be indexed over scenario set", new Object[0]);
            }
            ++i;
        }
        if (scenarioPartIndex != -1) {
            int scenarioSubIndex = 0;
            int i2 = 0;
            while (i2 < scenarioPartIndex) {
                scenarioSubIndex += parts.get(i2).getDimension();
                ++i2;
            }
            indexing.setScenarioIndices(scenarioPartIndex, scenarioSubIndex);
        }
    }

    final SuffixAttr handleSuffixAttr(int suffixKWPos, Token name, Expr expr) {
        if (expr.getType() == Types.UNKNOWN) {
            return null;
        }
        Identifier id = name.getIdentifier();
        Suffix suffix = this.sema.findSuffix(id.toString());
        if (suffix == null) {
            this.report(name, "Unknown suffix '%s'", id);
            return null;
        }
        if (!suffix.isAssignable()) {
            this.report(name, "Suffix '%s' is not assignable", id);
            return null;
        }
        if (!this.sema.expectConstArithmeticExpr(expr)) {
            return null;
        }
        return new SuffixAttr(suffixKWPos, id, suffix, expr);
    }

    DeclSema(Sema s) {
        this.sema = s;
    }

    boolean hasErrors() {
        return this.hasErrors;
    }

    boolean needsScenarioConversion() {
        return false;
    }

    abstract Decl getDecl();

    Type fixType() {
        return null;
    }

    @Override
    public void onBasicAttr(Token keyword) {
        this.reportInvalidAttr(keyword);
    }

    @Override
    public void onUnaryAttr(Token op, Expr arg) {
        this.reportInvalidAttr(op);
    }

    @Override
    public void onSuffixAttr(int suffixKWPos, Token suffix, Expr expr) {
        this.reportInvalidAttr(suffixKWPos, TokenKind.KW_suffix);
    }

    @Override
    public void onArcAttr(Token keyword, Expr ref, Expr expr) {
        this.reportInvalidAttr(keyword);
    }

    @Override
    public void onCoeffAttr(Token keyword, Indexing indexing, Expr ref, Expr coeff) {
        this.reportInvalidAttr(keyword);
    }

    @Override
    public void onDistAttr(int distPos, Token name, List<Expr> args, int rparenPos) {
        this.reportInvalidAttr(distPos, TokenKind.KW_dist);
    }

    @Override
    public void onEndAttrs() {
    }

    @Override
    public void onDeclExpr(int colonPos, Expr expr) {
    }

    @Override
    public void onTableBody(Token inout, List<Expr> strings, Expr keySet, Direction d, int lbracketPos, List<Expr> keyCols, int rbracketPos, Token keyInout, Expr inExpr, List<ColGroup> dataCols) {
    }

    @Override
    public void onProblemItems(int colonPos, List<Token> names) {
        assert (false);
    }
}

