/*
 * Decompiled with CFR 0.152.
 */
package sampl.parser;

import java.io.IOException;
import java.io.Reader;
import sampl.DiagnosticException;
import sampl.SAMPLException;
import sampl.Source;
import sampl.parser.Identifier;
import sampl.parser.IdentifierTable;
import sampl.parser.Token;
import sampl.parser.TokenHandler;
import sampl.parser.TokenKind;

final class Lexer {
    private IdentifierTable identifiers;
    private TokenHandler handler;
    private Source source;
    private Reader reader;
    private static int READ_BLOCK_SIZE = 2048;
    private char[] buffer = new char[READ_BLOCK_SIZE + 5];
    private int numCharsInBuffer;
    private int tokenStartInBuffer;
    private int position;
    private int bufferStart;
    private StringBuilder builder;
    private int lineStart;
    private TokenKind tokenKind;
    private int tokenPos;
    private Object tokenData = null;
    private static final byte[] CHAR_TYPES;

    static {
        byte[] byArray = new byte[128];
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[65] = 2;
        byArray[66] = 2;
        byArray[67] = 2;
        byArray[68] = 2;
        byArray[69] = 2;
        byArray[70] = 2;
        byArray[71] = 2;
        byArray[72] = 2;
        byArray[73] = 2;
        byArray[74] = 2;
        byArray[75] = 2;
        byArray[76] = 2;
        byArray[77] = 2;
        byArray[78] = 2;
        byArray[79] = 2;
        byArray[80] = 2;
        byArray[81] = 2;
        byArray[82] = 2;
        byArray[83] = 2;
        byArray[84] = 2;
        byArray[85] = 2;
        byArray[86] = 2;
        byArray[87] = 2;
        byArray[88] = 2;
        byArray[89] = 2;
        byArray[90] = 2;
        byArray[95] = 2;
        byArray[97] = 2;
        byArray[98] = 2;
        byArray[99] = 2;
        byArray[100] = 2;
        byArray[101] = 2;
        byArray[102] = 2;
        byArray[103] = 2;
        byArray[104] = 2;
        byArray[105] = 2;
        byArray[106] = 2;
        byArray[107] = 2;
        byArray[108] = 2;
        byArray[109] = 2;
        byArray[110] = 2;
        byArray[111] = 2;
        byArray[112] = 2;
        byArray[113] = 2;
        byArray[114] = 2;
        byArray[115] = 2;
        byArray[116] = 2;
        byArray[117] = 2;
        byArray[118] = 2;
        byArray[119] = 2;
        byArray[120] = 2;
        byArray[121] = 2;
        byArray[122] = 2;
        CHAR_TYPES = byArray;
    }

    private char getChar(int offset) throws IOException {
        int index = this.position + offset;
        if (index >= this.numCharsInBuffer) {
            if (this.tokenStartInBuffer >= 0) {
                int i = this.tokenStartInBuffer;
                while (i < this.position) {
                    this.builder.append(this.buffer[i]);
                    ++i;
                }
                this.tokenStartInBuffer = 1;
            }
            int numCopied = 0;
            if (this.position != 0) {
                int start;
                int i = start = this.position - 1;
                while (i < this.numCharsInBuffer) {
                    this.buffer[numCopied++] = this.buffer[i];
                    ++i;
                }
                this.position -= start;
                this.bufferStart += start;
            }
            int numRead = this.reader.read(this.buffer, numCopied, READ_BLOCK_SIZE);
            this.numCharsInBuffer = Math.max(numRead, 0) + numCopied;
            this.buffer[this.numCharsInBuffer] = '\u0000';
            if (numRead == -1) {
                return '\u0000';
            }
        }
        return this.buffer[this.position + offset];
    }

    private char getChar() throws IOException {
        return this.position < this.numCharsInBuffer ? this.buffer[this.position] : this.getChar(0);
    }

    private static boolean isLetterOrUnderscore(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private DiagnosticException error(String message) {
        return new DiagnosticException(message, this.source, this.position + this.bufferStart);
    }

    private boolean isNewlineOrEOF() throws IOException {
        if (this.position >= this.numCharsInBuffer) {
            return this.getChar(0) == '\n' || this.position >= this.numCharsInBuffer;
        }
        return false;
    }

    private void skipWhitespace() throws DiagnosticException, IOException {
        block7: while (true) {
            switch (this.buffer[this.position]) {
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++this.position;
                    continue block7;
                }
                case '\n': {
                    int newLineStart = this.position + this.bufferStart + 1;
                    this.source.endLine(newLineStart - this.lineStart);
                    this.lineStart = newLineStart;
                    ++this.position;
                    continue block7;
                }
                case '#': {
                    char c;
                    this.tokenPos = this.position + this.bufferStart;
                    while (!((c = this.buffer[++this.position]) == '\n' || c == '\u0000' && this.isNewlineOrEOF())) {
                    }
                    if (this.handler == null) continue block7;
                    this.tokenKind = TokenKind.COMMENT;
                    this.handleToken();
                    continue block7;
                }
                case '/': {
                    char c;
                    this.tokenPos = this.position + this.bufferStart;
                    if (this.getChar(1) != '*') {
                        return;
                    }
                    this.position += 2;
                    if (this.getChar() == '/') {
                        ++this.position;
                    }
                    while (true) {
                        if ((c = this.getChar()) == '/' && this.buffer[this.position - 1] == '*') {
                            ++this.position;
                            break;
                        }
                        if (c == '\u0000' && this.position >= this.numCharsInBuffer) {
                            if (this.handler != null) {
                                this.tokenKind = TokenKind.COMMENT;
                                this.handleToken();
                            }
                            throw this.error("Unterminated /* comment");
                        }
                        if (c == '\n') {
                            this.source.endLine(this.position + this.bufferStart - this.lineStart + 1);
                            this.lineStart = this.position + this.bufferStart + 1;
                        }
                        ++this.position;
                    }
                    if (this.handler == null) continue block7;
                    this.tokenKind = TokenKind.COMMENT;
                    this.handleToken();
                    continue block7;
                }
                case '\u0000': {
                    if (this.position < this.numCharsInBuffer) break block7;
                    this.getChar(0);
                    if (this.position >= this.numCharsInBuffer) break block7;
                    continue block7;
                }
            }
            break;
        }
    }

    private boolean isLetterOrDigitSlow() throws IOException {
        if (this.position < this.numCharsInBuffer) {
            return false;
        }
        char c = this.getChar(0);
        return (c & 0xFFFFFF80) == 0 && CHAR_TYPES[c & 0x7F] != 0;
    }

    private void lexIdentifier() throws IOException {
        char c = this.buffer[this.position];
        while ((c & 0xFFFFFF80) == 0 && CHAR_TYPES[c & 0x7F] != 0 || c == '\u0000' && this.isLetterOrDigitSlow()) {
            c = this.buffer[++this.position];
        }
    }

    private boolean lexExponent() throws IOException {
        char c = this.buffer[this.position];
        if (c == '\u0000') {
            c = this.getChar(0);
        }
        if (c != 'e' && c != 'E' && c != 'd' && c != 'D') {
            return false;
        }
        c = this.getChar(1);
        if (c == '+' || c == '-') {
            if (Lexer.isDigit(this.getChar(2))) {
                this.position += 2;
                do {
                    ++this.position;
                } while (Lexer.isDigit(this.getChar()));
                return true;
            }
            return false;
        }
        if (Lexer.isDigit(c)) {
            ++this.position;
            do {
                ++this.position;
            } while (Lexer.isDigit(this.getChar()));
        }
        return false;
    }

    private boolean isDigitSlow() throws IOException {
        return this.position >= this.numCharsInBuffer ? Lexer.isDigit(this.getChar(0)) : false;
    }

    private TokenKind lexNumber() throws IOException {
        boolean hasSign;
        TokenKind tokenKind = TokenKind.NUMBER;
        char c = this.buffer[this.position];
        while (Lexer.isDigit(c) || c == '\u0000' && this.isDigitSlow()) {
            c = this.buffer[++this.position];
        }
        boolean hasPoint = false;
        if (c == '.' || c == '\u0000' && this.getChar() == '.') {
            c = this.buffer[this.position + 1];
            if (c == '.' || c == '\u0000' && this.getChar(1) == '.') {
                return tokenKind;
            }
            hasPoint = true;
            while (Lexer.isDigit(c = this.buffer[++this.position]) || c == '\u0000' && this.isDigitSlow()) {
            }
        }
        if (!(hasSign = this.lexExponent()) && !hasPoint && Lexer.isLetterOrUnderscore(this.getChar())) {
            tokenKind = TokenKind.IDENTIFIER;
            this.lexIdentifier();
        }
        return tokenKind;
    }

    private void lexString() throws DiagnosticException, IOException {
        char quote = this.buffer[this.position - 1];
        this.tokenStartInBuffer = -1;
        while (true) {
            char c;
            if ((c = this.getChar()) == quote) {
                ++this.position;
                if (this.getChar() != quote) {
                    break;
                }
            } else {
                if (c == '\\') {
                    int length = this.builder.length();
                    this.builder.append(c);
                    ++this.position;
                    c = this.getChar();
                    if (c == '\r') {
                        this.builder.append(c);
                        ++this.position;
                    }
                    if ((c = this.getChar()) != '\n') continue;
                    this.builder.setLength(length);
                    this.builder.append(c);
                    ++this.position;
                    this.source.endLine(this.position + this.bufferStart - this.lineStart);
                    this.lineStart = this.position + this.bufferStart;
                    continue;
                }
                if (c == '\n' || c == '\u0000' && this.position >= this.numCharsInBuffer) {
                    if (this.handler != null) {
                        this.handleToken();
                    }
                    throw this.error(String.format("Missing terminating %1$c character", Character.valueOf(quote)));
                }
            }
            this.builder.append(c);
            ++this.position;
        }
    }

    private boolean isSpecialChar(Mode mode) throws IOException {
        char c = this.getChar();
        return Lexer.isDigit(c) || Lexer.isLetterOrUnderscore(c) || c == '+' || c == '-' || mode != Mode.OPTION && c == '.';
    }

    private boolean isFilenameChar() throws IOException {
        char c = this.getChar();
        switch (c) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '#': 
            case '\'': 
            case ';': {
                return false;
            }
            case '/': {
                return this.getChar(1) != '*';
            }
        }
        return true;
    }

    private boolean lexUnquotedString(Mode mode) throws IOException {
        if (!this.isSpecialChar(mode)) {
            return false;
        }
        do {
            ++this.position;
        } while (this.isSpecialChar(mode));
        return true;
    }

    private void handleToken() {
        this.handler.token(this.tokenKind, this.tokenPos, this.getTokenLength());
    }

    Lexer(IdentifierTable identifiers) {
        this.identifiers = identifiers;
    }

    Source getSource() {
        return this.source;
    }

    void setSource(Source source) throws SAMPLException {
        this.source = source;
        this.reader = source.getReader();
        try {
            this.numCharsInBuffer = this.reader.read(this.buffer, 0, READ_BLOCK_SIZE);
            if (this.numCharsInBuffer < 0) {
                this.numCharsInBuffer = 0;
            }
            this.buffer[this.numCharsInBuffer] = '\u0000';
        }
        catch (IOException e) {
            throw new SAMPLException(e);
        }
        this.builder = new StringBuilder();
    }

    int getTokenPosition() {
        return this.tokenPos;
    }

    int getTokenLength() {
        return this.position + this.bufferStart - this.tokenPos;
    }

    Object getTokenData() {
        return this.tokenData;
    }

    Identifier getIdentifier() {
        return (Identifier)this.tokenData;
    }

    Token createToken() {
        return new Token(this.tokenKind, this.tokenPos, this.tokenData);
    }

    void setTokenHandler(TokenHandler th) {
        this.handler = th;
    }

    TokenKind lex(Mode mode) throws SAMPLException {
        try {
            boolean foundTr = false;
            this.tokenStartInBuffer = -1;
            this.skipWhitespace();
            this.tokenKind = TokenKind.UNKNOWN;
            this.builder.setLength(0);
            char c = this.buffer[this.position];
            this.tokenPos = this.position + this.bufferStart;
            this.tokenStartInBuffer = this.position++;
            switch (c) {
                case 's': {
                    if (this.getChar() == '.') {
                        if (this.getChar(1) == 't' && this.getChar(2) == '.') {
                            this.tokenKind = TokenKind.S_DOT_T_DOT;
                            this.position += 3;
                            break;
                        }
                        this.tokenKind = TokenKind.IDENTIFIER;
                        break;
                    }
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.tokenKind = TokenKind.IDENTIFIER;
                    this.lexIdentifier();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tokenKind = this.lexNumber();
                    break;
                }
                case '.': {
                    char next = this.getChar();
                    if (next == '.') {
                        this.tokenKind = TokenKind.DOT_DOT;
                        ++this.position;
                        break;
                    }
                    if (Lexer.isDigit(next)) {
                        do {
                            ++this.position;
                        } while (Lexer.isDigit(this.getChar()));
                        this.lexExponent();
                        this.tokenKind = TokenKind.NUMBER;
                        break;
                    }
                    this.tokenKind = TokenKind.DOT;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.tokenKind = TokenKind.STRING;
                    this.lexString();
                    break;
                }
                case '+': {
                    this.tokenKind = TokenKind.PLUS;
                    break;
                }
                case '-': {
                    this.tokenKind = TokenKind.MINUS;
                    break;
                }
                case '*': {
                    if (this.getChar() == '*') {
                        this.tokenKind = TokenKind.STAR_STAR;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.STAR;
                    break;
                }
                case '/': {
                    this.tokenKind = TokenKind.SLASH;
                    break;
                }
                case '^': {
                    this.tokenKind = TokenKind.CARET;
                    break;
                }
                case '~': {
                    this.tokenKind = TokenKind.TILDE;
                    break;
                }
                case '!': {
                    if (this.getChar() == '=') {
                        this.tokenKind = TokenKind.EXCL_EQUAL;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.EXCL;
                    break;
                }
                case '&': {
                    if (this.getChar() == '&') {
                        this.tokenKind = TokenKind.AMP_AMP;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.AMP;
                    break;
                }
                case '|': {
                    if (this.getChar() == '|') {
                        this.tokenKind = TokenKind.PIPE_PIPE;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.PIPE;
                    break;
                }
                case '=': {
                    if (this.getChar() == '=') {
                        this.tokenKind = TokenKind.EQUAL_EQUAL;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.EQUAL;
                    break;
                }
                case ':': {
                    if (this.getChar() == '=') {
                        this.tokenKind = TokenKind.COLON_EQUAL;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.COLON;
                    break;
                }
                case '<': {
                    if (this.getChar() == '=') {
                        this.tokenKind = TokenKind.LESS_EQUAL;
                        ++this.position;
                        break;
                    }
                    if (this.getChar() == '<') {
                        this.tokenKind = TokenKind.LESS_LESS;
                        ++this.position;
                        break;
                    }
                    if (this.getChar() == '>') {
                        this.tokenKind = TokenKind.LESS_GREATER;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.LESS;
                    break;
                }
                case '>': {
                    if (this.getChar() == '=') {
                        this.tokenKind = TokenKind.GREATER_EQUAL;
                        ++this.position;
                        break;
                    }
                    if (this.getChar() == '>') {
                        this.tokenKind = TokenKind.GREATER_GREATER;
                        ++this.position;
                        break;
                    }
                    this.tokenKind = TokenKind.GREATER;
                    break;
                }
                case '[': {
                    this.tokenKind = TokenKind.LBRACKET;
                    break;
                }
                case ']': {
                    this.tokenKind = TokenKind.RBRACKET;
                    break;
                }
                case '(': {
                    if (mode == Mode.DATA && this.getChar() == 't' && this.getChar(1) == 'r' && this.getChar(2) == ')') {
                        this.tokenKind = TokenKind.IDENTIFIER;
                        this.position += 3;
                        foundTr = true;
                        break;
                    }
                    this.tokenKind = TokenKind.LPAREN;
                    break;
                }
                case ')': {
                    this.tokenKind = TokenKind.RPAREN;
                    break;
                }
                case '{': {
                    this.tokenKind = TokenKind.LBRACE;
                    break;
                }
                case '}': {
                    this.tokenKind = TokenKind.RBRACE;
                    break;
                }
                case ',': {
                    this.tokenKind = TokenKind.COMMA;
                    break;
                }
                case ';': {
                    this.tokenKind = TokenKind.SEMI;
                    break;
                }
                case '\u0000': {
                    if (this.position < this.numCharsInBuffer) break;
                    this.tokenKind = TokenKind.EOF;
                }
            }
            if (mode != Mode.DEFAULT) {
                if (mode == Mode.FILENAME) {
                    switch (this.tokenKind) {
                        case STRING: 
                        case LPAREN: 
                        case SEMI: {
                            break;
                        }
                        default: {
                            while (this.isFilenameChar()) {
                                ++this.position;
                            }
                            this.tokenKind = TokenKind.STRING;
                            break;
                        }
                    }
                } else if (!foundTr) {
                    boolean isUnquotedString = false;
                    switch (this.tokenKind) {
                        case PLUS: 
                        case MINUS: {
                            c = this.getChar();
                            if (Lexer.isDigit(c)) {
                                ++this.position;
                                this.tokenKind = this.lexNumber();
                            } else if (c == '.') {
                                ++this.position;
                                if (Lexer.isDigit(this.getChar())) {
                                    do {
                                        ++this.position;
                                    } while (Lexer.isDigit(this.getChar()));
                                    this.lexExponent();
                                    this.tokenKind = TokenKind.NUMBER;
                                }
                            }
                            if (this.tokenKind != TokenKind.NUMBER) {
                                isUnquotedString = true;
                                break;
                            }
                        }
                        case NUMBER: {
                            if (!this.lexUnquotedString(mode)) break;
                            this.tokenKind = TokenKind.STRING;
                            break;
                        }
                        case IDENTIFIER: {
                            isUnquotedString = true;
                            break;
                        }
                        case LBRACE: 
                        case RBRACE: 
                        case DOT: 
                        case DOT_DOT: {
                            boolean bl = isUnquotedString = mode != Mode.OPTION;
                        }
                    }
                    if (isUnquotedString) {
                        this.lexUnquotedString(mode);
                        this.tokenKind = TokenKind.STRING;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SAMPLException(e);
        }
        if (this.tokenKind == TokenKind.NUMBER || this.tokenKind == TokenKind.STRING || this.tokenKind == TokenKind.IDENTIFIER) {
            String text;
            if (this.tokenStartInBuffer < 0) {
                text = this.builder.toString();
            } else if (this.builder.length() == 0) {
                text = String.valueOf(this.buffer, this.tokenStartInBuffer, this.position - this.tokenStartInBuffer);
            } else {
                this.builder.append(this.buffer, this.tokenStartInBuffer, this.position - this.tokenStartInBuffer);
                text = this.builder.toString();
            }
            if (this.tokenKind == TokenKind.IDENTIFIER) {
                Identifier info = this.identifiers.get(text);
                this.tokenKind = info.getKind();
                this.tokenData = info;
            } else {
                this.tokenData = text;
            }
        }
        if (this.handler != null) {
            this.handleToken();
        }
        return this.tokenKind;
    }

    static enum Mode {
        DEFAULT,
        DATA,
        OPTION,
        FILENAME;

    }
}

