/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang.asl;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sampl.SAMPLException;
import sampl.lang.Parameter;
import sampl.lang.SAMPL;
import sampl.lang.Table;
import sampl.lang.TableMap;
import sampl.lang.asl.TMInfo;
import sampl.lang.asl.TableInfo;

public final class AMPLExports
extends Structure {
    public Pointer stderr;
    public AddFunc addfunc = new AddFunc(){

        @Override
        public void invoke(String name, Pointer f, int type, int nargs, Pointer funcinfo, Pointer ae) {
        }
    };
    public NativeLong asldate;
    public Pointer fprintf;
    public Pointer printf;
    public Pointer sprintf;
    public Pointer vfprintf;
    public Pointer vsprintf;
    public Pointer strtod;
    public Crypto crypto = new Crypto(){

        @Override
        public Pointer invoke(String key, NativeLong scrbytes) {
            return null;
        }
    };
    public Pointer asl;
    public AtExit atexit = this.atreset = new AtExit(){

        @Override
        public void invoke(Pointer ae, Pointer exitFunc, Pointer p) {
        }
    };
    public AtExit atreset;
    public Tempmem tempmem;
    public AddTableHandler addTableHandler;
    public Pointer private_;
    public Pointer qsortv;
    public Pointer stdin;
    public Pointer stdout;
    public Pointer clearerr;
    public Pointer fclose;
    public Pointer fdopen;
    public Pointer feof;
    public Pointer ferror;
    public Pointer fflush;
    public Pointer fgetc;
    public Pointer fgets;
    public Pointer fileno;
    public Pointer fopen;
    public Pointer fputc;
    public Pointer fputs;
    public Pointer fread;
    public Pointer freopen;
    public Pointer fscanf;
    public Pointer fseek;
    public Pointer ftell;
    public Pointer fwrite;
    public Pointer pclose;
    public Pointer perror;
    public Pointer popen;
    public Pointer puts;
    public Pointer rewind;
    public Pointer scanf;
    public Pointer setbuf;
    public Pointer setvbuf;
    public Pointer sscanf;
    public Pointer tempnam;
    public Pointer tmpfile;
    public Pointer tmpnam;
    public Pointer ungetc;
    public Pointer ai;
    public Pointer getenv;
    public BreakFunc breakfunc = new BreakFunc(){

        @Override
        public void invoke(int n, Pointer p) {
        }
    };
    public Pointer breakarg;
    public Pointer snprintf;
    public Pointer vsnprintf;
    public AddRand addrand;
    static final List<TableHandler> HANDLERS = new ArrayList<TableHandler>();
    static PluginLibrary fullbitLib;
    static PluginLibrary ampltablLib;

    private static String getOSPrefix() {
        String arch = System.getProperty("os.arch").toLowerCase();
        switch (Platform.getOSType()) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                return "win32-" + arch;
            }
            case 0: {
                return "darwin";
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                return "linux-" + arch;
            }
            case 3: {
                return "sunos-" + arch;
            }
        }
        String name = System.getProperty("os.name").toLowerCase();
        if ("x86".equals(arch)) {
            arch = "i386";
        } else if ("x86_64".equals(arch)) {
            arch = "amd64";
        } else if ("powerpc".equals(arch)) {
            arch = "ppc";
        }
        int space = name.indexOf(32);
        if (space != -1) {
            name = name.substring(0, space);
        }
        return String.valueOf(name) + "-" + arch;
    }

    private PluginLibrary loadLibrary(final SAMPL env, File file) {
        final String libName = file.getAbsolutePath();
        PluginLibrary lib = (PluginLibrary)Native.loadLibrary((String)libName, PluginLibrary.class);
        this.addTableHandler = new AddTableHandler(){

            @Override
            public void invoke(DBReadWrite dbRead, DBReadWrite dbWrite, String handlerInfo, int flags, Pointer vinfo) {
                Object set;
                int lineEnd = handlerInfo.indexOf(10);
                String name = handlerInfo.substring(0, lineEnd);
                try {
                    set = env._HANDLERS.get(null);
                }
                catch (SAMPLException e) {
                    return;
                }
                if (!set.add(name)) {
                    return;
                }
                String description = handlerInfo.substring(lineEnd + 1);
                env._handler_desc.insert(name, description);
                env._handler_lib.insert(name, libName);
                HANDLERS.add(new TableHandler(dbRead, dbWrite, vinfo));
            }
        };
        lib.funcadd_ASL(this);
        return lib;
    }

    public AMPLExports(SAMPL env) {
        this.tempmem = new Tempmem(){

            @Override
            public Pointer invoke(TMInfo tmi, NativeLong size) {
                return tmi.invoke(size.longValue());
            }
        };
        this.addrand = new AddRand(){

            @Override
            public void invoke(String name, Pointer f, Pointer icdf, int type, int nargs, Pointer funcinfo, Pointer ae) {
            }
        };
        String relPath = new File(AMPLExports.getOSPrefix(), "fullbit.dll").getPath();
        File libFile = new File(SAMPL.SAMPL_DIR, relPath);
        env._default_handler_path.insert(null, libFile.toString());
        if (!libFile.exists()) {
            libFile = new File("lib", relPath);
        }
        fullbitLib = this.loadLibrary(env, libFile);
        File amplTablFile = new File(libFile.getParent(), "ampltabl.dll");
        if (amplTablFile.exists()) {
            ampltablLib = this.loadLibrary(env, amplTablFile);
        }
    }

    public void invokeTableHandlers(Table t, boolean read) throws SAMPLException {
        TableInfo ti = new TableInfo(t, ((TableMap)t.map()).getColumns(read), read);
        if (read) {
            Parameter[] parameterArray = t.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                p.prepareForData();
                ++n2;
            }
        }
        for (TableHandler th : HANDLERS) {
            DBReadWrite function;
            ti.vinfo = th.vinfo;
            DBReadWrite dBReadWrite = function = read ? th.read : th.write;
            if (function == null) continue;
            int result = function.invoke(this, ti);
            if (result == 2) {
                throw new SAMPLException(ti.errmsg);
            }
            if (result == 1) continue;
            return;
        }
        throw new SAMPLException("No suitable table handler found");
    }

    private static interface AddFunc
    extends Callback {
        public void invoke(String var1, Pointer var2, int var3, int var4, Pointer var5, Pointer var6);
    }

    private static interface AddRand
    extends Callback {
        public void invoke(String var1, Pointer var2, Pointer var3, int var4, int var5, Pointer var6, Pointer var7);
    }

    private static interface AddTableHandler
    extends Callback {
        public void invoke(DBReadWrite var1, DBReadWrite var2, String var3, int var4, Pointer var5);
    }

    private static interface AtExit
    extends Callback {
        public void invoke(Pointer var1, Pointer var2, Pointer var3);
    }

    private static interface BreakFunc
    extends Callback {
        public void invoke(int var1, Pointer var2);
    }

    private static interface Crypto
    extends Callback {
        public Pointer invoke(String var1, NativeLong var2);
    }

    static interface DBReadWrite
    extends Callback {
        public static final int DONE = 0;
        public static final int REFUSE = 1;
        public static final int ERROR = 2;

        public int invoke(AMPLExports var1, TableInfo var2);
    }

    private static interface PluginLibrary
    extends Library {
        public void funcadd_ASL(AMPLExports var1);
    }

    private static final class TableHandler {
        DBReadWrite read;
        DBReadWrite write;
        Pointer vinfo;

        TableHandler(DBReadWrite read, DBReadWrite write, Pointer vinfo) {
            this.read = read;
            this.write = write;
            this.vinfo = vinfo;
        }
    }

    private static interface Tempmem
    extends Callback {
        public Pointer invoke(TMInfo var1, NativeLong var2);
    }
}

