/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.util.Arrays;
import sampl.lang.AbstractExpr;
import sampl.lang.Expr;
import sampl.lang.ExprVisitor;
import sampl.lang.NLConnection;

public final class WeightedSum
extends AbstractExpr {
    private int size;
    private double[] weights;
    private Expr[] exprs;

    private void writeTerm(int index, NLConnection writer) throws IOException {
        double coef = this.weights[index];
        if (coef != 1.0) {
            if (coef == -1.0) {
                writer.writeOp(16);
            } else {
                writer.writeOp(2);
                writer.writeConstant(coef);
            }
        }
        this.exprs[index].write(writer);
    }

    private WeightedSum(int size, double[] weights, Expr[] exprs) {
        assert (size <= weights.length && size <= exprs.length);
        this.size = size;
        this.weights = weights;
        this.exprs = exprs;
    }

    public static WeightedSum newNegation(Expr e) {
        return new WeightedSum(1, new double[]{-1.0}, new Expr[]{e});
    }

    public static WeightedSum newSubtraction(Expr a, Expr b) {
        return new WeightedSum(2, new double[]{1.0, -1.0}, new Expr[]{a, b});
    }

    public static WeightedSum newAddition(Expr a, Expr b) {
        return new WeightedSum(2, new double[]{1.0, 1.0}, new Expr[]{a, b});
    }

    public int size() {
        return this.size;
    }

    public double getWeight(int index) {
        return this.weights[index];
    }

    public Expr getExpr(int index) {
        return this.exprs[index];
    }

    @Override
    public boolean hasVariables() {
        int i = 0;
        while (i < this.size) {
            if (this.exprs[i].hasVariables()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public double eval() {
        double value = 0.0;
        int i = 0;
        while (i < this.size) {
            value += this.weights[i] * this.exprs[i].eval();
            ++i;
        }
        return value;
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) throws IOException {
        if (this.size > 2) {
            c.writeOp(54);
            c.writeInt(this.size);
        } else if (this.size == 2) {
            c.writeOp(0);
        }
        int i = 0;
        while (i < this.size) {
            this.writeTerm(i, c);
            ++i;
        }
    }

    /* synthetic */ WeightedSum(int n, double[] dArray, Expr[] exprArray, WeightedSum weightedSum) {
        this(n, dArray, exprArray);
    }

    static final class Builder {
        private int size;
        private double[] weights;
        private Expr[] exprs;

        Builder() {
            int capacity = 8;
            this.weights = new double[capacity];
            this.exprs = new Expr[capacity];
        }

        int size() {
            return this.size;
        }

        double getWeight(int index) {
            return this.weights[index];
        }

        Expr getExpr(int index) {
            return this.exprs[index];
        }

        void addTerm(double weight, Expr expr) {
            if (this.size == this.weights.length) {
                int newLength = this.weights.length * 2;
                this.weights = Arrays.copyOf(this.weights, newLength);
                this.exprs = Arrays.copyOf(this.exprs, newLength);
            }
            this.weights[this.size] = weight;
            this.exprs[this.size] = expr;
            ++this.size;
        }

        WeightedSum toSum() {
            WeightedSum result = new WeightedSum(this.size, this.weights, this.exprs, null);
            this.size = 0;
            this.weights = null;
            this.exprs = null;
            return result;
        }
    }
}

