/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import sampl.Diagnostic;
import sampl.DiagnosticHandler;
import sampl.License;
import sampl.LicenseException;
import sampl.SAMPLException;
import sampl.Source;
import sampl.codegen.ASTCompiler;
import sampl.codegen.Interpreter;
import sampl.lang.NLReader;
import sampl.lang.Problem;
import sampl.lang.ProblemMap;
import sampl.lang.PromptingReader;
import sampl.lang.SAMPL;
import sampl.parser.Action;
import sampl.parser.EmptyAction;
import sampl.parser.IdentifierTable;
import sampl.parser.Parser;
import sampl.sema.ASTConsumer;
import sampl.sema.EmptyASTConsumer;
import sampl.sema.IncludeDirProvider;
import sampl.sema.Sema;

public class Translator {
    private SAMPL sampl;
    private IdentifierTable identifiers;
    private DiagnosticHandler diagHandler;
    private Action action;
    private ASTConsumer consumer;
    private InputStream input;
    private Options opt;

    private static void copySMPSPart(BufferedReader reader, String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
                if (!line.equals("ENDATA")) continue;
                return;
            }
        }
        finally {
            writer.close();
        }
    }

    private static void splitSMPS(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        try {
            String filenameWithoutExt = filename.substring(0, filename.lastIndexOf(46) + 1);
            Translator.copySMPSPart(reader, String.valueOf(filenameWithoutExt) + "tim");
            Translator.copySMPSPart(reader, String.valueOf(filenameWithoutExt) + "cor");
            Translator.copySMPSPart(reader, String.valueOf(filenameWithoutExt) + "sto");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Translator(Options opt, DiagnosticHandler dh, SAMPL sampl) throws SAMPLException {
        this.opt = opt;
        this.sampl = sampl;
        License lic = new License(".", sampl.getEnvironment());
        if (lic.hasExpired()) {
            throw new LicenseException(lic.getDirectory(), "License has expired");
        }
        int SAMPL_BIT = 11;
        if ((lic.getLBits() & 0x800) == 0) {
            throw new LicenseException(lic.getDirectory(), "License does not permit the use of SAMPL translator");
        }
        this.diagHandler = dh == null ? new DiagnosticHandler(){

            @Override
            public void diagnostic(Diagnostic error) {
                String source = error.getSourceName();
                if (source != null) {
                    System.out.format("%s:", source);
                    int lineNumber = error.getLineNumber();
                    if (lineNumber != 0) {
                        System.out.format("%d:", lineNumber);
                        int columnNumber = error.getColumnNumber();
                        if (columnNumber != 0) {
                            System.out.format("%d:", columnNumber);
                        }
                    }
                    System.out.print(' ');
                }
                System.out.format("Error: %s%n", error.getMessage());
            }
        } : dh;
        this.identifiers = new IdentifierTable(false);
        final SAMPL environment = sampl;
        IncludeDirProvider includes = new IncludeDirProvider(){

            @Override
            public String getIncludes() {
                Problem problem = environment.problem;
                return problem != null ? ((ProblemMap)problem.map()).getOption("ampl_include").toString() : ".";
            }
        };
        if (!opt.noSema) {
            if (opt.noCodegen) {
                this.consumer = new EmptyASTConsumer();
            } else if (!opt.compile) {
                Interpreter interpreter = new Interpreter(sampl, this.diagHandler, !opt.noExec, opt.dumpBytecode);
                this.consumer = interpreter;
            } else {
                this.consumer = new ASTCompiler(".");
            }
            this.action = new Sema(this.diagHandler, this.consumer, this.identifiers, includes);
        } else {
            this.action = new EmptyAction();
        }
    }

    public Translator(Options opt) throws SAMPLException {
        this(opt, null, new SAMPL());
    }

    public SAMPL getSAMPL() {
        return this.sampl;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public void setInteractive() {
        this.opt.interactive = true;
    }

    /*
     * Unable to fully structure code
     */
    public void run(Source ... sources) throws IOException, SAMPLException {
        if (sources.length == 0) {
            if (this.input == null) {
                this.input = new FileInputStream(FileDescriptor.in);
            }
            output = new PrintWriter(System.out);
            reader = System.console() == null ? PromptingReader.newStreamReader(this.input, output, this.opt.interactive) : PromptingReader.newConsoleReader(this.input, output);
            try {
                prompt = ((ProblemMap)this.sampl.problem.map()).getOption("prompt1").toString();
                reader.setPrompt(prompt);
                consoleSource = new Source("<input>", reader);
                this.sampl.promptHandler = reader;
                parser = new Parser(this.action, this.identifiers, this.diagHandler);
                parser.parse(consoleSource, false);
                if (!reader.isEOF()) ** GOTO lbl47
                System.out.println();
            }
            finally {
                reader.close();
            }
        } else {
            var5_9 = sources;
            var4_7 = sources.length;
            var3_5 = 0;
            while (var3_5 < var4_7) {
                source = var5_9[var3_5];
                filename = source.getName();
                dotPos = filename.lastIndexOf(46);
                v0 = ext = dotPos != -1 ? filename.substring(dotPos + 1) : "";
                if (ext.equals("nl")) {
                    nlReader = new NLReader();
                    nlReader.read(this.sampl, Source.newFileSource(filename));
                    nlReader.dump(this.sampl.out);
                } else if (ext.equals("smps")) {
                    Translator.splitSMPS(filename);
                } else {
                    if (this.opt.pause) {
                        System.in.read();
                    }
                    parser = new Parser(this.action, this.identifiers, this.diagHandler);
                    start = System.nanoTime();
                    parser.parse(source, false);
                    if (this.opt.time) {
                        end = System.nanoTime();
                        System.out.format("Translated '%s' in %g ms.\n", new Object[]{source.getName(), (double)(end - start) / 1000000.0});
                    }
                }
                ++var3_5;
            }
        }
lbl47:
        // 3 sources

        if (this.consumer != null) {
            this.consumer.onSourcesEnd();
        }
    }

    public void close() {
        if (this.sampl != null) {
            this.sampl.close();
        }
    }

    public static class Options {
        public boolean compile;
        public boolean dumpBytecode;
        public boolean noSema;
        public boolean noCodegen;
        public boolean noExec;
        public boolean time;
        public boolean pause;
        public boolean interactive;
    }
}

