/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.List;
import sampl.lang.Constraint;
import sampl.lang.ProblemExpander;
import sampl.lang.RobustConverter;
import sampl.lang.Variable;

final class SoysterConverter
extends RobustConverter {
    SoysterConverter(ProblemExpander pe) {
        super(pe);
    }

    private void convert(Constraint con, List<RobustConverter.UncertainTerm> terms, double coef) {
        for (RobustConverter.UncertainTerm term : terms) {
            double deviation = term.coeff.getDeviation();
            con.addTerm(coef * deviation, this.buildAbsConstraints(term));
        }
    }

    @Override
    void convert(Constraint con, List<RobustConverter.UncertainTerm> terms) {
        double lb = con.lb();
        double ub = con.ub();
        if (ub != Double.POSITIVE_INFINITY) {
            if (lb == Double.NEGATIVE_INFINITY) {
                this.convert(con, terms, 1.0);
            } else {
                Variable rangeVar = this.convertRangeConstraint(con);
                Constraint auxCon = this.addConstraint(Double.NEGATIVE_INFINITY, ub);
                auxCon.addTerm(1.0, rangeVar);
                this.convert(auxCon, terms, 1.0);
                auxCon = this.addConstraint(lb, Double.POSITIVE_INFINITY);
                auxCon.addTerm(1.0, rangeVar);
                this.convert(auxCon, terms, -1.0);
            }
        } else if (lb != Double.NEGATIVE_INFINITY) {
            this.convert(con, terms, -1.0);
        }
    }
}

