/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sampl.SAMPLException;
import sampl.Util;
import sampl.lang.BenTalNemirovskiConverter;
import sampl.lang.BertsimasSimConverter;
import sampl.lang.Constraint;
import sampl.lang.ConstraintMap;
import sampl.lang.ExpandedProblem;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.Objective;
import sampl.lang.ObjectiveMap;
import sampl.lang.PiecewiseLinear;
import sampl.lang.Problem;
import sampl.lang.ProblemExpander;
import sampl.lang.ProblemMap;
import sampl.lang.RobustConverter;
import sampl.lang.SAMPL;
import sampl.lang.SolutionReader;
import sampl.lang.SoysterConverter;
import sampl.lang.Variable;
import sampl.lang.VariableMap;

public abstract class SolverConnection
implements ProblemExpander {
    private SAMPL sampl;
    private ExpandedProblem ep;
    private int numVars;
    private VariableMap auxVars;
    private ConstraintMap auxCons;
    private boolean linearizedPL;

    public SolverConnection() {
        this.auxVars = new VariableMap(this.sampl, "_x");
        this.auxCons = new ConstraintMap(this.sampl, "_c", false);
    }

    private void linearize(Objective obj, List<ObjectiveExpr> savedObjExprs) {
        Expr nonlinear = obj.getNonlinear();
        if (!(nonlinear instanceof PiecewiseLinear)) {
            return;
        }
        ObjectiveMap map = (ObjectiveMap)obj.map();
        PiecewiseLinear pl = (PiecewiseLinear)nonlinear;
        if (map.isMaximization() && pl.isConcave() || !map.isMaximization() && pl.isConvex()) {
            this.linearizedPL = true;
            savedObjExprs.add(new ObjectiveExpr(obj));
            ArrayList<LinearTerm> linearObj = new ArrayList<LinearTerm>();
            if (obj.getLinear() != null) {
                linearObj.addAll(obj.getLinear());
            }
            obj.setLinear(linearObj);
            obj.setNonlinear(null);
            int numSlopes = pl.getNumSlopes();
            Constraint con = this.addAuxConstraint(0.0, 0.0);
            con.addTerm(1.0, pl.getVariable());
            int i = 0;
            while (i < numSlopes) {
                double ub;
                double lb = 0.0;
                if (i == 0) {
                    lb = Double.NEGATIVE_INFINITY;
                    ub = pl.getBreakpoint(0);
                } else {
                    ub = i == numSlopes - 1 ? Double.POSITIVE_INFINITY : pl.getBreakpoint(i) - pl.getBreakpoint(i - 1);
                }
                Variable var = this.addAuxVariable(lb, ub);
                obj.addTerm(pl.getSlope(i), var);
                con.addTerm(-1.0, var);
                ++i;
            }
        }
    }

    ExpandedProblem expandedProblem() {
        return this.ep;
    }

    boolean linearizedPL() {
        return this.linearizedPL;
    }

    boolean convert(Problem p) throws SAMPLException {
        return false;
    }

    void restore() {
    }

    abstract void writeExpanded(ExpandedProblem var1, WriterProvider var2) throws IOException, SAMPLException;

    final void write(Problem p, String filenameWithoutExt) throws IOException, SAMPLException {
        this.write(p, new WriterProvider(filenameWithoutExt));
    }

    /*
     * Unable to fully structure code
     */
    final void write(Problem p, WriterProvider wp) throws IOException, SAMPLException {
        block36: {
            pi = p.expand();
            this.numVars = pi.variables().size();
            if (this.numVars == 0) {
                throw new SAMPLException("Problem has no variables");
            }
            map = (ProblemMap)p.map();
            this.sampl = map.sampl();
            savedObjExprs = null;
            robustConverter = null;
            try {
                if (map.getBooleanOption("pl_linearize")) {
                    savedObjExprs = new ArrayList<ObjectiveExpr>();
                    for (Objective obj : pi.objectives()) {
                        if (obj.getNonlinear() == null) continue;
                        this.linearize(obj, savedObjExprs);
                    }
                }
                for (Constraint con : pi.constraints()) {
                    if (!con.isNonlinear() || !((ConstraintMap)con.map()).isRobust()) continue;
                    if (robustConverter == null) {
                        robustForm = map.getOption("robustform");
                        if ("Soyster".equals(robustForm)) {
                            robustConverter = new SoysterConverter(this);
                        } else if ("BenTal_Nemirovski".equals(robustForm)) {
                            robustConverter = new BenTalNemirovskiConverter(this);
                        } else if ("Bertsimas_Sim".equals(robustForm)) {
                            robustConverter = new BertsimasSimConverter(this);
                        } else {
                            robustConverter = new RobustConverter(this);
                            if (robustForm != null && !robustForm.equals("")) {
                                throw new SAMPLException("Unknown RobustForm " + Util.quote(robustForm.toString()) + ". Possible values: '', 'Soyster', " + "'BenTal_Nemirovski', 'Bertsimas_Sim'");
                            }
                        }
                    }
                    robustConverter.convert(con);
                }
                preserveOrder = this.convert(p);
                writeRowNames = false;
                writeColNames = false;
                option = map.getOption("auxfiles");
                if (option != null) {
                    auxfiles = option.toString();
                    i = 0;
                    while (i < auxfiles.length()) {
                        c = auxfiles.charAt(i);
                        if (c == 'r') {
                            writeRowNames = true;
                        } else if (c == 'c') {
                            writeColNames = true;
                        }
                        ++i;
                    }
                }
                this.ep = new ExpandedProblem(p, this.auxVars, this.auxCons, preserveOrder);
                if (wp != null) {
                    if (writeColNames) {
                        writer = wp.newWriter(".col");
                        try {
                            var15_20 = this.ep.getVariables();
                            var14_21 = var15_20.length;
                            var13_19 = 0;
                            while (var13_19 < var14_21) {
                                v = var15_20[var13_19];
                                writer.append(v.name());
                                writer.append(Util.NEWLINE);
                                ++var13_19;
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    if (writeRowNames) {
                        writer = wp.newWriter(".row");
                        try {
                            var15_20 = this.ep.getConstraints();
                            var14_21 = var15_20.length;
                            var13_19 = 0;
                            while (var13_19 < var14_21) {
                                c = var15_20[var13_19];
                                writer.append(c.name());
                                writer.append(Util.NEWLINE);
                                ++var13_19;
                            }
                            var15_20 = this.ep.getObjectives();
                            var14_21 = var15_20.length;
                            var13_19 = 0;
                            while (var13_19 < var14_21) {
                                o = var15_20[var13_19];
                                writer.append(o.name());
                                writer.append(Util.NEWLINE);
                                ++var13_19;
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    this.writeExpanded(this.ep, wp);
                }
            }
            finally {
                this.restore();
                if (robustConverter != null) {
                    robustConverter.restore();
                }
                if (savedObjExprs == null) break block36;
                var19_26 = savedObjExprs.iterator();
                if (true) ** GOTO lbl117
            }
            {
            }
            do {
                oe = (ObjectiveExpr)var19_26.next();
                oe.obj.setLinear(oe.linear);
                oe.obj.setNonlinear(oe.nonlinear);
lbl117:
                // 2 sources

            } while (var19_26.hasNext());
        }
    }

    void readSolution(Problem p, String filename) throws IOException {
        Object var;
        SolutionReader reader = new SolutionReader();
        reader.read(filename, Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (((ProblemMap)p.map()).getBooleanOption("solver_msg")) {
            System.out.print(reader.getMessage());
        }
        Variable[] vars = this.ep.getVariables();
        int numVars = vars.length;
        double[] primal = reader.getVarSolution().values;
        int numPrimals = Math.min(numVars, primal.length);
        int i = 0;
        while (i < numVars) {
            double value = i < numPrimals ? primal[i] : 0.0;
            var = vars[i];
            ((Variable)var).setValue(value);
            ((Variable)var).setLRC(0.0);
            ((Variable)var).setURC(0.0);
            ++i;
        }
        var = this.ep.getObjectives();
        int n = ((Objective[])var).length;
        int value = 0;
        while (value < n) {
            Object obj = var[value];
            ((Objective)obj).computeValue();
            List objExpr = ((Objective)obj).getLinear();
            if (objExpr != null) {
                for (LinearTerm term : objExpr) {
                    Variable var2 = term.getVariable();
                    var2.setLRC(var2.lrc() + term.getCoefficient());
                    var2.setURC(var2.urc() + term.getCoefficient());
                }
            }
            ++value;
        }
        i = 0;
        Objective obj = this.ep.getObjectives()[0];
        boolean maximization = ((ObjectiveMap)obj.map()).isMaximization();
        double[] dual = reader.getConSolution().dualValues;
        Constraint[] cons = this.ep.getConstraints();
        int numDual = Math.min(cons.length, dual.length);
        Constraint[] constraintArray = cons;
        int n2 = cons.length;
        int n3 = 0;
        while (n3 < n2) {
            Constraint con = constraintArray[n3];
            con.computeBodyAndDuals(i < numDual ? dual[i] : 0.0, maximization);
            ++i;
            ++n3;
        }
        ((ProblemMap)p.map()).sampl().setSolveResult(reader.getResult());
    }

    @Override
    public Variable addAuxVariable(double lb, double ub) {
        int index = this.numVars++;
        Variable var = this.auxVars.addVariable(this.auxVars.size() + 1, lb, ub, 0.0);
        var.setIndex(index);
        return var;
    }

    @Override
    public Constraint addAuxConstraint(double lb, double ub) {
        Constraint con = this.auxCons.addConstraint(this.auxCons.size() + 1, 0.0);
        con.setBounds(lb, ub);
        return con;
    }

    private static class ObjectiveExpr {
        Objective obj;
        List<LinearTerm> linear;
        Expr nonlinear;

        ObjectiveExpr(Objective obj) {
            this.obj = obj;
            this.linear = obj.getLinear();
            this.nonlinear = obj.getNonlinear();
        }
    }

    static class WriterProvider {
        private String filenameWithoutExt;

        WriterProvider(String filenameWithoutExt) {
            this.filenameWithoutExt = filenameWithoutExt;
        }

        Writer newWriter(String suffix) throws IOException {
            return new BufferedWriter(new FileWriter(String.valueOf(this.filenameWithoutExt) + suffix));
        }

        String filenameWithoutExt() {
            return new File(this.filenameWithoutExt).getName();
        }
    }
}

