/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.Set;
import sampl.SAMPLException;
import sampl.lang.Entity;
import sampl.lang.NoDataException;
import sampl.lang.SAMPL;

public class SetMap
extends Entity<Set<Object>> {
    protected final void putInitial(Object key, Set<Object> set) {
        this.map.put(key, set);
    }

    protected final void putDefault(Object key, Set<Object> set) {
        Set<Object> prev = this.map.put(key, set);
        if (prev != null) {
            this.map.put(key, prev);
        }
    }

    protected void check() {
    }

    Set<?> getUnchecked(Object key) {
        return (Set)this.map.get(key);
    }

    public SetMap(SAMPL sampl, String name, boolean hasInitializer) {
        super(sampl, name);
        if (!hasInitializer) {
            this.setNoData();
        }
    }

    public static SetMap newSet(SAMPL sampl, String name) {
        SetMap map = new SetMap(sampl, name, true);
        map.putDefault(null, null);
        return map;
    }

    @Override
    public final Set<Object> get(Object key) throws SAMPLException {
        this.update();
        this.check();
        Set set = (Set)this.map.get(key);
        if (set != null) {
            return set;
        }
        if (this.map.containsKey(key)) {
            throw new NoDataException(this, key);
        }
        throw new SAMPLException("Invalid subscript");
    }

    public final boolean put(Object key, Set<Object> value) {
        this.update();
        int size = this.map.size();
        Set<Object> oldValue = this.map.put(key, value);
        if (oldValue == null && this.map.size() != size) {
            this.map.remove(key);
            return false;
        }
        return true;
    }
}

