/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.AbstractSet;
import java.util.Iterator;

public class Range
extends AbstractSet<Double> {
    private double start;
    private double end;
    private double step;

    public Range(double start, double end) {
        this.start = start;
        this.end = end;
        this.step = 1.0;
    }

    public Range(double start, double end, double step) {
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public int size() {
        return (int)((this.end - this.start + 1.0) / this.step);
    }

    @Override
    public Iterator<Double> iterator() {
        return new RangeIterator(this);
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public double getStep() {
        return this.step;
    }

    private static class RangeIterator
    implements Iterator<Double> {
        private double next;
        private double end;
        private double step;

        public RangeIterator(Range r) {
            this.next = r.getStart();
            this.end = r.getEnd();
            this.step = r.getStep();
        }

        @Override
        public boolean hasNext() {
            return this.step >= 0.0 ? this.next <= this.end : this.next >= this.end;
        }

        @Override
        public Double next() {
            double value = this.next;
            this.next += this.step;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

