/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sampl.lang.BinaryExpr;
import sampl.lang.CallExpr;
import sampl.lang.DiscreteRV;
import sampl.lang.Expr;
import sampl.lang.ExprVisitor;
import sampl.lang.LinearTerm;
import sampl.lang.Number;
import sampl.lang.PiecewiseLinear;
import sampl.lang.RandomLinearTerm;
import sampl.lang.SymmetricRV;
import sampl.lang.Variable;
import sampl.lang.WeightedSum;

final class RandomExprPartitioner
implements ExprVisitor {
    private Expr nonlinear;
    private List<LinearTerm> linear;
    private double constant;
    private double coefficient = 1.0;
    private List<RandomLinearTerm> randomLinear;
    private DiscreteRV randomConstant;
    private DiscreteRV randomCoefficient;

    RandomExprPartitioner() {
    }

    public Expr getNonlinear() {
        return this.nonlinear;
    }

    public List<LinearTerm> getLinear() {
        return this.linear;
    }

    public List<RandomLinearTerm> getRandomLinear() {
        return this.randomLinear;
    }

    public DiscreteRV getRandomConstant() {
        return this.randomConstant;
    }

    public double getConstant() {
        return this.constant;
    }

    public void partition(Expr e) {
        e.accept(this);
        if (this.randomConstant != null) {
            this.randomConstant = this.randomConstant.add(this.constant);
            this.constant = 0.0;
        }
        if (this.randomLinear == null) {
            return;
        }
        Collections.sort(this.randomLinear);
        int size = this.randomLinear.size();
        ArrayList<RandomLinearTerm> combined = new ArrayList<RandomLinearTerm>(size);
        RandomLinearTerm last = this.randomLinear.get(0);
        combined.add(last);
        int i = 1;
        while (i < size) {
            RandomLinearTerm term = this.randomLinear.get(i);
            if (last.getVariable() != term.getVariable()) {
                combined.add(term);
                last = term;
            } else {
                DiscreteRV coef = term.getCoefficient().addScaled(1.0, last.getCoefficient());
                combined.set(combined.size() - 1, new RandomLinearTerm(coef, term.getVariable()));
            }
            ++i;
        }
        this.randomLinear = combined;
    }

    private void addToRandomConstant(double d, DiscreteRV r) {
        this.randomConstant = this.randomConstant != null ? this.randomConstant.addScaled(d, r) : r.mul(d);
    }

    private void addNonlinear(Expr expr) {
        if (this.coefficient == 1.0) {
            this.nonlinear = this.nonlinear != null ? WeightedSum.newAddition(this.nonlinear, expr) : expr;
        } else if (this.coefficient == -1.0) {
            this.nonlinear = this.nonlinear != null ? WeightedSum.newSubtraction(this.nonlinear, expr) : WeightedSum.newNegation(expr);
        } else {
            Expr mul = BinaryExpr.mul(expr, this.coefficient);
            this.nonlinear = this.nonlinear != null ? WeightedSum.newAddition(this.nonlinear, mul) : mul;
        }
    }

    @Override
    public void visit(Number n) {
        double value = this.coefficient * n.value();
        if (this.randomCoefficient != null) {
            this.addToRandomConstant(value, this.randomCoefficient);
        } else {
            this.constant += value;
        }
    }

    @Override
    public void visit(Variable v) {
        if (this.randomCoefficient != null) {
            if (this.randomLinear == null) {
                this.randomLinear = new ArrayList<RandomLinearTerm>();
            }
            this.randomLinear.add(new RandomLinearTerm(this.randomCoefficient.mul(this.coefficient), v));
        } else {
            if (this.linear == null) {
                this.linear = new ArrayList<LinearTerm>();
            }
            this.linear.add(new LinearTerm(this.coefficient, v));
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        switch (expr.getOpCode()) {
            case 2: {
                Expr lhs = expr.getLHS();
                Expr rhs = expr.getRHS();
                if (lhs instanceof Number) {
                    double savedCoefficient = this.coefficient;
                    this.coefficient *= ((Number)lhs).value();
                    rhs.accept(this);
                    this.coefficient = savedCoefficient;
                    break;
                }
                if (rhs instanceof Number) {
                    double savedCoefficient = this.coefficient;
                    this.coefficient *= ((Number)rhs).value();
                    lhs.accept(this);
                    this.coefficient = savedCoefficient;
                    break;
                }
                if (lhs instanceof DiscreteRV) {
                    DiscreteRV savedCoefficient = this.randomCoefficient;
                    this.randomCoefficient = this.randomCoefficient != null ? this.randomCoefficient.mul((DiscreteRV)lhs) : (DiscreteRV)lhs;
                    rhs.accept(this);
                    this.randomCoefficient = savedCoefficient;
                    break;
                }
                if (rhs instanceof DiscreteRV) {
                    DiscreteRV savedCoefficient = this.randomCoefficient;
                    this.randomCoefficient = this.randomCoefficient != null ? this.randomCoefficient.mul((DiscreteRV)rhs) : (DiscreteRV)rhs;
                    lhs.accept(this);
                    this.randomCoefficient = savedCoefficient;
                    break;
                }
            }
            default: {
                this.addNonlinear(expr);
            }
        }
    }

    @Override
    public void visit(WeightedSum expr) {
        int i = 0;
        int n = expr.size();
        while (i < n) {
            double savedCoefficient = this.coefficient;
            this.coefficient *= expr.getWeight(i);
            expr.getExpr(i).accept(this);
            this.coefficient = savedCoefficient;
            ++i;
        }
    }

    @Override
    public void visit(PiecewiseLinear pl) {
        this.addNonlinear(pl);
    }

    @Override
    public void visit(CallExpr expr) {
        this.addNonlinear(expr);
    }

    @Override
    public void visit(DiscreteRV rv) {
        if (this.randomCoefficient != null) {
            rv = rv.mul(this.randomCoefficient);
        }
        this.addToRandomConstant(this.coefficient, rv);
    }

    @Override
    public void visit(SymmetricRV rv) {
        throw new AssertionError((Object)"Random variable with unspecified (symmetric) distribution in SP problem");
    }
}

