/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import jline.ConsoleReader;
import jline.CursorBuffer;
import sampl.lang.PromptHandler;

public abstract class PromptingReader
extends Reader
implements PromptHandler {
    private String line = "";
    private int position;

    abstract void doClose() throws IOException;

    abstract String readLine() throws IOException;

    static PromptingReader newConsoleReader(InputStream in, Writer out) throws IOException {
        return new ConsolePromptingReader(in, out);
    }

    static PromptingReader newStreamReader(InputStream in, Writer out, boolean interactive) throws IOException {
        return new StreamPromptingReader(in, out, interactive);
    }

    final boolean isEOF() {
        return this.line == null;
    }

    @Override
    public final void close() throws IOException {
        this.line = null;
        this.position = -1;
        this.doClose();
    }

    @Override
    public final int read(char[] cbuf, int off, int len) throws IOException {
        if (this.line == null) {
            if (this.position == -1) {
                throw new IOException("Trying to read from a closed stream.");
            }
            return -1;
        }
        if (this.position == this.line.length()) {
            this.line = this.readLine();
            if (this.line == null) {
                return -1;
            }
            this.line = String.valueOf(this.line) + '\n';
            this.position = 0;
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = Math.min(this.line.length() - this.position, len);
        int end = this.position + count;
        while (this.position < end) {
            cbuf[off] = this.line.charAt(this.position);
            ++this.position;
            ++off;
        }
        return count;
    }

    private static final class ConsolePromptingReader
    extends PromptingReader {
        private ConsoleReader consoleReader;

        ConsolePromptingReader(InputStream in, Writer out) throws IOException {
            this.consoleReader = new ConsoleReader(in, out);
        }

        @Override
        public void setPrompt(String prompt) {
            this.consoleReader.setDefaultPrompt(prompt);
        }

        @Override
        void doClose() throws IOException {
            this.consoleReader.getInput().close();
        }

        @Override
        String readLine() throws IOException {
            String line = this.consoleReader.readLine();
            if (line != null) {
                return line;
            }
            CursorBuffer buffer = this.consoleReader.getCursorBuffer();
            if (buffer.length() == 0) {
                return null;
            }
            line = buffer.toString();
            buffer.clearBuffer();
            this.consoleReader.setDefaultPrompt(null);
            return line;
        }
    }

    private static final class StreamPromptingReader
    extends PromptingReader {
        private String prompt;
        private StringBuilder buffer = new StringBuilder();
        private InputStream in;
        private Writer out;
        private boolean interactive;

        StreamPromptingReader(InputStream in, Writer out, boolean interactive) {
            this.in = in;
            this.out = out;
            this.interactive = interactive;
        }

        @Override
        public void setPrompt(String prompt) {
            if (this.interactive) {
                this.prompt = prompt;
            }
        }

        @Override
        void doClose() throws IOException {
            this.in.close();
        }

        @Override
        String readLine() throws IOException {
            if (this.prompt != null) {
                this.out.write(this.prompt);
                this.out.flush();
            }
            this.buffer.setLength(0);
            while (true) {
                int c = this.in.read();
                switch (c) {
                    case 10: {
                        return this.buffer.toString();
                    }
                    case -1: {
                        this.prompt = null;
                        return this.buffer.length() == 0 ? null : this.buffer.toString();
                    }
                }
                this.buffer.append((char)c);
            }
        }
    }
}

