/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sampl.lang.AStatus;
import sampl.lang.AbstractExprVisitor;
import sampl.lang.Constraint;
import sampl.lang.ConstraintMap;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.MapItem;
import sampl.lang.Objective;
import sampl.lang.ObjectiveMap;
import sampl.lang.Parameter;
import sampl.lang.ProblemMap;
import sampl.lang.SStatus;
import sampl.lang.Variable;
import sampl.lang.VariableMap;

public final class Problem
extends MapItem<ProblemMap> {
    private List<VariableMap> variables = new ArrayList<VariableMap>();
    private List<ObjectiveMap> objectives = new ArrayList<ObjectiveMap>();
    private List<ConstraintMap> constraints = new ArrayList<ConstraintMap>();
    private Parameter probabilities;
    private int exitcode;
    private String message = "?";
    private String result = "?";
    private int astatus;
    private int sstatus;
    private Instance instance;
    private boolean expanding;

    Problem(ProblemMap map, Object key) {
        super(map, key);
    }

    public List<VariableMap> variables() {
        return this.variables;
    }

    public List<ObjectiveMap> objectives() {
        return this.objectives;
    }

    public List<ConstraintMap> constraints() {
        return this.constraints;
    }

    public void add(VariableMap v) {
        this.instance = null;
        this.variables.add(v);
    }

    public void add(ObjectiveMap o) {
        this.instance = null;
        this.objectives.add(o);
    }

    public void add(ConstraintMap c) {
        this.instance = null;
        this.constraints.add(c);
    }

    public int exitcode() {
        return this.exitcode;
    }

    public double exitcodeInternal() {
        return this.exitcode;
    }

    void setExitcode(int exitcode) {
        this.exitcode = exitcode;
    }

    public String message() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String result() {
        return this.result;
    }

    void setResult(String result) {
        this.result = result;
    }

    public AStatus astatus() {
        return AStatus.map[this.astatus];
    }

    void setAStatus(AStatus s) {
        this.astatus = s.ordinal();
    }

    public String astatusInternal() {
        return this.astatus().toString().toLowerCase();
    }

    public SStatus sstatus() {
        return SStatus.map[this.sstatus];
    }

    public String sstatusInternal() {
        return this.sstatus().toString().toLowerCase();
    }

    void setSStatus(SStatus s) {
        this.sstatus = s.ordinal();
    }

    public Parameter probabilities() {
        return this.probabilities;
    }

    public void setProbabilities(Parameter p) {
        this.probabilities = p;
    }

    private Instance doExpand() {
        Expr nonlinear;
        List linear;
        ArrayList<Objective> objs = new ArrayList<Objective>();
        for (ObjectiveMap map : this.objectives) {
            map.expand();
            for (Map.Entry entry : map.entrySet()) {
                objs.add((Objective)entry.getValue());
            }
        }
        ArrayList<Constraint> cons = new ArrayList<Constraint>();
        for (ConstraintMap map : this.constraints) {
            map.expand();
            for (Map.Entry entry : map.entrySet()) {
                cons.add((Constraint)entry.getValue());
            }
        }
        int numVars = 0;
        for (VariableMap variableMap : this.variables) {
            variableMap.expand();
            for (Map.Entry entry : variableMap.entrySet()) {
                Variable var = (Variable)entry.getValue();
                if (var.astatus() != AStatus.FIX) {
                    var.setAStatus(AStatus.UNUSED);
                }
                var.setIndex(numVars++);
            }
        }
        VariableUsageCounter variableUsageCounter = new VariableUsageCounter();
        for (Objective objective : objs) {
            linear = objective.getLinear();
            if (linear != null) {
                linear = LinearTerm.combineLikeTerms(linear);
                objective.setLinear(linear);
                for (LinearTerm term : linear) {
                    variableUsageCounter.useVariable(term.getVariable());
                }
            }
            if ((nonlinear = objective.getNonlinear()) == null) continue;
            nonlinear.accept(variableUsageCounter);
        }
        for (Constraint constraint : cons) {
            linear = constraint.getLinear();
            if (linear != null) {
                linear = LinearTerm.combineLikeTerms(linear);
                constraint.setLinear(linear);
                for (LinearTerm term : linear) {
                    variableUsageCounter.useVariable(term.getVariable());
                }
            }
            if ((nonlinear = constraint.getNonlinear()) == null) continue;
            nonlinear.accept(variableUsageCounter);
        }
        int n = variableUsageCounter.numUsedVars();
        ArrayList<Variable> vars = new ArrayList<Variable>(n);
        for (VariableMap map : this.variables) {
            for (Map.Entry entry : map.entrySet()) {
                Variable v = (Variable)entry.getValue();
                if (v.astatus() == AStatus.UNUSED) continue;
                vars.add(v);
            }
        }
        return new Instance(vars, objs, cons);
    }

    final Instance expand() {
        if (this.instance == null) {
            ((ProblemMap)this.map()).update();
            if (!this.expanding) {
                this.expanding = true;
                try {
                    this.instance = this.doExpand();
                }
                finally {
                    this.expanding = false;
                }
            }
        }
        return this.instance;
    }

    void invalidate() {
        this.instance = null;
    }

    public String toString() {
        return "problem " + this.name() + ";";
    }

    static class Instance {
        private List<Variable> vars;
        private List<Objective> objs;
        private List<Constraint> cons;

        private Instance(List<Variable> vars, List<Objective> objs, List<Constraint> cons) {
            this.vars = vars;
            this.objs = objs;
            this.cons = cons;
        }

        List<Variable> variables() {
            return this.vars;
        }

        List<Objective> objectives() {
            return this.objs;
        }

        List<Constraint> constraints() {
            return this.cons;
        }
    }

    private static class VariableUsageCounter
    extends AbstractExprVisitor {
        private int numUsedVars;

        private VariableUsageCounter() {
        }

        void useVariable(Variable var) {
            AStatus astatus = var.astatus();
            if (astatus == AStatus.IN) {
                return;
            }
            ++this.numUsedVars;
            if (astatus == AStatus.UNUSED) {
                var.setAStatus(AStatus.IN);
            }
        }

        int numUsedVars() {
            return this.numUsedVars;
        }

        @Override
        public void visit(Variable var) {
            this.useVariable(var);
        }
    }
}

