/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import sampl.lang.AbstractExpr;
import sampl.lang.ExprVisitor;
import sampl.lang.NLConnection;
import sampl.lang.Variable;

public final class PiecewiseLinear
extends AbstractExpr {
    private double[] breakpoints;
    private double[] slopes;
    private double[] intercepts;
    private Variable var;

    public PiecewiseLinear(double[] breakpoints, double[] slopes, Variable var) {
        this.breakpoints = breakpoints;
        this.slopes = slopes;
        this.var = var;
        this.intercepts = PiecewiseLinear.computeIntercepts(breakpoints, slopes);
    }

    public Variable getVariable() {
        return this.var;
    }

    public int getNumSlopes() {
        return this.slopes.length;
    }

    public double getSlope(int index) {
        return this.slopes[index];
    }

    public double getBreakpoint(int index) {
        return this.breakpoints[index];
    }

    public static double[] computeIntercepts(double[] breakpoints, double[] slopes) {
        double[] intercepts = new double[slopes.length];
        int found = 0;
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] >= 0.0) {
                found = i;
                break;
            }
            ++i;
        }
        i = found - 1;
        while (i >= 0) {
            intercepts[i] = slopes[i + 1] * breakpoints[i] + intercepts[i + 1] - slopes[i] * breakpoints[i];
            --i;
        }
        i = found;
        while (i < breakpoints.length) {
            intercepts[i + 1] = slopes[i] * breakpoints[i] + intercepts[i] - slopes[i + 1] * breakpoints[i];
            ++i;
        }
        return intercepts;
    }

    public static double getValue(double[] breakpoints, double[] slopes, double[] intercepts, double value) {
        int i = 0;
        while (i < breakpoints.length && value > breakpoints[i]) {
            ++i;
        }
        return value * slopes[i] + intercepts[i];
    }

    public boolean isConvex() {
        double lastSlope = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.slopes.length) {
            if (this.slopes[i] < lastSlope) {
                return false;
            }
            lastSlope = this.slopes[i];
            ++i;
        }
        return true;
    }

    public boolean isConcave() {
        double lastSlope = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.slopes.length) {
            if (this.slopes[i] > lastSlope) {
                return false;
            }
            lastSlope = this.slopes[i];
            ++i;
        }
        return true;
    }

    @Override
    public boolean hasVariables() {
        return true;
    }

    @Override
    public double eval() {
        return PiecewiseLinear.getValue(this.breakpoints, this.slopes, this.intercepts, this.var.val());
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) throws IOException {
        c.writeOp(64);
        c.writeInt(this.slopes.length);
        int i = 0;
        while (i < this.breakpoints.length) {
            c.writeConstant(this.slopes[i]);
            c.writeConstant(this.breakpoints[i]);
            ++i;
        }
        c.writeConstant(this.slopes[this.slopes.length - 1]);
        c.write(this.var);
    }
}

