/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.Map;
import sampl.SAMPLException;
import sampl.Tuple;
import sampl.lang.DiscreteRV;
import sampl.lang.Entity;
import sampl.lang.NoDataException;
import sampl.lang.SAMPL;

public class Parameter
extends Entity<Object> {
    private Object defaultValue;
    private boolean checked;

    protected final void putInitial(Object key, Object obj) {
        this.map.put(key, obj);
    }

    protected final void putDefault(Object key, Object obj) {
        Object prev = this.map.put(key, obj);
        if (prev != null) {
            this.map.put(key, prev);
        }
    }

    @Override
    protected void init() {
    }

    public final void prepareForData() {
        this.clearNoData();
        if (this.isValid()) {
            this.invalidateDependents();
        }
    }

    protected void check(SAMPL env) {
    }

    final Object getUnchecked(Object key) {
        return this.map.get(key);
    }

    public Parameter(SAMPL sampl, String name, boolean hasInitializer) {
        super(sampl, name);
        if (!hasInitializer) {
            this.setNoData();
        }
    }

    public static Parameter newParameter(SAMPL sampl, String name) {
        Parameter p = new Parameter(sampl, name, true);
        p.putDefault(null, null);
        return p;
    }

    public void setDefault(Object value) {
        this.defaultValue = value;
    }

    public String toString() {
        this.update();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.checked = false;
    }

    @Override
    public final Object get(Object key) throws SAMPLException {
        Object value;
        if (!this.checked) {
            this.update();
            this.check(this.sampl());
            this.checked = true;
        }
        if ((value = this.map.get(key)) != null) {
            return value;
        }
        if (this.map.containsKey(key) || key == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new NoDataException(this, key);
        }
        throw new SAMPLException("Invalid subscript");
    }

    public final DiscreteRV getStochastic() throws SAMPLException {
        Parameter prob = this.sampl().problem.probabilities();
        if (prob == null) {
            throw new SAMPLException("Probabilities are not specified");
        }
        double[] realizations = new double[prob.size()];
        int realizationIndex = 0;
        for (Map.Entry p : prob.entrySet()) {
            realizations[realizationIndex++] = (Double)this.get(p.getKey());
        }
        return new DiscreteRV(realizations);
    }

    public final DiscreteRV getStochastic(Tuple tuple, int scenarioItemIndex) throws SAMPLException {
        Parameter prob = this.sampl().problem.probabilities();
        double[] realizations = new double[prob.size()];
        int realizationIndex = 0;
        Object[] items = tuple.elements();
        for (Map.Entry p : prob.entrySet()) {
            items[scenarioItemIndex] = p.getKey();
            realizations[realizationIndex++] = (Double)this.get(new Tuple(items));
        }
        return new DiscreteRV(realizations);
    }

    public final boolean put(Object key, double value) {
        this.update();
        int size = this.map.size();
        if (this.map.put(key, value) == null && this.map.size() != size) {
            this.map.remove(key);
            return false;
        }
        return true;
    }

    public final boolean put(Object key, String value) {
        this.update();
        int size = this.map.size();
        if (this.map.put(key, value) == null && this.map.size() != size) {
            this.map.remove(key);
            return false;
        }
        return true;
    }

    public final boolean put(Object key, Object value) {
        this.update();
        int size = this.map.size();
        if (this.map.put(key, value) == null && this.map.size() != size) {
            this.map.remove(key);
            return false;
        }
        return true;
    }

    public final void insert(Object key, Object value) {
        this.map.put(key, value);
    }
}

