/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import sampl.Util;
import sampl.lang.Evaluable;
import sampl.lang.Expr;
import sampl.lang.ExprBuilder;
import sampl.lang.ExprPrinter;
import sampl.lang.LinearTerm;
import sampl.lang.MapItemWithExpr;
import sampl.lang.ObjectiveMap;

public final class Objective
extends MapItemWithExpr<ObjectiveMap>
implements Evaluable {
    private double constant;
    private double value;
    private int exitcode = -1;
    private String message = "?";
    private String result = "?";

    Objective(ObjectiveMap map, Object key) {
        super(map, key);
    }

    public double val() {
        return this.value;
    }

    @Deprecated
    void setValue(double value) {
        this.value = value;
    }

    public int exitcode() {
        return this.exitcode;
    }

    public double exitcodeInternal() {
        return this.exitcode;
    }

    void setExitcode(int exitcode) {
        this.exitcode = exitcode;
    }

    public String message() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String result() {
        return this.result;
    }

    void setResult(String result) {
        this.result = result;
    }

    public void setExpr(ExprBuilder eb) {
        this.setLinear(eb.getLinear(false));
        this.setNonlinear(eb.getNonlinear());
        this.constant = eb.getConstant();
    }

    public double constant() {
        return this.constant;
    }

    public void setConstant(double c) {
        this.constant = c;
    }

    void computeValue() {
        Expr nonlinear;
        this.value = this.constant;
        List linear = this.getLinear();
        if (linear != null) {
            for (LinearTerm term : linear) {
                this.value += term.getCoefficient() * term.getVariable().val();
            }
        }
        if ((nonlinear = this.getNonlinear()) != null) {
            this.value += nonlinear.eval();
        }
    }

    private void printHead(Writer writer) throws IOException {
        writer.append(((ObjectiveMap)this.map()).isMaximization() ? "maximize " : "minimize ");
        writer.append(this.name()).append(':');
    }

    public void expand(Writer writer) throws IOException {
        this.printHead(writer);
        writer.append(Util.NEWLINE).append('\t');
        ExprPrinter.print(writer, this.getNonlinear(), this.getLinear(), this.constant);
        writer.append(';').append(Util.NEWLINE);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.printHead(writer);
            writer.append(' ');
            ExprPrinter.print(writer, this.getNonlinear(), this.getLinear(), this.constant);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        writer.append(';');
        return writer.toString();
    }

    @Override
    public double eval() {
        return this.val();
    }
}

